/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.plugin;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.keyple.core.plugin.AbstractMonitoringJob;
import org.eclipse.keyple.core.plugin.AbstractObservableLocalReader;
import org.eclipse.keyple.core.plugin.AbstractObservableState;
import org.eclipse.keyple.core.plugin.AbstractReader;
import org.eclipse.keyple.core.service.Reader;
import org.eclipse.keyple.core.service.exception.KeypleReaderIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CardPresentMonitoringJob
extends AbstractMonitoringJob {
    private static final Logger logger = LoggerFactory.getLogger(CardPresentMonitoringJob.class);
    private final long waitTimeout;
    private final boolean monitorInsertion;
    private final Reader reader;
    private final AtomicBoolean loop = new AtomicBoolean();

    public CardPresentMonitoringJob(Reader reader, long waitTimeout, boolean monitorInsertion) {
        this.waitTimeout = waitTimeout;
        this.reader = reader;
        this.monitorInsertion = monitorInsertion;
    }

    @Override
    Runnable getMonitoringJob(final AbstractObservableState state) {
        return new Runnable(){
            long retries = 0L;

            @Override
            public void run() {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("[{}] Polling from isCardPresent", (Object)CardPresentMonitoringJob.this.reader.getName());
                    }
                    CardPresentMonitoringJob.this.loop.set(true);
                    while (CardPresentMonitoringJob.this.loop.get()) {
                        if (CardPresentMonitoringJob.this.monitorInsertion && CardPresentMonitoringJob.this.reader.isCardPresent()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("[{}] The card is present ", (Object)CardPresentMonitoringJob.this.reader.getName());
                            }
                            try {
                                state.onEvent(AbstractObservableLocalReader.InternalEvent.CARD_INSERTED);
                                return;
                            }
                            catch (KeypleReaderIOException e) {
                                logger.warn("[{}] waitForCardPresent => Error while processing card insertion event", (Object)CardPresentMonitoringJob.this.reader.getName());
                            }
                        }
                        if (!CardPresentMonitoringJob.this.monitorInsertion && !CardPresentMonitoringJob.this.reader.isCardPresent()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("[{}] The card is not present ", (Object)CardPresentMonitoringJob.this.reader.getName());
                            }
                            CardPresentMonitoringJob.this.loop.set(false);
                            try {
                                state.onEvent(AbstractObservableLocalReader.InternalEvent.CARD_REMOVED);
                                return;
                            }
                            catch (KeypleReaderIOException e) {
                                logger.warn("[{}] waitForCardAbsent => Error while processing card removal event", (Object)CardPresentMonitoringJob.this.reader.getName());
                            }
                        }
                        ++this.retries;
                        if (logger.isTraceEnabled()) {
                            logger.trace("[{}] isCardPresent polling retries : {}", (Object)CardPresentMonitoringJob.this.reader.getName(), (Object)this.retries);
                        }
                        try {
                            Thread.sleep(CardPresentMonitoringJob.this.waitTimeout);
                        }
                        catch (InterruptedException ignored) {
                            Thread.currentThread().interrupt();
                            CardPresentMonitoringJob.this.loop.set(false);
                        }
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("[{}] Looping has been stopped", (Object)CardPresentMonitoringJob.this.reader.getName());
                    }
                }
                catch (RuntimeException e) {
                    ((AbstractObservableLocalReader)CardPresentMonitoringJob.this.reader).getObservationExceptionHandler().onReaderObservationError(((AbstractReader)CardPresentMonitoringJob.this.reader).getPluginName(), CardPresentMonitoringJob.this.reader.getName(), e);
                }
            }
        };
    }

    @Override
    void stop() {
        if (logger.isDebugEnabled()) {
            logger.debug("[{}] Stop polling ", (Object)this.reader.getName());
        }
        this.loop.set(false);
    }
}

