/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.plugin;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.keyple.core.plugin.AbstractMonitoringJob;
import org.eclipse.keyple.core.plugin.AbstractObservableLocalReader;
import org.eclipse.keyple.core.plugin.AbstractObservableState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CardAbsentPingMonitoringJob
extends AbstractMonitoringJob {
    private static final Logger logger = LoggerFactory.getLogger(CardAbsentPingMonitoringJob.class);
    private final AbstractObservableLocalReader reader;
    private final AtomicBoolean loop = new AtomicBoolean();
    private long removalWait = 200L;

    public CardAbsentPingMonitoringJob(AbstractObservableLocalReader reader) {
        this.reader = reader;
    }

    public CardAbsentPingMonitoringJob(AbstractObservableLocalReader reader, long removalWait) {
        this.reader = reader;
        this.removalWait = removalWait;
    }

    @Override
    Runnable getMonitoringJob(final AbstractObservableState state) {
        return new Runnable(){
            long retries = 0L;

            @Override
            public void run() {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("[{}] Polling from isCardPresentPing", (Object)CardAbsentPingMonitoringJob.this.reader.getName());
                    }
                    CardAbsentPingMonitoringJob.this.loop.set(true);
                    while (CardAbsentPingMonitoringJob.this.loop.get()) {
                        if (!CardAbsentPingMonitoringJob.this.reader.isCardPresentPing()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("[{}] the card stopped responding", (Object)CardAbsentPingMonitoringJob.this.reader.getName());
                            }
                            state.onEvent(AbstractObservableLocalReader.InternalEvent.CARD_REMOVED);
                            return;
                        }
                        ++this.retries;
                        if (logger.isTraceEnabled()) {
                            logger.trace("[{}] Polling retries : {}", (Object)CardAbsentPingMonitoringJob.this.reader.getName(), (Object)this.retries);
                        }
                        try {
                            Thread.sleep(CardAbsentPingMonitoringJob.this.removalWait);
                        }
                        catch (InterruptedException ignored) {
                            Thread.currentThread().interrupt();
                            CardAbsentPingMonitoringJob.this.loop.set(false);
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("[{}] Polling loop has been stopped", (Object)CardAbsentPingMonitoringJob.this.reader.getName());
                    }
                }
                catch (RuntimeException e) {
                    CardAbsentPingMonitoringJob.this.reader.getObservationExceptionHandler().onReaderObservationError(CardAbsentPingMonitoringJob.this.reader.getPluginName(), CardAbsentPingMonitoringJob.this.reader.getName(), e);
                }
            }
        };
    }

    @Override
    void stop() {
        if (logger.isDebugEnabled()) {
            logger.debug("[{}] Stop Polling ", (Object)this.reader.getName());
        }
        this.loop.set(false);
    }
}

