/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.plugin;

import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.eclipse.keyple.core.plugin.AbstractObservablePlugin;
import org.eclipse.keyple.core.plugin.AbstractReader;
import org.eclipse.keyple.core.service.Reader;
import org.eclipse.keyple.core.service.event.ObservablePlugin;
import org.eclipse.keyple.core.service.event.PluginEvent;
import org.eclipse.keyple.core.service.event.PluginObservationExceptionHandler;
import org.eclipse.keyple.core.service.exception.KeypleReaderException;
import org.eclipse.keyple.core.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThreadedObservablePlugin
extends AbstractObservablePlugin {
    private static final Logger logger = LoggerFactory.getLogger(AbstractThreadedObservablePlugin.class);
    private static final long SETTING_THREAD_TIMEOUT_DEFAULT = 1000L;
    private EventThread thread;
    protected long threadWaitTimeout = 1000L;

    protected AbstractThreadedObservablePlugin(String name) {
        super(name);
    }

    protected abstract SortedSet<String> fetchNativeReadersNames();

    protected abstract Reader fetchNativeReader(String var1);

    @Override
    public final void addObserver(ObservablePlugin.PluginObserver observer) {
        Assert.getInstance().notNull(observer, "observer");
        super.addObserver(observer);
        if (this.countObservers() == 1) {
            if (this.getObservationExceptionHandler() == null) {
                throw new IllegalStateException("No plugin observation exception handler has been set.");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Start monitoring the plugin {}", (Object)this.getName());
            }
            this.thread = new EventThread(this.getName());
            this.thread.setName("PluginEventMonitoringThread");
            this.thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    AbstractThreadedObservablePlugin.this.getObservationExceptionHandler().onPluginObservationError(AbstractThreadedObservablePlugin.this.thread.pluginName, e);
                }
            });
            this.thread.start();
        }
    }

    @Override
    public final void removeObserver(ObservablePlugin.PluginObserver observer) {
        super.removeObserver(observer);
        if (this.countObservers() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Stop the plugin monitoring.");
            }
            if (this.thread != null) {
                this.thread.end();
            }
        }
    }

    @Override
    public final void clearObservers() {
        super.clearObservers();
        if (this.thread != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Stop the plugin monitoring.");
            }
            this.thread.end();
        }
    }

    Boolean isMonitoring() {
        return this.thread != null && this.thread.isAlive() && this.thread.isMonitoring();
    }

    protected abstract PluginObservationExceptionHandler getObservationExceptionHandler();

    private class EventThread
    extends Thread {
        private final String pluginName;
        private boolean running = true;

        private EventThread(String pluginName) {
            this.pluginName = pluginName;
        }

        void end() {
            this.running = false;
            this.interrupt();
        }

        boolean isMonitoring() {
            return this.running;
        }

        private void addReader(String readerName) {
            Reader reader = AbstractThreadedObservablePlugin.this.fetchNativeReader(readerName);
            ((AbstractReader)reader).register();
            AbstractThreadedObservablePlugin.this.readers.put(reader.getName(), reader);
            if (logger.isTraceEnabled()) {
                logger.trace("[{}][{}] Plugin thread => Add plugged reader to readers list.", (Object)this.pluginName, (Object)reader.getName());
            }
        }

        private void removeReader(Reader reader) {
            ((AbstractReader)reader).unregister();
            AbstractThreadedObservablePlugin.this.readers.remove(reader.getName());
            if (logger.isTraceEnabled()) {
                logger.trace("[{}][{}] Plugin thread => Remove unplugged reader from readers list.", (Object)this.pluginName, (Object)reader.getName());
            }
        }

        private void notifyChanges(PluginEvent.EventType eventType, SortedSet<String> changedReaderNames) {
            if (logger.isTraceEnabled()) {
                logger.trace("Notifying {}(s): {}", (Object)(eventType == PluginEvent.EventType.READER_CONNECTED ? "connection" : "disconnection"), changedReaderNames);
            }
            AbstractThreadedObservablePlugin.this.notifyObservers(new PluginEvent(this.pluginName, changedReaderNames, eventType));
        }

        private void processChanges(Set<String> actualNativeReadersNames) {
            ConcurrentSkipListSet<String> changedReaderNames = new ConcurrentSkipListSet<String>();
            Collection readerCollection = AbstractThreadedObservablePlugin.this.readers.values();
            for (Reader reader : readerCollection) {
                if (actualNativeReadersNames.contains(reader.getName())) continue;
                changedReaderNames.add(reader.getName());
            }
            if (!changedReaderNames.isEmpty()) {
                for (Reader reader : readerCollection) {
                    if (actualNativeReadersNames.contains(reader.getName())) continue;
                    this.removeReader(reader);
                }
                this.notifyChanges(PluginEvent.EventType.READER_DISCONNECTED, changedReaderNames);
                changedReaderNames.clear();
            }
            for (String readerName : actualNativeReadersNames) {
                if (AbstractThreadedObservablePlugin.this.getReaderNames().contains(readerName)) continue;
                this.addReader(readerName);
                changedReaderNames.add(readerName);
            }
            if (!changedReaderNames.isEmpty()) {
                this.notifyChanges(PluginEvent.EventType.READER_CONNECTED, changedReaderNames);
            }
        }

        @Override
        public void run() {
            try {
                while (this.running) {
                    SortedSet<String> actualNativeReadersNames = AbstractThreadedObservablePlugin.this.fetchNativeReadersNames();
                    Set<String> currentlyRegisteredReaderNames = AbstractThreadedObservablePlugin.this.getReaderNames();
                    if (!currentlyRegisteredReaderNames.containsAll(actualNativeReadersNames) || !actualNativeReadersNames.containsAll(currentlyRegisteredReaderNames)) {
                        this.processChanges(actualNativeReadersNames);
                    }
                    Thread.sleep(AbstractThreadedObservablePlugin.this.threadWaitTimeout);
                }
            }
            catch (InterruptedException e) {
                logger.info("[{}] The observation of this plugin is stopped, possibly because there is no more registered observer.", (Object)this.pluginName);
                Thread.currentThread().interrupt();
            }
            catch (KeypleReaderException e) {
                logger.warn("[{}] An exception occurred while monitoring plugin: {}", new Object[]{this.pluginName, e.getMessage(), e});
            }
        }
    }
}

