/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.plugin;

import java.util.List;
import org.eclipse.keyple.core.card.message.CardRequest;
import org.eclipse.keyple.core.card.message.CardResponse;
import org.eclipse.keyple.core.card.message.CardSelectionRequest;
import org.eclipse.keyple.core.card.message.CardSelectionResponse;
import org.eclipse.keyple.core.card.message.ChannelControl;
import org.eclipse.keyple.core.card.message.ProxyReader;
import org.eclipse.keyple.core.card.selection.MultiSelectionProcessing;
import org.eclipse.keyple.core.service.exception.KeypleReaderIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReader
implements ProxyReader {
    private final String name;
    private static final Logger logger = LoggerFactory.getLogger(AbstractReader.class);
    private long before;
    private final String pluginName;
    protected boolean isRegistered;

    protected AbstractReader(String pluginName, String name) {
        this.name = name;
        this.pluginName = pluginName;
        this.isRegistered = true;
        if (logger.isDebugEnabled()) {
            this.before = System.nanoTime();
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final String getPluginName() {
        return this.pluginName;
    }

    @Override
    public final List<CardSelectionResponse> transmitCardSelectionRequests(List<CardSelectionRequest> cardSelectionRequests, MultiSelectionProcessing multiSelectionProcessing, ChannelControl channelControl) {
        List<CardSelectionResponse> cardSelectionResponses;
        long elapsed10ms;
        long timeStamp;
        this.checkStatus();
        if (logger.isDebugEnabled()) {
            timeStamp = System.nanoTime();
            elapsed10ms = (timeStamp - this.before) / 100000L;
            this.before = timeStamp;
            logger.debug("[{}] transmit => CARDREQUESTLIST = {}, elapsed {} ms.", new Object[]{this.getName(), cardSelectionRequests, (double)elapsed10ms / 10.0});
        }
        try {
            cardSelectionResponses = this.processCardSelectionRequests(cardSelectionRequests, multiSelectionProcessing, channelControl);
        }
        catch (KeypleReaderIOException ex) {
            if (logger.isDebugEnabled()) {
                long timeStamp2 = System.nanoTime();
                long elapsed10ms2 = (timeStamp2 - this.before) / 100000L;
                this.before = timeStamp2;
                logger.debug("[{}] transmit => CARDREQUESTLIST IO failure. elapsed {}", (Object)this.getName(), (Object)((double)elapsed10ms2 / 10.0));
            }
            throw ex;
        }
        if (logger.isDebugEnabled()) {
            timeStamp = System.nanoTime();
            elapsed10ms = (timeStamp - this.before) / 100000L;
            this.before = timeStamp;
            logger.debug("[{}] transmit => CARDRESPONSELIST = {}, elapsed {} ms.", new Object[]{this.getName(), cardSelectionResponses, (double)elapsed10ms / 10.0});
        }
        return cardSelectionResponses;
    }

    protected abstract List<CardSelectionResponse> processCardSelectionRequests(List<CardSelectionRequest> var1, MultiSelectionProcessing var2, ChannelControl var3);

    @Override
    public final CardResponse transmitCardRequest(CardRequest cardRequest, ChannelControl channelControl) {
        CardResponse cardResponse;
        long elapsed10ms;
        long timeStamp;
        this.checkStatus();
        if (logger.isDebugEnabled()) {
            timeStamp = System.nanoTime();
            elapsed10ms = (timeStamp - this.before) / 100000L;
            this.before = timeStamp;
            logger.debug("[{}] transmit => CARDREQUEST = {}, elapsed {} ms.", new Object[]{this.getName(), cardRequest, (double)elapsed10ms / 10.0});
        }
        try {
            cardResponse = this.processCardRequest(cardRequest, channelControl);
        }
        catch (KeypleReaderIOException ex) {
            if (logger.isDebugEnabled()) {
                long timeStamp2 = System.nanoTime();
                long elapsed10ms2 = (timeStamp2 - this.before) / 100000L;
                this.before = timeStamp2;
                logger.debug("[{}] transmit => CARDREQUEST IO failure. elapsed {}", (Object)this.getName(), (Object)((double)elapsed10ms2 / 10.0));
            }
            throw ex;
        }
        if (logger.isDebugEnabled()) {
            timeStamp = System.nanoTime();
            elapsed10ms = (timeStamp - this.before) / 100000L;
            this.before = timeStamp;
            logger.debug("[{}] transmit => CARDRESPONSE = {}, elapsed {} ms.", new Object[]{this.getName(), cardResponse, (double)elapsed10ms / 10.0});
        }
        return cardResponse;
    }

    void checkStatus() {
        if (!this.isRegistered) {
            throw new IllegalStateException(String.format("This reader, %s, is not registered", this.getName()));
        }
    }

    void register() {
        this.isRegistered = true;
    }

    void unregister() {
        this.checkStatus();
        this.isRegistered = false;
    }

    protected abstract CardResponse processCardRequest(CardRequest var1, ChannelControl var2);
}

