/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.plugin;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.keyple.core.plugin.AbstractReader;
import org.eclipse.keyple.core.service.Plugin;
import org.eclipse.keyple.core.service.Reader;
import org.eclipse.keyple.core.service.exception.KeypleReaderNotFoundException;
import org.eclipse.keyple.core.util.Assert;

public abstract class AbstractPlugin
implements Plugin {
    private final String name;
    protected Map<String, Reader> readers = new ConcurrentHashMap<String, Reader>();
    private boolean isRegistered;

    protected AbstractPlugin(String name) {
        Assert.getInstance().notEmpty(name, "name");
        this.name = name;
        this.isRegistered = true;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Map<String, Reader> getReaders() {
        this.checkStatus();
        return this.readers;
    }

    @Override
    public final Set<String> getReaderNames() {
        this.checkStatus();
        return this.readers.keySet();
    }

    protected abstract Map<String, Reader> initNativeReaders();

    @Override
    public final Reader getReader(String name) {
        this.checkStatus();
        Reader reader = this.readers.get(name);
        if (reader == null) {
            throw new KeypleReaderNotFoundException(name);
        }
        return reader;
    }

    void checkStatus() {
        if (!this.isRegistered) {
            throw new IllegalStateException(String.format("This plugin, %s, is not registered", this.getName()));
        }
    }

    @Deprecated
    public void register() {
        this.isRegistered = true;
        this.readers.putAll(this.initNativeReaders());
        Collection<Reader> _readers = this.readers.values();
        for (Reader seReader : _readers) {
            ((AbstractReader)seReader).register();
        }
    }

    @Deprecated
    public void unregister() {
        this.checkStatus();
        this.isRegistered = false;
        for (String key : this.readers.keySet()) {
            Reader seReader = this.readers.remove(key);
            ((AbstractReader)seReader).unregister();
        }
    }
}

