/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.plugin;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.keyple.core.plugin.AbstractMonitoringJob;
import org.eclipse.keyple.core.plugin.AbstractObservableLocalReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractObservableState {
    private static final Logger logger = LoggerFactory.getLogger(AbstractObservableState.class);
    protected MonitoringState state;
    protected AbstractObservableLocalReader reader;
    protected AbstractMonitoringJob monitoringJob;
    protected Future<?> monitoringEvent;
    protected ExecutorService executorService;

    protected AbstractObservableState(MonitoringState state, AbstractObservableLocalReader reader, AbstractMonitoringJob monitoringJob, ExecutorService executorService) {
        this.reader = reader;
        this.state = state;
        this.monitoringJob = monitoringJob;
        this.executorService = executorService;
    }

    protected AbstractObservableState(MonitoringState state, AbstractObservableLocalReader reader) {
        this.reader = reader;
        this.state = state;
    }

    public MonitoringState getMonitoringState() {
        return this.state;
    }

    protected void switchState(MonitoringState stateId) {
        this.reader.switchState(stateId);
    }

    abstract void onEvent(AbstractObservableLocalReader.InternalEvent var1);

    void onActivate() {
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] onActivate => {}", (Object)this.reader.getName(), (Object)this.getMonitoringState());
        }
        if (this.monitoringJob != null) {
            if (this.executorService == null) {
                throw new AssertionError((Object)"ExecutorService must be set");
            }
            this.monitoringEvent = this.executorService.submit(this.monitoringJob.getMonitoringJob(this));
        }
    }

    void onDeactivate() {
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] onDeactivate => {}", (Object)this.reader.getName(), (Object)this.getMonitoringState());
        }
        if (this.monitoringEvent != null && !this.monitoringEvent.isDone()) {
            this.monitoringJob.stop();
            boolean canceled = this.monitoringEvent.cancel(false);
            if (logger.isTraceEnabled()) {
                logger.trace("[{}] onDeactivate => cancel runnable waitForCarPresent by thead interruption {}", (Object)this.reader.getName(), (Object)canceled);
            }
        }
    }

    public static enum MonitoringState {
        WAIT_FOR_START_DETECTION,
        WAIT_FOR_SE_INSERTION,
        WAIT_FOR_SE_PROCESSING,
        WAIT_FOR_SE_REMOVAL;

    }
}

