/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.keyple.core.plugin.AbstractPlugin;
import org.eclipse.keyple.core.plugin.ObservablePluginNotifier;
import org.eclipse.keyple.core.service.event.ObservablePlugin;
import org.eclipse.keyple.core.service.event.PluginEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObservablePlugin
extends AbstractPlugin
implements ObservablePluginNotifier {
    private static final Logger logger = LoggerFactory.getLogger(AbstractObservablePlugin.class);
    private List<ObservablePlugin.PluginObserver> observers;
    private final Object sync = new Object();

    protected AbstractObservablePlugin(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObserver(ObservablePlugin.PluginObserver observer) {
        if (observer == null) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Adding '{}' as an observer of '{}'.", (Object)observer.getClass().getSimpleName(), (Object)this.getName());
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.observers == null) {
                this.observers = new ArrayList<ObservablePlugin.PluginObserver>(1);
            }
            this.observers.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObserver(ObservablePlugin.PluginObserver observer) {
        if (observer == null) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] Deleting a plugin observer", (Object)this.getName());
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.observers != null) {
                this.observers.remove(observer);
            }
        }
    }

    @Override
    public void clearObservers() {
        if (this.observers != null) {
            this.observers.clear();
        }
    }

    @Override
    public final int countObservers() {
        return this.observers == null ? 0 : this.observers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void notifyObservers(PluginEvent event) {
        ArrayList<ObservablePlugin.PluginObserver> observersCopy;
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] Notifying a plugin event to {} observers. EVENTNAME = {} ", new Object[]{this.getName(), this.countObservers(), event.getEventType().name()});
        }
        Iterator iterator = this.sync;
        synchronized (iterator) {
            if (this.observers == null) {
                return;
            }
            observersCopy = new ArrayList<ObservablePlugin.PluginObserver>(this.observers);
        }
        for (ObservablePlugin.PluginObserver observer : observersCopy) {
            observer.update(event);
        }
    }

    @Override
    public void unregister() {
        super.unregister();
        this.notifyObservers(new PluginEvent(this.getName(), this.readers.keySet(), PluginEvent.EventType.UNREGISTERED));
        this.clearObservers();
    }
}

