/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.keyple.core.card.message.CardSelectionResponse;
import org.eclipse.keyple.core.card.message.DefaultSelectionsRequest;
import org.eclipse.keyple.core.card.message.DefaultSelectionsResponse;
import org.eclipse.keyple.core.plugin.AbstractLocalReader;
import org.eclipse.keyple.core.plugin.AbstractObservableState;
import org.eclipse.keyple.core.plugin.ObservableReaderNotifier;
import org.eclipse.keyple.core.plugin.ObservableReaderStateService;
import org.eclipse.keyple.core.service.event.AbstractDefaultSelectionsRequest;
import org.eclipse.keyple.core.service.event.ObservableReader;
import org.eclipse.keyple.core.service.event.ReaderEvent;
import org.eclipse.keyple.core.service.event.ReaderObservationExceptionHandler;
import org.eclipse.keyple.core.service.exception.KeypleReaderException;
import org.eclipse.keyple.core.service.exception.KeypleReaderIOException;
import org.eclipse.keyple.core.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObservableLocalReader
extends AbstractLocalReader
implements ObservableReaderNotifier {
    private static final Logger logger = LoggerFactory.getLogger(AbstractObservableLocalReader.class);
    private DefaultSelectionsRequest defaultSelectionsRequest;
    private ObservableReader.NotificationMode notificationMode;
    private ObservableReader.PollingMode currentPollingMode = ObservableReader.PollingMode.SINGLESHOT;
    private List<ObservableReader.ReaderObserver> observers;
    private final Object sync = new Object();
    protected final ObservableReaderStateService stateService = new ObservableReaderStateService(this);

    protected abstract void onStartDetection();

    protected abstract void onStopDetection();

    protected AbstractObservableLocalReader(String pluginName, String readerName) {
        super(pluginName, readerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addObserver(ObservableReader.ReaderObserver observer) {
        Assert.getInstance().notNull(observer, "observer");
        if (logger.isTraceEnabled()) {
            logger.trace("Adding '{}' as an observer of '{}'.", (Object)observer.getClass().getSimpleName(), (Object)this.getName());
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.observers == null) {
                if (this.getObservationExceptionHandler() == null) {
                    throw new IllegalStateException("No reader observation exception handler has been set.");
                }
                this.observers = new ArrayList<ObservableReader.ReaderObserver>(1);
            }
            this.observers.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeObserver(ObservableReader.ReaderObserver observer) {
        if (observer == null) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] Deleting a reader observer", (Object)this.getName());
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.observers != null) {
                this.observers.remove(observer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void notifyObservers(ReaderEvent event) {
        ArrayList<ObservableReader.ReaderObserver> observersCopy;
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] Notifying a reader event to {} observers. EVENTNAME = {}", new Object[]{this.getName(), this.countObservers(), event.getEventType().name()});
        }
        Iterator iterator = this.sync;
        synchronized (iterator) {
            if (this.observers == null) {
                return;
            }
            observersCopy = new ArrayList<ObservableReader.ReaderObserver>(this.observers);
        }
        for (ObservableReader.ReaderObserver observer : observersCopy) {
            observer.update(event);
        }
    }

    @Override
    public final int countObservers() {
        return this.observers == null ? 0 : this.observers.size();
    }

    @Override
    public final void clearObservers() {
        if (this.observers != null) {
            this.observers.clear();
        }
    }

    @Override
    public final boolean isCardPresent() {
        this.checkStatus();
        if (this.checkCardPresence()) {
            return true;
        }
        if (this.isLogicalChannelOpen() || this.isPhysicalChannelOpen()) {
            this.processCardRemoved();
        }
        return false;
    }

    @Override
    public final void startCardDetection(ObservableReader.PollingMode pollingMode) {
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] start the card Detection with pollingMode {}", (Object)this.getName(), (Object)pollingMode);
        }
        this.currentPollingMode = pollingMode;
        this.stateService.onEvent(InternalEvent.START_DETECT);
    }

    @Override
    public final void stopCardDetection() {
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] stop the card Detection", (Object)this.getName());
        }
        this.stateService.onEvent(InternalEvent.STOP_DETECT);
    }

    @Override
    public final void setDefaultSelectionRequest(AbstractDefaultSelectionsRequest defaultSelectionsRequest, ObservableReader.NotificationMode notificationMode) {
        this.defaultSelectionsRequest = (DefaultSelectionsRequest)defaultSelectionsRequest;
        this.notificationMode = notificationMode;
    }

    @Override
    public final void setDefaultSelectionRequest(AbstractDefaultSelectionsRequest defaultSelectionsRequest, ObservableReader.NotificationMode notificationMode, ObservableReader.PollingMode pollingMode) {
        this.setDefaultSelectionRequest(defaultSelectionsRequest, notificationMode);
        this.startCardDetection(pollingMode);
    }

    ReaderEvent processCardInserted() {
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] process the inserted card", (Object)this.getName());
        }
        if (this.defaultSelectionsRequest == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("[{}] no default selection request defined, notify CARD_INSERTED", (Object)this.getName());
            }
            return new ReaderEvent(this.getPluginName(), this.getName(), ReaderEvent.EventType.CARD_INSERTED, null);
        }
        boolean aCardMatched = false;
        try {
            List<CardSelectionResponse> cardSelectionResponses = this.transmitCardSelectionRequests(this.defaultSelectionsRequest.getCardSelectionRequests(), this.defaultSelectionsRequest.getMultiSelectionProcessing(), this.defaultSelectionsRequest.getChannelControl());
            for (CardSelectionResponse cardSelectionResponse : cardSelectionResponses) {
                if (cardSelectionResponse == null || !cardSelectionResponse.getSelectionStatus().hasMatched()) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace("[{}] a default selection has matched", (Object)this.getName());
                }
                aCardMatched = true;
                break;
            }
            if (this.notificationMode == ObservableReader.NotificationMode.MATCHED_ONLY) {
                if (aCardMatched) {
                    return new ReaderEvent(this.getPluginName(), this.getName(), ReaderEvent.EventType.CARD_MATCHED, new DefaultSelectionsResponse(cardSelectionResponses));
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("[{}] selection hasn't matched do not thrown any event because of MATCHED_ONLY flag", (Object)this.getName());
                }
                return null;
            }
            if (aCardMatched) {
                return new ReaderEvent(this.getPluginName(), this.getName(), ReaderEvent.EventType.CARD_MATCHED, new DefaultSelectionsResponse(cardSelectionResponses));
            }
            if (logger.isTraceEnabled()) {
                logger.trace("[{}] none of {} default selection matched", (Object)this.getName(), (Object)cardSelectionResponses.size());
            }
            return new ReaderEvent(this.getPluginName(), this.getName(), ReaderEvent.EventType.CARD_INSERTED, new DefaultSelectionsResponse(cardSelectionResponses));
        }
        catch (KeypleReaderException e) {
            this.closeLogicalAndPhysicalChannels();
            if (logger.isDebugEnabled()) {
                logger.debug("An IO Exception occurred while processing the default selection. {}", (Object)e.getMessage());
            }
            try {
                this.closePhysicalChannel();
            }
            catch (KeypleReaderIOException e2) {
                logger.error("Error while closing physical channel. {}", (Object)e2.getMessage());
            }
            return null;
        }
    }

    boolean isCardPresentPing() {
        byte[] apdu = new byte[]{0, -64, 0, 0, 0};
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("[{}] Ping card", (Object)this.getName());
            }
            this.transmitApdu(apdu);
        }
        catch (KeypleReaderIOException e) {
            if (logger.isTraceEnabled()) {
                logger.trace("[{}] Exception occurred in isCardPresentPing. Message: {}", (Object)this.getName(), (Object)e.getMessage());
            }
            return false;
        }
        return true;
    }

    final void processCardRemoved() {
        this.closeLogicalAndPhysicalChannels();
        this.notifyObservers(new ReaderEvent(this.getPluginName(), this.getName(), ReaderEvent.EventType.CARD_REMOVED, null));
    }

    ObservableReader.PollingMode getPollingMode() {
        return this.currentPollingMode;
    }

    void switchState(AbstractObservableState.MonitoringState stateId) {
        this.stateService.switchState(stateId);
    }

    AbstractObservableState.MonitoringState getCurrentMonitoringState() {
        return this.stateService.getCurrentMonitoringState();
    }

    void onEvent(InternalEvent event) {
        this.stateService.onEvent(event);
    }

    @Override
    public final void finalizeCardProcessing() {
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] start removal sequence of the reader", (Object)this.getName());
        }
        this.stateService.onEvent(InternalEvent.SE_PROCESSED);
    }

    @Override
    protected void unregister() {
        super.unregister();
        try {
            this.notifyObservers(new ReaderEvent(this.getPluginName(), this.getName(), ReaderEvent.EventType.UNREGISTERED, null));
            this.stopCardDetection();
        }
        finally {
            this.clearObservers();
            this.stateService.shutdown();
        }
    }

    protected abstract ReaderObservationExceptionHandler getObservationExceptionHandler();

    public static enum InternalEvent {
        CARD_INSERTED,
        CARD_REMOVED,
        SE_PROCESSED,
        START_DETECT,
        STOP_DETECT,
        TIME_OUT;

    }
}

