/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.plugin;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.keyple.core.card.message.AnswerToReset;
import org.eclipse.keyple.core.card.message.ApduRequest;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.eclipse.keyple.core.card.message.CardRequest;
import org.eclipse.keyple.core.card.message.CardResponse;
import org.eclipse.keyple.core.card.message.CardSelectionRequest;
import org.eclipse.keyple.core.card.message.CardSelectionResponse;
import org.eclipse.keyple.core.card.message.ChannelControl;
import org.eclipse.keyple.core.card.message.SelectionStatus;
import org.eclipse.keyple.core.card.selection.CardSelector;
import org.eclipse.keyple.core.card.selection.MultiSelectionProcessing;
import org.eclipse.keyple.core.plugin.AbstractReader;
import org.eclipse.keyple.core.plugin.SmartSelectionReader;
import org.eclipse.keyple.core.service.event.ObservableReader;
import org.eclipse.keyple.core.service.exception.KeypleReaderIOException;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.core.util.ByteArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLocalReader
extends AbstractReader {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLocalReader.class);
    private static final byte[] getResponseHackRequestBytes = ByteArrayUtil.fromHex("00C0000000");
    private boolean logicalChannelIsOpen = false;
    private final Map<String, String> protocolAssociations;
    private String currentProtocol;
    private long before;
    private boolean useDefaultProtocol;

    protected AbstractLocalReader(String pluginName, String readerName) {
        super(pluginName, readerName);
        if (logger.isDebugEnabled()) {
            this.before = System.nanoTime();
        }
        this.protocolAssociations = new LinkedHashMap<String, String>();
    }

    @Override
    public boolean isCardPresent() {
        this.checkStatus();
        return this.checkCardPresence();
    }

    protected abstract boolean checkCardPresence();

    void closeLogicalAndPhysicalChannels() {
        block2: {
            this.closeLogicalChannel();
            try {
                this.resetProtocolAndClosePhysicalChannel();
            }
            catch (KeypleReaderIOException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("[{}] Exception occurred in releaseSeChannel. Message: {}", (Object)this.getName(), (Object)e.getMessage());
            }
        }
    }

    protected abstract byte[] getATR();

    private ApduResponse recoverSelectionFciData(CardSelector.AidSelector aidSelector) {
        ApduResponse fciResponse;
        byte[] getDataCommand = new byte[]{0, -54, 0, 111, 0};
        ApduRequest apduRequest = new ApduRequest(getDataCommand, false).setSuccessfulStatusCodes(aidSelector.getSuccessfulSelectionStatusCodes());
        if (logger.isDebugEnabled()) {
            apduRequest.setName("Internal Get Data");
        }
        if (!(fciResponse = this.processApduRequest(apduRequest)).isSuccessful() && logger.isDebugEnabled()) {
            logger.debug("[{}] selectionGetData => Get data failed. SELECTOR = {}", (Object)this.getName(), (Object)aidSelector);
        }
        return fciResponse;
    }

    private ApduResponse processExplicitAidSelection(CardSelector.AidSelector aidSelector) {
        ApduResponse fciResponse;
        byte[] aid = aidSelector.getAidToSelect();
        if (aid == null) {
            throw new IllegalArgumentException("AID must not be null for an AidSelector.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[{}] openLogicalChannel => Select Application with AID = {}", (Object)this.getName(), (Object)ByteArrayUtil.toHex(aid));
        }
        byte[] selectApplicationCommand = new byte[6 + aid.length];
        selectApplicationCommand[0] = 0;
        selectApplicationCommand[1] = -92;
        selectApplicationCommand[2] = 4;
        selectApplicationCommand[3] = (byte)(aidSelector.getFileOccurrence().getIsoBitMask() | aidSelector.getFileControlInformation().getIsoBitMask());
        selectApplicationCommand[4] = (byte)aid.length;
        System.arraycopy(aid, 0, selectApplicationCommand, 5, aid.length);
        selectApplicationCommand[5 + aid.length] = 0;
        ApduRequest apduRequest = new ApduRequest(selectApplicationCommand, true).setSuccessfulStatusCodes(aidSelector.getSuccessfulSelectionStatusCodes());
        if (logger.isDebugEnabled()) {
            apduRequest.setName("Internal Select Application");
        }
        if (!(fciResponse = this.processApduRequest(apduRequest)).isSuccessful() && logger.isDebugEnabled()) {
            logger.debug("[{}] openLogicalChannel => Application Selection failed. SELECTOR = {}", (Object)this.getName(), (Object)aidSelector);
        }
        return fciResponse;
    }

    protected abstract void openPhysicalChannel();

    private void openPhysicalChannelAndSetProtocol() {
        this.openPhysicalChannel();
        this.computeCurrentProtocol();
    }

    protected abstract void closePhysicalChannel();

    private void resetProtocolAndClosePhysicalChannel() {
        this.currentProtocol = null;
        this.useDefaultProtocol = false;
        this.closePhysicalChannel();
    }

    protected abstract boolean isPhysicalChannelOpen();

    final boolean isLogicalChannelOpen() {
        return this.logicalChannelIsOpen;
    }

    private void closeLogicalChannel() {
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] closeLogicalChannel => Closing of the logical channel.", (Object)this.getName());
        }
        if (this instanceof SmartSelectionReader) {
            ((SmartSelectionReader)((Object)this)).closeLogicalChannel();
        }
        this.logicalChannelIsOpen = false;
    }

    protected abstract boolean isCurrentProtocol(String var1);

    private void computeCurrentProtocol() {
        this.currentProtocol = null;
        if (this.protocolAssociations.size() == 0) {
            this.useDefaultProtocol = true;
        } else {
            this.useDefaultProtocol = false;
            for (Map.Entry<String, String> entry : this.protocolAssociations.entrySet()) {
                if (!this.isCurrentProtocol(entry.getKey())) continue;
                this.currentProtocol = entry.getValue();
            }
        }
    }

    @Override
    public final void releaseChannel() {
        this.closeLogicalChannel();
        if (this instanceof ObservableReader) {
            if (((ObservableReader)((Object)this)).countObservers() != 0) {
                ((ObservableReader)((Object)this)).finalizeCardProcessing();
            } else {
                this.resetProtocolAndClosePhysicalChannel();
            }
        } else {
            this.resetProtocolAndClosePhysicalChannel();
        }
    }

    @Override
    protected final List<CardSelectionResponse> processCardSelectionRequests(List<CardSelectionRequest> cardSelectionRequests, MultiSelectionProcessing multiSelectionProcessing, ChannelControl channelControl) {
        ArrayList<CardSelectionResponse> cardSelectionResponses = new ArrayList<CardSelectionResponse>();
        if (!this.isPhysicalChannelOpen()) {
            this.openPhysicalChannelAndSetProtocol();
        }
        for (CardSelectionRequest cardSelectionRequest : cardSelectionRequests) {
            CardSelectionResponse cardSelectionResponse;
            try {
                cardSelectionResponse = this.processCardSelectionRequest(cardSelectionRequest);
            }
            catch (KeypleReaderIOException ex) {
                cardSelectionResponses.add(new CardSelectionResponse(new SelectionStatus(null, null, false), ex.getCardResponse()));
                ex.setCardSelectionResponses(cardSelectionResponses);
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] processCardSelectionRequests => transmit : process interrupted, collect previous responses {}", (Object)this.getName(), cardSelectionResponses);
                }
                throw ex;
            }
            cardSelectionResponses.add(cardSelectionResponse);
            if (multiSelectionProcessing == MultiSelectionProcessing.PROCESS_ALL) {
                this.closeLogicalChannel();
                continue;
            }
            if (!this.logicalChannelIsOpen) continue;
            break;
        }
        if (channelControl == ChannelControl.CLOSE_AFTER) {
            this.releaseChannel();
        }
        return cardSelectionResponses;
    }

    @Override
    protected final CardResponse processCardRequest(CardRequest cardRequest, ChannelControl channelControl) {
        if (!this.isPhysicalChannelOpen()) {
            this.openPhysicalChannelAndSetProtocol();
        }
        CardResponse cardResponse = this.processCardRequest(cardRequest);
        if (channelControl == ChannelControl.CLOSE_AFTER) {
            this.releaseChannel();
        }
        return cardResponse;
    }

    private boolean checkAtr(byte[] atr, CardSelector.AtrFilter atrFilter) {
        if (logger.isDebugEnabled()) {
            logger.debug("[{}] openLogicalChannel => ATR = {}", (Object)this.getName(), (Object)ByteArrayUtil.toHex(atr));
        }
        if (!atrFilter.atrMatches(atr)) {
            if (logger.isInfoEnabled()) {
                logger.info("[{}] openLogicalChannel => ATR didn't match. ATR = {}, regex filter = {}", new Object[]{this.getName(), ByteArrayUtil.toHex(atr), atrFilter.getAtrRegex()});
            }
            return false;
        }
        return true;
    }

    private ApduResponse selectByAid(CardSelector.AidSelector aidSelector) {
        ApduResponse fciResponse;
        if (this instanceof SmartSelectionReader) {
            byte isoControlMask;
            byte[] dfName = aidSelector.getAidToSelect();
            byte[] selectionDataBytes = ((SmartSelectionReader)((Object)this)).openChannelForAid(dfName, isoControlMask = (byte)(aidSelector.getFileOccurrence().getIsoBitMask() | aidSelector.getFileControlInformation().getIsoBitMask()));
            if (selectionDataBytes == null) {
                throw new KeypleReaderIOException("The card is unable to provide a new logical channel");
            }
            fciResponse = new ApduResponse(selectionDataBytes, aidSelector.getSuccessfulSelectionStatusCodes());
        } else {
            fciResponse = this.processExplicitAidSelection(aidSelector);
        }
        if (fciResponse.isSuccessful() && fciResponse.getDataOut().length == 0) {
            fciResponse = this.recoverSelectionFciData(aidSelector);
        }
        return fciResponse;
    }

    private SelectionStatus processSelection(CardSelector cardSelector) {
        ApduResponse fciResponse;
        AnswerToReset answerToReset;
        boolean hasMatched = true;
        if (cardSelector.getCardProtocol() != null && this.useDefaultProtocol) {
            throw new IllegalStateException("Protocol " + cardSelector.getCardProtocol() + " not associated to a reader protocol.");
        }
        if (cardSelector.getCardProtocol() == null || this.useDefaultProtocol || cardSelector.getCardProtocol().equals(this.currentProtocol)) {
            byte[] atr = this.getATR();
            answerToReset = new AnswerToReset(atr);
            CardSelector.AtrFilter atrFilter = cardSelector.getAtrFilter();
            if (atrFilter == null || this.checkAtr(atr, atrFilter)) {
                CardSelector.AidSelector aidSelector = cardSelector.getAidSelector();
                if (aidSelector != null) {
                    fciResponse = this.selectByAid(aidSelector);
                    hasMatched = fciResponse.isSuccessful();
                } else {
                    fciResponse = null;
                }
            } else {
                hasMatched = false;
                fciResponse = null;
            }
        } else {
            answerToReset = null;
            fciResponse = null;
            hasMatched = false;
        }
        return new SelectionStatus(answerToReset, fciResponse, hasMatched);
    }

    private CardSelectionResponse processCardSelectionRequest(CardSelectionRequest cardSelectionRequest) {
        SelectionStatus selectionStatus = this.processSelection(cardSelectionRequest.getCardSelector());
        if (!selectionStatus.hasMatched()) {
            return new CardSelectionResponse(selectionStatus, new CardResponse(false, new ArrayList<ApduResponse>()));
        }
        this.logicalChannelIsOpen = true;
        CardResponse cardResponse = this.processCardRequest(cardSelectionRequest.getCardRequest());
        return new CardSelectionResponse(selectionStatus, cardResponse);
    }

    private CardResponse processCardRequest(CardRequest cardRequest) {
        ArrayList<ApduResponse> apduResponses = new ArrayList<ApduResponse>();
        if (cardRequest.getApduRequests() != null) {
            for (ApduRequest apduRequest : cardRequest.getApduRequests()) {
                try {
                    apduResponses.add(this.processApduRequest(apduRequest));
                }
                catch (KeypleReaderIOException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("The process has been interrupted, collect Apdu responses collected so far");
                    }
                    this.closeLogicalAndPhysicalChannels();
                    ex.setCardResponse(new CardResponse(false, apduResponses));
                    throw ex;
                }
            }
        }
        return new CardResponse(this.logicalChannelIsOpen, apduResponses);
    }

    private ApduResponse processApduRequest(ApduRequest apduRequest) {
        if (logger.isDebugEnabled()) {
            long timeStamp = System.nanoTime();
            long elapsed10ms = (timeStamp - this.before) / 100000L;
            this.before = timeStamp;
            logger.debug("[{}] processApduRequest => {}, elapsed {} ms.", new Object[]{this.getName(), apduRequest, (double)elapsed10ms / 10.0});
        }
        byte[] buffer = apduRequest.getBytes();
        ApduResponse apduResponse = new ApduResponse(this.transmitApdu(buffer), apduRequest.getSuccessfulStatusCodes());
        if (apduRequest.isCase4() && apduResponse.getDataOut().length == 0 && apduResponse.isSuccessful()) {
            apduResponse = this.case4HackGetResponse(apduResponse.getStatusCode());
        }
        if (logger.isDebugEnabled()) {
            long timeStamp = System.nanoTime();
            long elapsed10ms = (timeStamp - this.before) / 100000L;
            this.before = timeStamp;
            logger.debug("[{}] processApduRequest => {}, elapsed {} ms.", new Object[]{this.getName(), apduResponse, (double)elapsed10ms / 10.0});
        }
        return apduResponse;
    }

    private ApduResponse case4HackGetResponse(int originalStatusCode) {
        if (logger.isDebugEnabled()) {
            long timeStamp = System.nanoTime();
            long elapsed10ms = (timeStamp - this.before) / 100000L;
            this.before = timeStamp;
            logger.debug("[{}] case4HackGetResponse => ApduRequest: NAME = \"Internal Get Response\", RAWDATA = {}, elapsed = {}", new Object[]{this.getName(), ByteArrayUtil.toHex(getResponseHackRequestBytes), (double)elapsed10ms / 10.0});
        }
        byte[] getResponseHackResponseBytes = this.transmitApdu(getResponseHackRequestBytes);
        ApduResponse getResponseHackResponse = new ApduResponse(getResponseHackResponseBytes, null);
        if (logger.isDebugEnabled()) {
            long timeStamp = System.nanoTime();
            long elapsed10ms = (timeStamp - this.before) / 100000L;
            this.before = timeStamp;
            logger.debug("[{}] case4HackGetResponse => Internal {}, elapsed {} ms.", new Object[]{this.getName(), getResponseHackResponseBytes, (double)elapsed10ms / 10.0});
        }
        if (getResponseHackResponse.isSuccessful()) {
            getResponseHackResponseBytes[getResponseHackResponseBytes.length - 2] = (byte)(originalStatusCode >> 8);
            getResponseHackResponseBytes[getResponseHackResponseBytes.length - 1] = (byte)(originalStatusCode & 0xFF);
        }
        return getResponseHackResponse;
    }

    protected abstract byte[] transmitApdu(byte[] var1);

    protected abstract void activateReaderProtocol(String var1);

    @Override
    public final void activateProtocol(String readerProtocolName, String applicationProtocolName) {
        this.checkStatus();
        Assert.getInstance().notEmpty(readerProtocolName, "readerProtocolName").notEmpty(applicationProtocolName, "applicationProtocolName");
        this.activateReaderProtocol(readerProtocolName);
        this.protocolAssociations.put(readerProtocolName, applicationProtocolName);
    }

    protected abstract void deactivateReaderProtocol(String var1);

    @Override
    public final void deactivateProtocol(String readerProtocolName) {
        this.checkStatus();
        Assert.getInstance().notEmpty(readerProtocolName, "readerProtocolName");
        this.protocolAssociations.remove(readerProtocolName);
        this.deactivateReaderProtocol(readerProtocolName);
    }
}

