/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.card.selection;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.keyple.core.util.ByteArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardSelector
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(CardSelector.class);
    private final String cardProtocol;
    private final AidSelector aidSelector;
    private final AtrFilter atrFilter;

    protected CardSelector(CardSelectorBuilder builder) {
        this.cardProtocol = builder.cardProtocol;
        this.aidSelector = builder.aidSelector;
        this.atrFilter = builder.atrFilter;
        if (logger.isTraceEnabled()) {
            logger.trace("Selection data: AID = {}, ATRREGEX = {}", (Object)(this.aidSelector == null || this.aidSelector.getAidToSelect() == null ? "null" : ByteArrayUtil.toHex(this.aidSelector.getAidToSelect())), (Object)(this.atrFilter == null ? "null" : this.atrFilter.getAtrRegex()));
        }
    }

    public static CardSelectorBuilder builder() {
        return new CardSelectorBuilder();
    }

    public String getCardProtocol() {
        return this.cardProtocol;
    }

    public AtrFilter getAtrFilter() {
        return this.atrFilter;
    }

    public AidSelector getAidSelector() {
        return this.aidSelector;
    }

    public String toString() {
        return "CardSelector{cardProtocol=" + this.cardProtocol + ", aidSelector=" + this.aidSelector + ", atrFilter=" + this.atrFilter + '}';
    }

    public static class CardSelectorBuilder {
        private String cardProtocol;
        private AtrFilter atrFilter;
        private AidSelector aidSelector;

        protected CardSelectorBuilder() {
        }

        public CardSelectorBuilder cardProtocol(String cardProtocol) {
            this.cardProtocol = cardProtocol;
            return this;
        }

        public CardSelectorBuilder atrFilter(AtrFilter atrFilter) {
            this.atrFilter = atrFilter;
            return this;
        }

        public CardSelectorBuilder aidSelector(AidSelector aidSelector) {
            this.aidSelector = aidSelector;
            return this;
        }

        public CardSelector build() {
            return new CardSelector(this);
        }
    }

    public static final class AtrFilter
    implements Serializable {
        private String atrRegex;

        public AtrFilter(String atrRegex) {
            this.atrRegex = atrRegex;
        }

        public void setAtrRegex(String atrRegex) {
            this.atrRegex = atrRegex;
        }

        public String getAtrRegex() {
            return this.atrRegex;
        }

        public boolean atrMatches(byte[] atr) {
            boolean m;
            if (this.atrRegex.length() != 0) {
                Pattern p = Pattern.compile(this.atrRegex);
                String atrString = ByteArrayUtil.toHex(atr);
                m = p.matcher(atrString).matches();
            } else {
                m = true;
            }
            return m;
        }

        public String toString() {
            return "AtrFilter{atrRegex='" + this.atrRegex + '\'' + '}';
        }
    }

    public static final class AidSelector
    implements Serializable {
        public static final int AID_MIN_LENGTH = 5;
        public static final int AID_MAX_LENGTH = 16;
        private final FileOccurrence fileOccurrence;
        private final FileControlInformation fileControlInformation;
        private final byte[] aidToSelect;
        private Set<Integer> successfulSelectionStatusCodes;

        private AidSelector(AidSelectorBuilder builder) {
            this.aidToSelect = builder.aidToSelect;
            this.fileOccurrence = builder.fileOccurrence;
            this.fileControlInformation = builder.fileControlInformation;
            this.successfulSelectionStatusCodes = null;
        }

        public static AidSelectorBuilder builder() {
            return new AidSelectorBuilder();
        }

        public byte[] getAidToSelect() {
            return this.aidToSelect;
        }

        public FileOccurrence getFileOccurrence() {
            return this.fileOccurrence;
        }

        public FileControlInformation getFileControlInformation() {
            return this.fileControlInformation;
        }

        public Set<Integer> getSuccessfulSelectionStatusCodes() {
            return this.successfulSelectionStatusCodes;
        }

        public void addSuccessfulStatusCode(int statusCode) {
            if (this.successfulSelectionStatusCodes == null) {
                this.successfulSelectionStatusCodes = new LinkedHashSet<Integer>();
            }
            this.successfulSelectionStatusCodes.add(statusCode);
        }

        public String toString() {
            return "AidSelector{aidToSelect=" + ByteArrayUtil.toHex(this.aidToSelect) + ", fileOccurrence=" + (Object)((Object)this.fileOccurrence) + ", fileControlInformation=" + (Object)((Object)this.fileControlInformation) + ", successfulSelectionStatusCodes=" + this.successfulSelectionStatusCodes + '}';
        }

        public static class AidSelectorBuilder {
            private byte[] aidToSelect;
            private FileOccurrence fileOccurrence = FileOccurrence.FIRST;
            private FileControlInformation fileControlInformation = FileControlInformation.FCI;

            private AidSelectorBuilder() {
            }

            public AidSelectorBuilder aidToSelect(byte[] aid) {
                if (aid.length < 5 || aid.length > 16) {
                    this.aidToSelect = null;
                    throw new IllegalArgumentException("Bad AID length: " + aid.length + ". The AID length should be between 5 and 15.");
                }
                this.aidToSelect = aid;
                return this;
            }

            public AidSelectorBuilder aidToSelect(String aid) {
                return this.aidToSelect(ByteArrayUtil.fromHex(aid));
            }

            public AidSelectorBuilder fileOccurrence(FileOccurrence fileOccurrence) {
                this.fileOccurrence = fileOccurrence;
                return this;
            }

            public AidSelectorBuilder fileControlInformation(FileControlInformation fileControlInformation) {
                this.fileControlInformation = fileControlInformation;
                return this;
            }

            public AidSelector build() {
                return new AidSelector(this);
            }
        }

        public static enum FileControlInformation {
            FCI(0),
            FCP(4),
            FMD(8),
            NO_RESPONSE(12);

            private final byte isoBitMask;

            private FileControlInformation(byte isoBitMask) {
                this.isoBitMask = isoBitMask;
            }

            public byte getIsoBitMask() {
                return this.isoBitMask;
            }
        }

        public static enum FileOccurrence {
            FIRST(0),
            LAST(1),
            NEXT(2),
            PREVIOUS(3);

            private final byte isoBitMask;

            private FileOccurrence(byte isoBitMask) {
                this.isoBitMask = isoBitMask;
            }

            public byte getIsoBitMask() {
                return this.isoBitMask;
            }
        }
    }
}

