/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.card.selection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.keyple.core.card.command.AbstractApduCommandBuilder;
import org.eclipse.keyple.core.card.message.CardSelectionRequest;
import org.eclipse.keyple.core.card.message.CardSelectionResponse;
import org.eclipse.keyple.core.card.message.ChannelControl;
import org.eclipse.keyple.core.card.message.DefaultSelectionsRequest;
import org.eclipse.keyple.core.card.message.DefaultSelectionsResponse;
import org.eclipse.keyple.core.card.message.ProxyReader;
import org.eclipse.keyple.core.card.message.SelectionStatus;
import org.eclipse.keyple.core.card.selection.AbstractCardSelection;
import org.eclipse.keyple.core.card.selection.AbstractSmartCard;
import org.eclipse.keyple.core.card.selection.CardSelectionsResult;
import org.eclipse.keyple.core.card.selection.MultiSelectionProcessing;
import org.eclipse.keyple.core.service.Reader;
import org.eclipse.keyple.core.service.event.AbstractDefaultSelectionsRequest;
import org.eclipse.keyple.core.service.event.AbstractDefaultSelectionsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CardSelectionsService {
    private static final Logger logger = LoggerFactory.getLogger(CardSelectionsService.class);
    private final List<AbstractCardSelection<? extends AbstractApduCommandBuilder>> commandCardSelectionRequests = new ArrayList<AbstractCardSelection<? extends AbstractApduCommandBuilder>>();
    private final MultiSelectionProcessing multiSelectionProcessing;
    private ChannelControl channelControl = ChannelControl.KEEP_OPEN;

    public CardSelectionsService(MultiSelectionProcessing multiSelectionProcessing) {
        this.multiSelectionProcessing = multiSelectionProcessing;
    }

    public CardSelectionsService() {
        this(MultiSelectionProcessing.FIRST_MATCH);
    }

    public int prepareSelection(AbstractCardSelection<? extends AbstractApduCommandBuilder> cardSelectionRequest) {
        if (logger.isTraceEnabled()) {
            logger.trace("CardSelectionRequest = {}", (Object)cardSelectionRequest.getCardSelectionRequest());
        }
        this.commandCardSelectionRequests.add(cardSelectionRequest);
        return this.commandCardSelectionRequests.size() - 1;
    }

    public final void prepareReleaseChannel() {
        this.channelControl = ChannelControl.CLOSE_AFTER;
    }

    private CardSelectionsResult processSelection(AbstractDefaultSelectionsResponse defaultSelectionsResponse) {
        CardSelectionsResult cardSelectionsResult = new CardSelectionsResult();
        int index = 0;
        for (CardSelectionResponse cardSelectionResponse : ((DefaultSelectionsResponse)defaultSelectionsResponse).getCardSelectionResponses()) {
            if (cardSelectionResponse != null && cardSelectionResponse.getSelectionStatus() != null && cardSelectionResponse.getSelectionStatus().hasMatched()) {
                AbstractSmartCard smartCard = this.commandCardSelectionRequests.get(index).parse(cardSelectionResponse);
                SelectionStatus selectionStatus = cardSelectionResponse.getSelectionStatus();
                boolean isSelected = selectionStatus.hasMatched() && cardSelectionResponse.getCardResponse().isLogicalChannelOpen();
                cardSelectionsResult.addSmartCard(index, smartCard, isSelected);
            }
            ++index;
        }
        return cardSelectionsResult;
    }

    public CardSelectionsResult processDefaultSelectionsResponse(AbstractDefaultSelectionsResponse defaultSelectionsResponse) {
        if (defaultSelectionsResponse == null) {
            logger.error("defaultSelectionsResponse shouldn't be null in processSelection.");
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Process default CardSelectionResponse ({} response(s))", (Object)((DefaultSelectionsResponse)defaultSelectionsResponse).getCardSelectionResponses().size());
        }
        return this.processSelection(defaultSelectionsResponse);
    }

    public CardSelectionsResult processExplicitSelections(Reader reader) {
        ArrayList<CardSelectionRequest> cardSelectionRequests = new ArrayList<CardSelectionRequest>();
        for (AbstractCardSelection<? extends AbstractApduCommandBuilder> cardSelectionRequest : this.commandCardSelectionRequests) {
            cardSelectionRequests.add(cardSelectionRequest.getCardSelectionRequest());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Transmit CardSelectionRequest ({} request(s))", (Object)cardSelectionRequests.size());
        }
        List<CardSelectionResponse> cardSelectionResponses = ((ProxyReader)reader).transmitCardSelectionRequests(cardSelectionRequests, this.multiSelectionProcessing, this.channelControl);
        return this.processSelection(new DefaultSelectionsResponse(cardSelectionResponses));
    }

    public AbstractDefaultSelectionsRequest getDefaultSelectionsRequest() {
        ArrayList<CardSelectionRequest> cardSelectionRequests = new ArrayList<CardSelectionRequest>();
        for (AbstractCardSelection<? extends AbstractApduCommandBuilder> cardSelectionRequest : this.commandCardSelectionRequests) {
            cardSelectionRequests.add(cardSelectionRequest.getCardSelectionRequest());
        }
        return new DefaultSelectionsRequest(cardSelectionRequests, this.multiSelectionProcessing, this.channelControl);
    }
}

