/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.card.selection;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.keyple.core.card.selection.AbstractSmartCard;

public final class CardSelectionsResult {
    private Integer activeSelectionIndex = null;
    private final Map<Integer, AbstractSmartCard> smartCardMap = new HashMap<Integer, AbstractSmartCard>();

    CardSelectionsResult() {
    }

    void addSmartCard(int selectionIndex, AbstractSmartCard smartCard, boolean isSelected) {
        if (smartCard != null) {
            this.smartCardMap.put(selectionIndex, smartCard);
        }
        if (isSelected) {
            this.activeSelectionIndex = selectionIndex;
        }
    }

    public AbstractSmartCard getActiveSmartCard() {
        AbstractSmartCard smartCard = this.smartCardMap.get(this.activeSelectionIndex);
        if (smartCard == null) {
            throw new IllegalStateException("No active Matching card is available");
        }
        return smartCard;
    }

    public Map<Integer, AbstractSmartCard> getSmartCards() {
        return this.smartCardMap;
    }

    public AbstractSmartCard getSmartCard(int selectionIndex) {
        return this.smartCardMap.get(selectionIndex);
    }

    public boolean hasActiveSelection() {
        return this.activeSelectionIndex != null;
    }

    public boolean hasSelectionMatched(int selectionIndex) {
        return this.smartCardMap.containsKey(selectionIndex);
    }

    public int getActiveSelectionIndex() {
        if (this.hasActiveSelection()) {
            return this.activeSelectionIndex;
        }
        throw new IllegalStateException("No active Matching card is available");
    }
}

