/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.card.selection;

import org.eclipse.keyple.core.card.message.AnswerToReset;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.eclipse.keyple.core.card.message.CardSelectionResponse;

public abstract class AbstractSmartCard {
    private final byte[] fciBytes;
    private final byte[] atrBytes;

    protected AbstractSmartCard(CardSelectionResponse cardSelectionResponse) {
        ApduResponse fci = cardSelectionResponse.getSelectionStatus().getFci();
        this.fciBytes = (byte[])(fci != null ? fci.getBytes() : null);
        AnswerToReset atr = cardSelectionResponse.getSelectionStatus().getAtr();
        this.atrBytes = (byte[])(atr != null ? atr.getBytes() : null);
    }

    public boolean hasFci() {
        return this.fciBytes != null && this.fciBytes.length > 0;
    }

    public boolean hasAtr() {
        return this.atrBytes != null && this.atrBytes.length > 0;
    }

    public byte[] getFciBytes() {
        if (this.hasFci()) {
            return this.fciBytes;
        }
        throw new IllegalStateException("No FCI is available in this AbstractSmartCard");
    }

    public byte[] getAtrBytes() {
        if (this.hasAtr()) {
            return this.atrBytes;
        }
        throw new IllegalStateException("No ATR is available in this AbstractSmartCard");
    }
}

