/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.card.selection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.keyple.core.card.command.AbstractApduCommandBuilder;
import org.eclipse.keyple.core.card.message.ApduRequest;
import org.eclipse.keyple.core.card.message.CardRequest;
import org.eclipse.keyple.core.card.message.CardSelectionRequest;
import org.eclipse.keyple.core.card.message.CardSelectionResponse;
import org.eclipse.keyple.core.card.selection.AbstractSmartCard;
import org.eclipse.keyple.core.card.selection.CardSelector;

public abstract class AbstractCardSelection<T extends AbstractApduCommandBuilder> {
    protected final CardSelector cardSelector;
    private final List<T> commandBuilders;

    protected AbstractCardSelection(CardSelector cardSelector) {
        this.cardSelector = cardSelector;
        this.commandBuilders = new ArrayList<T>();
    }

    final CardSelectionRequest getCardSelectionRequest() {
        ArrayList<ApduRequest> cardSelectionApduRequests = new ArrayList<ApduRequest>();
        for (AbstractApduCommandBuilder commandBuilder : this.commandBuilders) {
            cardSelectionApduRequests.add(commandBuilder.getApduRequest());
        }
        return new CardSelectionRequest(this.cardSelector, new CardRequest(cardSelectionApduRequests));
    }

    public CardSelector getCardSelector() {
        return this.cardSelector;
    }

    protected final void addCommandBuilder(T commandBuilder) {
        this.commandBuilders.add(commandBuilder);
    }

    protected final List<T> getCommandBuilders() {
        return this.commandBuilders;
    }

    protected abstract AbstractSmartCard parse(CardSelectionResponse var1);
}

