/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.card.message;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.keyple.core.util.ByteArrayUtil;

public final class ApduResponse
implements Serializable {
    private final byte[] bytes;
    private final int statusCode;
    private final boolean successful;

    public ApduResponse(byte[] buffer, Set<Integer> successfulStatusCodes) {
        this.bytes = buffer;
        if (buffer.length < 2) {
            throw new IllegalArgumentException("Building an ApduResponse with a illegal buffer (length must be > 2): " + buffer.length);
        }
        this.statusCode = ((buffer[buffer.length - 2] & 0xFF) << 8) + (buffer[buffer.length - 1] & 0xFF);
        this.successful = successfulStatusCodes != null ? this.statusCode == 36864 || successfulStatusCodes.contains(this.statusCode) : this.statusCode == 36864;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte[] getDataOut() {
        return Arrays.copyOfRange(this.bytes, 0, this.bytes.length - 2);
    }

    public String toString() {
        String prefix = this.isSuccessful() ? "ApduResponse: SUCCESS, RAWDATA = " : "ApduResponse: FAILURE, RAWDATA = ";
        return prefix + ByteArrayUtil.toHex(this.bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApduResponse that = (ApduResponse)o;
        if (this.successful != that.successful) {
            return false;
        }
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.bytes);
        result = 31 * result + (this.successful ? 1 : 0);
        return result;
    }
}

