/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.card.message;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.keyple.core.util.ByteArrayUtil;

public final class ApduRequest
implements Serializable {
    private final byte[] bytes;
    private final boolean case4;
    private Set<Integer> successfulStatusCodes;
    private String name;

    public ApduRequest(byte[] bytes, boolean case4) {
        this.bytes = bytes;
        this.case4 = case4;
    }

    public ApduRequest setSuccessfulStatusCodes(Set<Integer> successfulStatusCodes) {
        this.successfulStatusCodes = successfulStatusCodes;
        return this;
    }

    public boolean isCase4() {
        return this.case4;
    }

    public ApduRequest setName(String name) {
        this.name = name;
        return this;
    }

    public Set<Integer> getSuccessfulStatusCodes() {
        return this.successfulStatusCodes;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String toString() {
        StringBuilder string = new StringBuilder("ApduRequest: NAME = \"" + this.name + "\", RAWDATA = " + ByteArrayUtil.toHex(this.bytes));
        if (this.isCase4()) {
            string.append(", case4");
        }
        if (this.successfulStatusCodes != null && !this.successfulStatusCodes.isEmpty()) {
            string.append(", additional successful status codes = ");
            Iterator<Integer> iterator = this.successfulStatusCodes.iterator();
            while (iterator.hasNext()) {
                string.append(String.format("%04X", iterator.next()));
                if (!iterator.hasNext()) continue;
                string.append(", ");
            }
        }
        return string.toString();
    }
}

