/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.card.command;

import org.eclipse.keyple.core.card.command.AbstractApduCommandBuilder;
import org.eclipse.keyple.core.card.command.CardCommand;
import org.eclipse.keyple.core.card.message.ApduRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIso7816CommandBuilder
extends AbstractApduCommandBuilder {
    private static final Logger logger = LoggerFactory.getLogger(AbstractIso7816CommandBuilder.class);

    protected AbstractIso7816CommandBuilder(CardCommand commandReference, ApduRequest request) {
        super(commandReference, request);
    }

    private byte[] allocateBuffer(byte[] dataIn, Byte le) {
        int length = 4;
        if (dataIn == null && le == null) {
            ++length;
        } else {
            if (dataIn != null) {
                length += dataIn.length + 1;
            }
            if (le != null) {
                ++length;
            }
        }
        return new byte[length];
    }

    protected ApduRequest setApduRequest(byte cla, CardCommand command, byte p1, byte p2, byte[] dataIn, Byte le) {
        boolean case4;
        if (dataIn != null && le != null && le != 0) {
            throw new IllegalArgumentException("Le must be equal to 0 when not null and ingoing data are present.");
        }
        byte[] apdu = this.allocateBuffer(dataIn, le);
        apdu[0] = cla;
        apdu[1] = command.getInstructionByte();
        apdu[2] = p1;
        apdu[3] = p2;
        if (dataIn != null) {
            apdu[4] = (byte)dataIn.length;
            System.arraycopy(dataIn, 0, apdu, 5, dataIn.length);
            if (le != null) {
                case4 = true;
                apdu[apdu.length - 1] = le;
            } else {
                case4 = false;
            }
        } else {
            apdu[4] = le != null ? le : (byte)0;
            case4 = false;
        }
        if (logger.isDebugEnabled()) {
            return new ApduRequest(apdu, case4).setName(command.getName());
        }
        return new ApduRequest(apdu, case4);
    }
}

