/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.card.command;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.keyple.core.card.command.AbstractApduCommandBuilder;
import org.eclipse.keyple.core.card.command.CardCommand;
import org.eclipse.keyple.core.card.command.exception.KeypleCardCommandException;
import org.eclipse.keyple.core.card.command.exception.KeypleCardCommandUnknownStatusException;
import org.eclipse.keyple.core.card.message.ApduResponse;

public abstract class AbstractApduResponseParser {
    protected static final Map<Integer, StatusProperties> STATUS_TABLE;
    protected final ApduResponse response;
    protected final AbstractApduCommandBuilder builder;

    protected AbstractApduResponseParser(ApduResponse response, AbstractApduCommandBuilder builder) {
        this.response = response;
        this.builder = builder;
    }

    protected Map<Integer, StatusProperties> getStatusTable() {
        return STATUS_TABLE;
    }

    protected KeypleCardCommandException buildCommandException(Class<? extends KeypleCardCommandException> exceptionClass, String message, CardCommand commandRef, Integer statusCode) {
        return new KeypleCardCommandUnknownStatusException(message, commandRef, statusCode);
    }

    public final ApduResponse getApduResponse() {
        return this.response;
    }

    public AbstractApduCommandBuilder getBuilder() {
        return this.builder;
    }

    private StatusProperties getStatusCodeProperties() {
        return this.getStatusTable().get(this.response.getStatusCode());
    }

    public boolean isSuccessful() {
        StatusProperties props = this.getStatusCodeProperties();
        return props != null && props.isSuccessful();
    }

    public void checkStatus() {
        StatusProperties props = this.getStatusCodeProperties();
        if (props != null && props.isSuccessful()) {
            return;
        }
        Class<? extends KeypleCardCommandException> exceptionClass = props != null ? props.getExceptionClass() : null;
        String message = props != null ? props.getInformation() : "Unknown status";
        CardCommand commandRef = this.getCommandRef();
        Integer statusCode = this.response.getStatusCode();
        throw this.buildCommandException(exceptionClass, message, commandRef, statusCode);
    }

    protected CardCommand getCommandRef() {
        return this.builder != null ? this.builder.getCommandRef() : null;
    }

    public final String getStatusInformation() {
        StatusProperties props = this.getStatusCodeProperties();
        return props != null ? props.getInformation() : null;
    }

    static {
        HashMap<Integer, StatusProperties> m = new HashMap<Integer, StatusProperties>();
        m.put(36864, new StatusProperties("Success"));
        STATUS_TABLE = m;
    }

    protected static class StatusProperties {
        private final String information;
        private final boolean successful;
        private final Class<? extends KeypleCardCommandException> exceptionClass;

        public StatusProperties(String information) {
            this.information = information;
            this.successful = true;
            this.exceptionClass = null;
        }

        public StatusProperties(String information, Class<? extends KeypleCardCommandException> exceptionClass) {
            this.information = information;
            this.successful = exceptionClass == null;
            this.exceptionClass = exceptionClass;
        }

        public String getInformation() {
            return this.information;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public Class<? extends KeypleCardCommandException> getExceptionClass() {
            return this.exceptionClass;
        }
    }
}

