/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.core.card.command;

import org.eclipse.keyple.core.card.command.CardCommand;
import org.eclipse.keyple.core.card.message.ApduRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApduCommandBuilder {
    private static final Logger logger = LoggerFactory.getLogger(AbstractApduCommandBuilder.class);
    protected final CardCommand commandRef;
    private String name;
    protected ApduRequest request;

    protected AbstractApduCommandBuilder(CardCommand commandRef, ApduRequest request) {
        this.commandRef = commandRef;
        this.request = request;
        if (logger.isDebugEnabled()) {
            this.name = commandRef.getName();
            if (request != null) {
                this.request.setName(this.name);
            }
        }
    }

    public final void addSubName(String subName) {
        if (subName.length() != 0) {
            this.name = this.name + " - " + subName;
            if (this.request != null) {
                this.request.setName(this.name);
            }
        }
    }

    public CardCommand getCommandRef() {
        return this.commandRef;
    }

    public final String getName() {
        return this.name;
    }

    public final ApduRequest getApduRequest() {
        return this.request;
    }
}

