/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction.sammanager;

import org.eclipse.keyple.calypso.exception.CalypsoNoSamResourceAvailableException;
import org.eclipse.keyple.calypso.transaction.CalypsoSam;
import org.eclipse.keyple.calypso.transaction.sammanager.SamIdentifier;
import org.eclipse.keyple.calypso.transaction.sammanager.SamResourceManager;
import org.eclipse.keyple.calypso.transaction.sammanager.SamResourceManagerDefault;
import org.eclipse.keyple.core.card.selection.CardResource;
import org.eclipse.keyple.core.service.Plugin;
import org.eclipse.keyple.core.service.PoolPlugin;
import org.eclipse.keyple.core.service.Reader;
import org.eclipse.keyple.core.service.exception.KeypleAllocationNoReaderException;
import org.eclipse.keyple.core.service.exception.KeypleAllocationReaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamResourceManagerPool
extends SamResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(SamResourceManagerPool.class);
    protected final Plugin samReaderPlugin;
    private final int maxBlockingTime;
    private final int sleepTime;

    protected SamResourceManagerPool(PoolPlugin samPoolPlugin, int maxBlockingTime, int sleepTime) {
        if (sleepTime < 1) {
            throw new IllegalArgumentException("Sleep time must be greater than 0");
        }
        if (maxBlockingTime < 1) {
            throw new IllegalArgumentException("Max Blocking Time must be greater than 0");
        }
        this.sleepTime = sleepTime;
        this.maxBlockingTime = maxBlockingTime;
        this.samReaderPlugin = samPoolPlugin;
        logger.info("Create SAM resource manager from reader pool plugin: {}", (Object)this.samReaderPlugin.getName());
    }

    @Override
    public CardResource<CalypsoSam> allocateSamResource(SamResourceManager.AllocationMode allocationMode, SamIdentifier samIdentifier) {
        long maxBlockingDate = System.currentTimeMillis() + (long)this.maxBlockingTime;
        boolean noSamResourceLogged = false;
        logger.debug("Allocating SAM reader channel...");
        while (true) {
            try {
                do {
                    Reader samReader;
                    if ((samReader = ((PoolPlugin)this.samReaderPlugin).allocateReader(samIdentifier.getGroupReference())) != null) {
                        SamResourceManagerDefault.ManagedSamResource managedSamResource = this.createSamResource(samReader);
                        logger.debug("Allocation succeeded. SAM resource created.");
                        return managedSamResource;
                    }
                    if (allocationMode == SamResourceManager.AllocationMode.NON_BLOCKING) {
                        logger.trace("No SAM resources available at the moment.");
                        throw new CalypsoNoSamResourceAvailableException("No Sam resource could be allocated for samIdentifier +" + samIdentifier.getGroupReference());
                    }
                    if (!noSamResourceLogged) {
                        logger.trace("No SAM resources available at the moment.");
                        noSamResourceLogged = true;
                    }
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        logger.error("Interrupt exception in Thread.sleep.");
                    }
                } while (System.currentTimeMillis() < maxBlockingDate);
                logger.error("The allocation process failed. Timeout {} sec exceeded .", (Object)((double)this.maxBlockingTime / 1000.0));
                throw new CalypsoNoSamResourceAvailableException("No Sam resource could be allocated within timeout of " + this.maxBlockingTime + "ms for samIdentifier " + samIdentifier.getGroupReference());
            }
            catch (KeypleAllocationReaderException e) {
                throw new KeypleAllocationReaderException("Allocation failed due to a plugin technical error", (Throwable)e);
            }
            catch (KeypleAllocationNoReaderException keypleAllocationNoReaderException) {
                continue;
            }
            break;
        }
    }

    @Override
    public void freeSamResource(CardResource<CalypsoSam> samResource) {
        logger.debug("Freeing HSM SAM resource.");
        ((PoolPlugin)this.samReaderPlugin).releaseReader(samResource.getReader());
    }
}

