/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction.sammanager;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.eclipse.keyple.calypso.exception.CalypsoNoSamResourceAvailableException;
import org.eclipse.keyple.calypso.transaction.CalypsoSam;
import org.eclipse.keyple.calypso.transaction.sammanager.SamIdentifier;
import org.eclipse.keyple.calypso.transaction.sammanager.SamResourceManager;
import org.eclipse.keyple.core.card.selection.AbstractSmartCard;
import org.eclipse.keyple.core.card.selection.CardResource;
import org.eclipse.keyple.core.service.Plugin;
import org.eclipse.keyple.core.service.Reader;
import org.eclipse.keyple.core.service.SmartCardService;
import org.eclipse.keyple.core.service.event.ObservablePlugin;
import org.eclipse.keyple.core.service.event.ObservableReader;
import org.eclipse.keyple.core.service.event.PluginEvent;
import org.eclipse.keyple.core.service.event.ReaderEvent;
import org.eclipse.keyple.core.service.exception.KeypleException;
import org.eclipse.keyple.core.service.exception.KeyplePluginNotFoundException;
import org.eclipse.keyple.core.service.exception.KeypleReaderException;
import org.eclipse.keyple.core.service.exception.KeypleReaderNotFoundException;
import org.eclipse.keyple.core.util.ByteArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamResourceManagerDefault
extends SamResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(SamResourceManagerDefault.class);
    private final ConcurrentMap<String, ManagedSamResource> localManagedSamResources = new ConcurrentHashMap<String, ManagedSamResource>();
    final ReaderObserver readerObserver;
    protected final Plugin samReaderPlugin;
    private final int maxBlockingTime;
    private final int sleepTime;

    protected SamResourceManagerDefault(Plugin plugin, String samReaderFilter, int maxBlockingTime, int sleepTime) {
        if (sleepTime < 1) {
            throw new IllegalArgumentException("Sleep time must be greater than 0");
        }
        if (maxBlockingTime < 1) {
            throw new IllegalArgumentException("Max Blocking Time must be greater than 0");
        }
        this.sleepTime = sleepTime;
        this.maxBlockingTime = maxBlockingTime;
        this.samReaderPlugin = plugin;
        this.readerObserver = new ReaderObserver();
        logger.info("PLUGINNAME = {} initialize the localManagedSamResources with the {} connected readers filtered by {}", new Object[]{this.samReaderPlugin.getName(), this.samReaderPlugin.getReaders().size(), samReaderFilter});
        Pattern p = Pattern.compile(samReaderFilter);
        Set samReadersNames = this.samReaderPlugin.getReaders().keySet();
        for (String samReaderName : samReadersNames) {
            if (p.matcher(samReaderName).matches()) {
                logger.trace("Add reader: {}", (Object)samReaderName);
                try {
                    this.initSamReader(this.samReaderPlugin.getReader(samReaderName), this.readerObserver);
                }
                catch (KeypleReaderException e) {
                    logger.error("could not init samReader {}", (Object)samReaderName, (Object)e);
                }
                continue;
            }
            logger.trace("Reader not matching: {}", (Object)samReaderName);
        }
        if (plugin instanceof ObservablePlugin) {
            PluginObserver pluginObserver = new PluginObserver(this.readerObserver, samReaderFilter);
            logger.trace("Add observer PLUGINNAME = {}", (Object)this.samReaderPlugin.getName());
            ((ObservablePlugin)this.samReaderPlugin).addObserver((ObservablePlugin.PluginObserver)pluginObserver);
        }
    }

    protected void removeResource(Reader samReader) {
        ManagedSamResource managedSamResource = (ManagedSamResource)((Object)this.localManagedSamResources.get(samReader.getName()));
        if (managedSamResource != null) {
            this.localManagedSamResources.remove(samReader.getName());
            if (logger.isInfoEnabled()) {
                logger.trace("Freed SAM resource: READER = {}, SAM_REVISION = {}, SAM_SERIAL_NUMBER = {}", new Object[]{samReader.getName(), ((CalypsoSam)managedSamResource.getSmartCard()).getSamRevision(), ByteArrayUtil.toHex((byte[])((CalypsoSam)managedSamResource.getSmartCard()).getSerialNumber())});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CardResource<CalypsoSam> allocateSamResource(SamResourceManager.AllocationMode allocationMode, SamIdentifier samIdentifier) {
        long maxBlockingDate = System.currentTimeMillis() + (long)this.maxBlockingTime;
        boolean noSamResourceLogged = false;
        logger.trace("Allocating SAM reader channel...");
        do {
            ConcurrentMap<String, ManagedSamResource> concurrentMap = this.localManagedSamResources;
            synchronized (concurrentMap) {
                for (Map.Entry entry : this.localManagedSamResources.entrySet()) {
                    ManagedSamResource managedSamResource = (ManagedSamResource)((Object)entry.getValue());
                    if (!managedSamResource.isSamResourceFree() || !managedSamResource.isSamMatching(samIdentifier)) continue;
                    managedSamResource.setSamResourceStatus(ManagedSamResource.SamResourceStatus.BUSY);
                    logger.debug("Allocation succeeded. SAM resource created.");
                    return managedSamResource;
                }
            }
            if (allocationMode == SamResourceManager.AllocationMode.NON_BLOCKING) {
                logger.trace("No SAM resources available at the moment.");
                throw new CalypsoNoSamResourceAvailableException("No Sam resource could be allocated for samIdentifier +" + samIdentifier.getGroupReference());
            }
            if (!noSamResourceLogged) {
                logger.trace("No SAM resources available at the moment.");
                noSamResourceLogged = true;
            }
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Interrupt exception in Thread.sleep.");
            }
        } while (System.currentTimeMillis() < maxBlockingDate);
        logger.error("The allocation process failed. Timeout {} sec exceeded .", (Object)((double)this.maxBlockingTime / 1000.0));
        throw new CalypsoNoSamResourceAvailableException("No Sam resource could be allocated within timeout of " + this.maxBlockingTime + "ms for samIdentifier " + samIdentifier.getGroupReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeSamResource(CardResource<CalypsoSam> samResource) {
        ConcurrentMap<String, ManagedSamResource> concurrentMap = this.localManagedSamResources;
        synchronized (concurrentMap) {
            ManagedSamResource managedSamResource = (ManagedSamResource)((Object)this.localManagedSamResources.get(samResource.getReader().getName()));
            if (managedSamResource != null) {
                logger.trace("Freeing local SAM resource.");
                managedSamResource.setSamResourceStatus(ManagedSamResource.SamResourceStatus.FREE);
            } else {
                logger.error("SAM resource not found while freeing.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSamReader(Reader samReader, ReaderObserver readerObserver) {
        block7: {
            try {
                if (!samReader.isCardPresent()) break block7;
                logger.trace("Create SAM resource: {}", (Object)samReader.getName());
                ConcurrentMap<String, ManagedSamResource> concurrentMap = this.localManagedSamResources;
                synchronized (concurrentMap) {
                    this.localManagedSamResources.put(samReader.getName(), this.createSamResource(samReader));
                }
            }
            catch (KeypleException e) {
                throw new IllegalArgumentException("Parameters are not supported for this reader : protocol:TO, mode:shared");
            }
        }
        if (samReader instanceof ObservableReader && readerObserver != null) {
            logger.trace("Add observer and start detection READERNAME = {}", (Object)samReader.getName());
            ((ObservableReader)samReader).addObserver((ObservableReader.ReaderObserver)readerObserver);
            ((ObservableReader)samReader).startCardDetection(ObservableReader.PollingMode.REPEATING);
        } else {
            logger.trace("Sam Reader is not an ObservableReader = {}", (Object)samReader.getName());
        }
    }

    static class ManagedSamResource
    extends CardResource<CalypsoSam> {
        private SamResourceStatus samResourceStatus = SamResourceStatus.FREE;
        private SamIdentifier samIdentifier = null;

        public ManagedSamResource(Reader reader, CalypsoSam calypsoSam) {
            super(reader, (AbstractSmartCard)calypsoSam);
        }

        public boolean isSamResourceFree() {
            return this.samResourceStatus.equals((Object)SamResourceStatus.FREE);
        }

        public void setSamIdentifier(SamIdentifier samIdentifier) {
            this.samIdentifier = samIdentifier;
        }

        public boolean isSamMatching(SamIdentifier samIdentifier) {
            return samIdentifier.matches(this.samIdentifier);
        }

        public void setSamResourceStatus(SamResourceStatus samResourceStatus) {
            this.samResourceStatus = samResourceStatus;
        }

        public static enum SamResourceStatus {
            FREE,
            BUSY;

        }
    }

    class ReaderObserver
    implements ObservableReader.ReaderObserver {
        ReaderObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(ReaderEvent event) {
            Reader samReader = null;
            try {
                samReader = SamResourceManagerDefault.this.samReaderPlugin.getReader(event.getReaderName());
            }
            catch (KeypleReaderNotFoundException e) {
                e.printStackTrace();
            }
            ConcurrentMap concurrentMap = SamResourceManagerDefault.this.localManagedSamResources;
            synchronized (concurrentMap) {
                switch (event.getEventType()) {
                    case CARD_MATCHED: 
                    case CARD_INSERTED: {
                        if (SamResourceManagerDefault.this.localManagedSamResources.containsKey(samReader.getName())) {
                            logger.trace("Reader is already present in the local samResources -  READERNAME = {}", (Object)samReader.getName());
                            return;
                        }
                        ManagedSamResource newSamResource = null;
                        try {
                            newSamResource = SamResourceManagerDefault.this.createSamResource(samReader);
                        }
                        catch (CalypsoNoSamResourceAvailableException e) {
                            logger.error("Failed to create a CardResource<CalypsoSam> from {}", (Object)samReader.getName());
                        }
                        if (newSamResource == null) break;
                        if (logger.isInfoEnabled()) {
                            logger.trace("Created SAM resource: READER = {}, SAM_REVISION = {}, SAM_SERIAL_NUMBER = {}", new Object[]{event.getReaderName(), ((CalypsoSam)newSamResource.getSmartCard()).getSamRevision(), ByteArrayUtil.toHex((byte[])((CalypsoSam)newSamResource.getSmartCard()).getSerialNumber())});
                        }
                        SamResourceManagerDefault.this.localManagedSamResources.put(samReader.getName(), newSamResource);
                        break;
                    }
                    case CARD_REMOVED: {
                        SamResourceManagerDefault.this.removeResource(samReader);
                    }
                }
            }
        }
    }

    class PluginObserver
    implements ObservablePlugin.PluginObserver {
        final ReaderObserver readerObserver;
        final String samReaderFilter;
        Pattern p;

        PluginObserver(ReaderObserver readerObserver, String samReaderFilter) {
            this.readerObserver = readerObserver;
            this.samReaderFilter = samReaderFilter;
        }

        public void update(PluginEvent event) {
            block9: for (String readerName : event.getReaderNames()) {
                Reader samReader = null;
                logger.info("PluginEvent: PLUGINNAME = {}, READERNAME = {}, EVENTTYPE = {}", new Object[]{event.getPluginName(), readerName, event.getEventType()});
                try {
                    samReader = SmartCardService.getInstance().getPlugin(event.getPluginName()).getReader(readerName);
                }
                catch (KeyplePluginNotFoundException e) {
                    logger.error("Plugin not found {}", (Object)event.getPluginName());
                    return;
                }
                catch (KeypleReaderNotFoundException e) {
                    logger.error("Reader not found {}", (Object)readerName);
                    return;
                }
                switch (event.getEventType()) {
                    case READER_CONNECTED: {
                        if (SamResourceManagerDefault.this.localManagedSamResources.containsKey(readerName)) {
                            logger.trace("Reader is already present in the local samResources -  READERNAME = {}", (Object)readerName);
                            return;
                        }
                        logger.trace("New reader! READERNAME = {}", (Object)samReader.getName());
                        this.p = Pattern.compile(this.samReaderFilter);
                        if (this.p.matcher(readerName).matches()) {
                            try {
                                SamResourceManagerDefault.this.initSamReader(samReader, this.readerObserver);
                            }
                            catch (KeypleReaderException e) {
                                logger.error("Unable to init Sam reader {}", (Object)samReader.getName(), (Object)e.getCause());
                            }
                            continue block9;
                        }
                        logger.trace("Reader not matching: {}", (Object)readerName);
                        continue block9;
                    }
                    case READER_DISCONNECTED: {
                        this.p = Pattern.compile(this.samReaderFilter);
                        if (this.p.matcher(readerName).matches()) {
                            logger.trace("Reader removed. READERNAME = {}", (Object)readerName);
                            if (!(samReader instanceof ObservableReader)) continue block9;
                            if (this.readerObserver != null) {
                                logger.trace("Remove observer and stop detection READERNAME = {}", (Object)readerName);
                                ((ObservableReader)samReader).removeObserver((ObservableReader.ReaderObserver)this.readerObserver);
                                ((ObservableReader)samReader).stopCardDetection();
                                continue block9;
                            }
                            SamResourceManagerDefault.this.removeResource(samReader);
                            logger.trace("Unplugged reader READERNAME = {} wasn't observed. Resource removed.", (Object)readerName);
                            continue block9;
                        }
                        logger.trace("Reader not matching: {}", (Object)readerName);
                        continue block9;
                    }
                }
                logger.warn("Unexpected reader event. EVENT = {}", (Object)event.getEventType().name());
            }
        }
    }
}

