/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction.sammanager;

import org.eclipse.keyple.calypso.command.sam.SamRevision;
import org.eclipse.keyple.calypso.exception.CalypsoNoSamResourceAvailableException;
import org.eclipse.keyple.calypso.transaction.CalypsoSam;
import org.eclipse.keyple.calypso.transaction.SamSelection;
import org.eclipse.keyple.calypso.transaction.SamSelector;
import org.eclipse.keyple.calypso.transaction.sammanager.SamIdentifier;
import org.eclipse.keyple.calypso.transaction.sammanager.SamResourceManagerDefault;
import org.eclipse.keyple.core.card.selection.AbstractCardSelection;
import org.eclipse.keyple.core.card.selection.CardResource;
import org.eclipse.keyple.core.card.selection.CardSelectionsResult;
import org.eclipse.keyple.core.card.selection.CardSelectionsService;
import org.eclipse.keyple.core.service.Reader;
import org.eclipse.keyple.core.service.exception.KeypleException;

public abstract class SamResourceManager {
    public abstract CardResource<CalypsoSam> allocateSamResource(AllocationMode var1, SamIdentifier var2);

    public abstract void freeSamResource(CardResource<CalypsoSam> var1);

    protected SamResourceManagerDefault.ManagedSamResource createSamResource(Reader samReader) {
        CardSelectionsService samSelection = new CardSelectionsService();
        samSelection.prepareSelection((AbstractCardSelection)new SamSelection(SamSelector.builder().samRevision(SamRevision.AUTO).build()));
        CardSelectionsResult cardSelectionsResult = null;
        try {
            cardSelectionsResult = samSelection.processExplicitSelections(samReader);
        }
        catch (KeypleException e) {
            throw new CalypsoNoSamResourceAvailableException("Failed to select a SAM");
        }
        if (!cardSelectionsResult.hasActiveSelection()) {
            throw new CalypsoNoSamResourceAvailableException("Unable to open a logical channel for SAM!");
        }
        CalypsoSam calypsoSam = (CalypsoSam)cardSelectionsResult.getActiveSmartCard();
        return new SamResourceManagerDefault.ManagedSamResource(samReader, calypsoSam);
    }

    public static enum AllocationMode {
        BLOCKING,
        NON_BLOCKING;

    }
}

