/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction.sammanager;

import java.util.regex.Pattern;
import org.eclipse.keyple.calypso.command.sam.SamRevision;

public class SamIdentifier {
    SamRevision samRevision;
    String serialNumber;
    String groupReference;

    private SamIdentifier(SamIdentifierBuilder builder) {
        this.samRevision = builder.samRevision;
        this.serialNumber = builder.serialNumber;
        this.groupReference = builder.groupReference;
    }

    public static SamIdentifierBuilder builder() {
        return new SamIdentifierBuilder();
    }

    public SamRevision getSamRevision() {
        return this.samRevision;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getGroupReference() {
        return this.groupReference;
    }

    public boolean matches(SamIdentifier samIdentifier) {
        Pattern p;
        if (samIdentifier == null) {
            return true;
        }
        if (samIdentifier.getSamRevision() != SamRevision.AUTO && samIdentifier.getSamRevision() != this.samRevision) {
            return false;
        }
        if (samIdentifier.getSerialNumber() != null && !samIdentifier.getSerialNumber().isEmpty() && !(p = Pattern.compile(samIdentifier.getSerialNumber())).matcher(this.serialNumber).matches()) {
            return false;
        }
        return samIdentifier.getGroupReference() == null || samIdentifier.getGroupReference().equals(this.groupReference);
    }

    public static class SamIdentifierBuilder {
        private SamRevision samRevision;
        private String serialNumber = "";
        private String groupReference = "";

        public SamIdentifierBuilder samRevision(SamRevision samRevision) {
            this.samRevision = samRevision;
            return this;
        }

        public SamIdentifierBuilder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public SamIdentifierBuilder groupReference(String groupReference) {
            this.groupReference = groupReference;
            return this;
        }

        public SamIdentifier build() {
            return new SamIdentifier(this);
        }
    }
}

