/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction;

import org.eclipse.keyple.core.util.ByteArrayUtil;

public class SvLoadLogRecord {
    final int offset;
    final byte[] poResponse;

    public SvLoadLogRecord(byte[] poResponse, int offset) {
        this.poResponse = poResponse;
        this.offset = offset;
    }

    public int getAmount() {
        return ByteArrayUtil.threeBytesSignedToInt((byte[])this.poResponse, (int)(this.offset + 8));
    }

    public int getBalance() {
        return ByteArrayUtil.threeBytesSignedToInt((byte[])this.poResponse, (int)(this.offset + 5));
    }

    public int getLoadTime() {
        return ByteArrayUtil.twoBytesToInt((byte[])this.getLoadTimeBytes(), (int)0);
    }

    public byte[] getLoadTimeBytes() {
        byte[] time = new byte[]{this.poResponse[this.offset + 11], this.poResponse[this.offset + 12]};
        return time;
    }

    public int getLoadDate() {
        return ByteArrayUtil.twoBytesToInt((byte[])this.getLoadDateBytes(), (int)0);
    }

    public byte[] getLoadDateBytes() {
        byte[] date = new byte[]{this.poResponse[this.offset + 0], this.poResponse[this.offset + 1]};
        return date;
    }

    public String getFreeByte() {
        return new String(this.getFreeByteBytes());
    }

    public byte[] getFreeByteBytes() {
        byte[] free = new byte[]{this.poResponse[this.offset + 2], this.poResponse[this.offset + 4]};
        return free;
    }

    public byte getKvc() {
        return this.poResponse[this.offset + 3];
    }

    public long getSamId() {
        return ByteArrayUtil.fourBytesToInt((byte[])this.getSamIdBytes(), (int)0);
    }

    public byte[] getSamIdBytes() {
        byte[] samId = new byte[4];
        System.arraycopy(this.poResponse, this.offset + 13, samId, 0, 4);
        return samId;
    }

    public int getSvTNum() {
        return ByteArrayUtil.twoBytesToInt((byte[])this.getSvTNumBytes(), (int)0);
    }

    public byte[] getSvTNumBytes() {
        byte[] tnNum = new byte[]{this.poResponse[this.offset + 20], this.poResponse[this.offset + 21]};
        return tnNum;
    }

    public int getSamTNum() {
        return ByteArrayUtil.threeBytesToInt((byte[])this.getSamTNumBytes(), (int)0);
    }

    public byte[] getSamTNumBytes() {
        byte[] samTNum = new byte[3];
        System.arraycopy(this.poResponse, this.offset + 17, samTNum, 0, 3);
        return samTNum;
    }

    public String toString() {
        return "{\"SvLoadLogRecord\":{\"amount\":" + this.getAmount() + ", \"balance\":" + this.getBalance() + ", \"debitDate\":" + this.getLoadDate() + ", \"loadTime\":" + this.getLoadDate() + ", \"freeBytes\":" + ByteArrayUtil.toHex((byte[])this.getFreeByteBytes()) + ", \"kvc\":" + this.getKvc() + ", \"samId\":" + ByteArrayUtil.toHex((byte[])this.getSamIdBytes()) + ", \"svTransactionNumber\":" + this.getSvTNum() + ", \"svSamTransactionNumber\":" + this.getSamTNum() + "}}";
    }
}

