/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction;

import org.eclipse.keyple.core.util.ByteArrayUtil;

public class SvDebitLogRecord {
    final int offset;
    final byte[] poResponse;

    public SvDebitLogRecord(byte[] poResponse, int offset) {
        this.poResponse = poResponse;
        this.offset = offset;
    }

    public int getAmount() {
        return ByteArrayUtil.twoBytesSignedToInt((byte[])this.poResponse, (int)this.offset);
    }

    public int getBalance() {
        return ByteArrayUtil.threeBytesSignedToInt((byte[])this.poResponse, (int)(this.offset + 14));
    }

    public int getDebitTime() {
        return ByteArrayUtil.twoBytesToInt((byte[])this.getDebitTimeBytes(), (int)0);
    }

    public byte[] getDebitTimeBytes() {
        byte[] time = new byte[]{this.poResponse[this.offset + 4], this.poResponse[this.offset + 5]};
        return time;
    }

    public int getDebitDate() {
        return ByteArrayUtil.twoBytesToInt((byte[])this.getDebitDateBytes(), (int)0);
    }

    public byte[] getDebitDateBytes() {
        byte[] date = new byte[]{this.poResponse[this.offset + 2], this.poResponse[this.offset + 3]};
        return date;
    }

    public byte getKvc() {
        return this.poResponse[this.offset + 6];
    }

    public long getSamId() {
        return ByteArrayUtil.fourBytesToInt((byte[])this.getSamIdBytes(), (int)0);
    }

    public byte[] getSamIdBytes() {
        byte[] samId = new byte[4];
        System.arraycopy(this.poResponse, this.offset + 7, samId, 0, 4);
        return samId;
    }

    public int getSvTNum() {
        return ByteArrayUtil.twoBytesToInt((byte[])this.getSvTNumBytes(), (int)0);
    }

    public byte[] getSvTNumBytes() {
        byte[] tnNum = new byte[]{this.poResponse[this.offset + 17], this.poResponse[this.offset + 18]};
        return tnNum;
    }

    public int getSamTNum() {
        return ByteArrayUtil.threeBytesToInt((byte[])this.getSamTNumBytes(), (int)0);
    }

    public byte[] getSamTNumBytes() {
        byte[] samTNum = new byte[3];
        System.arraycopy(this.poResponse, this.offset + 11, samTNum, 0, 3);
        return samTNum;
    }

    public String toString() {
        return "{\"SvDebitLogRecord\":{\"amount\":" + this.getAmount() + ", \"balance\":" + this.getBalance() + ", \"debitDate\":" + this.getDebitDate() + ", \"debitTime\":" + this.getDebitDate() + ", \"kvc\":" + this.getKvc() + ", \"samId\":" + ByteArrayUtil.toHex((byte[])this.getSamIdBytes()) + ", \"svTransactionNumber\":" + this.getSvTNum() + ", \"svSamTransactionNumber\":" + this.getSamTNum() + "}}";
    }
}

