/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction;

import org.eclipse.keyple.calypso.command.sam.SamRevision;
import org.eclipse.keyple.core.card.selection.CardSelector;

public class SamSelector
extends CardSelector {
    private final SamRevision targetSamRevision;
    private final byte[] unlockData;

    private SamSelector(SamSelectorBuilder builder) {
        super((CardSelector.CardSelectorBuilder)builder);
        String atrRegex;
        String snRegex = builder.serialNumber == null || builder.serialNumber.isEmpty() ? ".{8}" : builder.serialNumber;
        this.unlockData = builder.unlockData;
        this.targetSamRevision = builder.samRevision;
        switch (this.targetSamRevision) {
            case C1: 
            case S1D: 
            case S1E: {
                atrRegex = "3B(.{6}|.{10})805A..80" + this.targetSamRevision.getApplicationTypeMask() + "20.{4}" + snRegex + "829000";
                break;
            }
            case AUTO: {
                atrRegex = ".*";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SAM subtype.");
            }
        }
        this.getAtrFilter().setAtrRegex(atrRegex);
    }

    public static SamSelectorBuilder builder() {
        return new SamSelectorBuilder();
    }

    public SamRevision getTargetSamRevision() {
        return this.targetSamRevision;
    }

    public byte[] getUnlockData() {
        return this.unlockData;
    }

    public static final class SamSelectorBuilder
    extends CardSelector.CardSelectorBuilder {
        private SamRevision samRevision;
        private String serialNumber;
        private byte[] unlockData;

        public SamSelectorBuilder() {
            this.atrFilter(new CardSelector.AtrFilter(""));
        }

        public SamSelectorBuilder samRevision(SamRevision samRevision) {
            this.samRevision = samRevision;
            return this;
        }

        public SamSelectorBuilder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public SamSelectorBuilder unlockData(byte[] unlockData) {
            if (unlockData == null || unlockData.length != 8 && unlockData.length != 16) {
                throw new IllegalArgumentException("Bad unlock data length. Should be 8 or 16 bytes.");
            }
            this.unlockData = unlockData;
            return this;
        }

        public SamSelectorBuilder cardProtocol(String cardProtocol) {
            return (SamSelectorBuilder)super.cardProtocol(cardProtocol);
        }

        public SamSelectorBuilder atrFilter(CardSelector.AtrFilter atrFilter) {
            return (SamSelectorBuilder)super.atrFilter(atrFilter);
        }

        public SamSelectorBuilder aidSelector(CardSelector.AidSelector aidSelector) {
            return (SamSelectorBuilder)super.aidSelector(aidSelector);
        }

        public SamSelector build() {
            return new SamSelector(this);
        }
    }
}

