/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction;

import java.util.List;
import org.eclipse.keyple.calypso.command.sam.AbstractSamCommandBuilder;
import org.eclipse.keyple.calypso.command.sam.AbstractSamResponseParser;
import org.eclipse.keyple.calypso.command.sam.builder.security.UnlockCmdBuild;
import org.eclipse.keyple.calypso.transaction.CalypsoSam;
import org.eclipse.keyple.calypso.transaction.SamSelector;
import org.eclipse.keyple.calypso.transaction.exception.CalypsoDesynchronizedExchangesException;
import org.eclipse.keyple.core.card.command.AbstractApduCommandBuilder;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.eclipse.keyple.core.card.message.CardSelectionResponse;
import org.eclipse.keyple.core.card.selection.AbstractCardSelection;
import org.eclipse.keyple.core.card.selection.CardSelector;

public class SamSelection
extends AbstractCardSelection<AbstractSamCommandBuilder<? extends AbstractSamResponseParser>> {
    public SamSelection(SamSelector samSelector) {
        super((CardSelector)samSelector);
        byte[] unlockData = samSelector.getUnlockData();
        if (unlockData != null) {
            this.addCommandBuilder((AbstractApduCommandBuilder)new UnlockCmdBuild(samSelector.getTargetSamRevision(), samSelector.getUnlockData()));
        }
    }

    protected CalypsoSam parse(CardSelectionResponse cardSelectionResponse) {
        List commandBuilders = this.getCommandBuilders();
        if (commandBuilders.size() == 1) {
            List apduResponses = cardSelectionResponse.getCardResponse().getApduResponses();
            if (apduResponses == null) {
                throw new CalypsoDesynchronizedExchangesException("Mismatch in the number of requests/responses");
            }
            ((AbstractSamResponseParser)((Object)((AbstractSamCommandBuilder)((Object)commandBuilders.get(0))).createResponseParser((ApduResponse)apduResponses.get(0)))).checkStatus();
        }
        return new CalypsoSam(cardSelectionResponse);
    }
}

