/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.keyple.calypso.KeyReference;
import org.eclipse.keyple.calypso.command.po.PoRevision;
import org.eclipse.keyple.calypso.command.po.builder.storedvalue.SvDebitCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.storedvalue.SvReloadCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.storedvalue.SvUndebitCmdBuild;
import org.eclipse.keyple.calypso.command.sam.AbstractSamCommandBuilder;
import org.eclipse.keyple.calypso.command.sam.AbstractSamResponseParser;
import org.eclipse.keyple.calypso.command.sam.builder.security.CardCipherPinCmdBuild;
import org.eclipse.keyple.calypso.command.sam.builder.security.DigestAuthenticateCmdBuild;
import org.eclipse.keyple.calypso.command.sam.builder.security.DigestCloseCmdBuild;
import org.eclipse.keyple.calypso.command.sam.builder.security.DigestInitCmdBuild;
import org.eclipse.keyple.calypso.command.sam.builder.security.DigestUpdateCmdBuild;
import org.eclipse.keyple.calypso.command.sam.builder.security.GiveRandomCmdBuild;
import org.eclipse.keyple.calypso.command.sam.builder.security.SamGetChallengeCmdBuild;
import org.eclipse.keyple.calypso.command.sam.builder.security.SelectDiversifierCmdBuild;
import org.eclipse.keyple.calypso.command.sam.builder.security.SvCheckCmdBuild;
import org.eclipse.keyple.calypso.command.sam.builder.security.SvPrepareDebitCmdBuild;
import org.eclipse.keyple.calypso.command.sam.builder.security.SvPrepareLoadCmdBuild;
import org.eclipse.keyple.calypso.command.sam.builder.security.SvPrepareUndebitCmdBuild;
import org.eclipse.keyple.calypso.command.sam.parser.security.CardCipherPinRespPars;
import org.eclipse.keyple.calypso.command.sam.parser.security.DigestAuthenticateRespPars;
import org.eclipse.keyple.calypso.command.sam.parser.security.DigestCloseRespPars;
import org.eclipse.keyple.calypso.command.sam.parser.security.SamGetChallengeRespPars;
import org.eclipse.keyple.calypso.command.sam.parser.security.SvCheckRespPars;
import org.eclipse.keyple.calypso.command.sam.parser.security.SvPrepareOperationRespPars;
import org.eclipse.keyple.calypso.transaction.CalypsoPo;
import org.eclipse.keyple.calypso.transaction.CalypsoSam;
import org.eclipse.keyple.calypso.transaction.PoSecuritySettings;
import org.eclipse.keyple.calypso.transaction.PoTransaction;
import org.eclipse.keyple.calypso.transaction.exception.CalypsoDesynchronizedExchangesException;
import org.eclipse.keyple.calypso.transaction.exception.CalypsoSamIOException;
import org.eclipse.keyple.core.card.message.ApduRequest;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.eclipse.keyple.core.card.message.CardRequest;
import org.eclipse.keyple.core.card.message.CardResponse;
import org.eclipse.keyple.core.card.message.ChannelControl;
import org.eclipse.keyple.core.card.message.ProxyReader;
import org.eclipse.keyple.core.card.selection.CardResource;
import org.eclipse.keyple.core.service.exception.KeypleReaderIOException;
import org.eclipse.keyple.core.util.ByteArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SamCommandProcessor {
    private static final Logger logger = LoggerFactory.getLogger(SamCommandProcessor.class);
    private static final byte KIF_UNDEFINED = -1;
    private static final byte CHALLENGE_LENGTH_REV_INF_32 = 4;
    private static final byte CHALLENGE_LENGTH_REV32 = 8;
    private static final byte SIGNATURE_LENGTH_REV_INF_32 = 4;
    private static final byte SIGNATURE_LENGTH_REV32 = 8;
    private final CardResource<CalypsoSam> samResource;
    private final ProxyReader samReader;
    private final CardResource<CalypsoPo> poResource;
    private final PoSecuritySettings poSecuritySettings;
    private static final List<byte[]> poDigestDataCache = new ArrayList<byte[]>();
    private boolean sessionEncryption;
    private boolean verificationMode;
    private byte workKeyRecordNumber;
    private byte workKeyKif;
    private byte workKeyKVC;
    private boolean isDiversificationDone;
    private boolean isDigestInitDone;
    private boolean isDigesterInitialized;

    SamCommandProcessor(CardResource<CalypsoPo> poResource, PoSecuritySettings poSecuritySettings) {
        this.poResource = poResource;
        this.poSecuritySettings = poSecuritySettings;
        this.samResource = poSecuritySettings.getSamResource();
        this.samReader = (ProxyReader)this.samResource.getReader();
    }

    byte[] getSessionTerminalChallenge() {
        byte[] sessionTerminalChallenge;
        CardResponse samCardResponse;
        ArrayList<ApduRequest> apduRequests = new ArrayList<ApduRequest>();
        if (!this.isDiversificationDone) {
            SelectDiversifierCmdBuild selectDiversifier = new SelectDiversifierCmdBuild(((CalypsoSam)this.samResource.getSmartCard()).getSamRevision(), ((CalypsoPo)this.poResource.getSmartCard()).getApplicationSerialNumberBytes());
            apduRequests.add(selectDiversifier.getApduRequest());
            this.isDiversificationDone = true;
        }
        byte challengeLength = ((CalypsoPo)this.poResource.getSmartCard()).isConfidentialSessionModeSupported() ? (byte)8 : 4;
        SamGetChallengeCmdBuild getChallengeCmdBuild = new SamGetChallengeCmdBuild(((CalypsoSam)this.samResource.getSmartCard()).getSamRevision(), challengeLength);
        apduRequests.add(getChallengeCmdBuild.getApduRequest());
        try {
            samCardResponse = this.samReader.transmitCardRequest(new CardRequest(apduRequests), ChannelControl.KEEP_OPEN);
        }
        catch (KeypleReaderIOException e) {
            throw new CalypsoSamIOException("SAM IO Exception while getting terminal challenge.", e);
        }
        List samApduResponses = samCardResponse.getApduResponses();
        int numberOfSamCmd = apduRequests.size();
        if (samApduResponses.size() == numberOfSamCmd) {
            SamGetChallengeRespPars getChallengeRespPars = (SamGetChallengeRespPars)((Object)getChallengeCmdBuild.createResponseParser((ApduResponse)samApduResponses.get(numberOfSamCmd - 1)));
            getChallengeRespPars.checkStatus();
            sessionTerminalChallenge = getChallengeRespPars.getChallenge();
            if (logger.isDebugEnabled()) {
                logger.debug("identification: TERMINALCHALLENGE = {}", (Object)ByteArrayUtil.toHex((byte[])sessionTerminalChallenge));
            }
        } else {
            throw new CalypsoDesynchronizedExchangesException("The number of commands/responses does not match: cmd=" + numberOfSamCmd + ", resp=" + samApduResponses.size());
        }
        return sessionTerminalChallenge;
    }

    private byte determineWorkKif(byte poKif, PoTransaction.SessionSetting.AccessLevel accessLevel) {
        byte kif = poKif == -1 ? this.poSecuritySettings.getSessionDefaultKif(accessLevel) : poKif;
        return kif;
    }

    void initializeDigester(PoTransaction.SessionSetting.AccessLevel accessLevel, boolean sessionEncryption, boolean verificationMode, byte poKif, byte poKVC, byte[] digestData) {
        this.sessionEncryption = sessionEncryption;
        this.verificationMode = verificationMode;
        this.workKeyKif = this.determineWorkKif(poKif, accessLevel);
        this.workKeyKVC = poKVC;
        if (logger.isDebugEnabled()) {
            logger.debug("initialize: POREVISION = {}, SAMREVISION = {}, SESSIONENCRYPTION = {}, VERIFICATIONMODE = {}", new Object[]{((CalypsoPo)this.poResource.getSmartCard()).getRevision(), ((CalypsoSam)this.samResource.getSmartCard()).getSamRevision(), sessionEncryption, verificationMode});
            logger.debug("initialize: VERIFICATIONMODE = {}, REV32MODE = {} KEYRECNUMBER = {}", new Object[]{verificationMode, ((CalypsoPo)this.poResource.getSmartCard()).isConfidentialSessionModeSupported(), this.workKeyRecordNumber});
            logger.debug("initialize: KIF = {}, KVC {}, DIGESTDATA = {}", new Object[]{String.format("%02X", poKif), String.format("%02X", poKVC), ByteArrayUtil.toHex((byte[])digestData)});
        }
        poDigestDataCache.clear();
        poDigestDataCache.add(digestData);
        this.isDigestInitDone = false;
        this.isDigesterInitialized = true;
    }

    private void pushPoExchangeData(ApduRequest request, ApduResponse response) {
        logger.trace("pushPoExchangeData: REQUEST = {}", (Object)request);
        if (request.isCase4()) {
            poDigestDataCache.add(Arrays.copyOfRange(request.getBytes(), 0, request.getBytes().length - 1));
        } else {
            poDigestDataCache.add(request.getBytes());
        }
        logger.trace("pushPoExchangeData: RESPONSE = {}", (Object)response);
        poDigestDataCache.add(response.getBytes());
    }

    void pushPoExchangeDataList(List<ApduRequest> requests, List<ApduResponse> responses, int startIndex) {
        for (int i = startIndex; i < requests.size(); ++i) {
            this.pushPoExchangeData(requests.get(i), responses.get(i));
        }
    }

    private List<AbstractSamCommandBuilder<? extends AbstractSamResponseParser>> getPendingSamCommands(boolean addDigestClose) {
        ArrayList<AbstractSamCommandBuilder<? extends AbstractSamResponseParser>> samCommands = new ArrayList<AbstractSamCommandBuilder<? extends AbstractSamResponseParser>>();
        if (poDigestDataCache.isEmpty()) {
            logger.debug("getSamDigestRequest: no data in cache.");
            throw new IllegalStateException("Digest data cache is empty.");
        }
        if (!this.isDigestInitDone && poDigestDataCache.size() % 2 == 0) {
            logger.debug("getSamDigestRequest: wrong number of buffer in cache NBR = {}.", (Object)poDigestDataCache.size());
            throw new IllegalStateException("Digest data cache is inconsistent.");
        }
        if (!this.isDigestInitDone) {
            samCommands.add(new DigestInitCmdBuild(((CalypsoSam)this.samResource.getSmartCard()).getSamRevision(), this.verificationMode, ((CalypsoPo)this.poResource.getSmartCard()).isConfidentialSessionModeSupported(), this.workKeyRecordNumber, this.workKeyKif, this.workKeyKVC, poDigestDataCache.get(0)));
            poDigestDataCache.remove(0);
            this.isDigestInitDone = true;
        }
        for (int i = 0; i < poDigestDataCache.size(); ++i) {
            samCommands.add(new DigestUpdateCmdBuild(((CalypsoSam)this.samResource.getSmartCard()).getSamRevision(), this.sessionEncryption, poDigestDataCache.get(i)));
        }
        poDigestDataCache.clear();
        if (addDigestClose) {
            samCommands.add(new DigestCloseCmdBuild(((CalypsoSam)this.samResource.getSmartCard()).getSamRevision(), ((CalypsoPo)this.poResource.getSmartCard()).getRevision().equals((Object)PoRevision.REV3_2) ? (byte)8 : 4));
        }
        return samCommands;
    }

    byte[] getTerminalSignature() {
        CardResponse samCardResponse;
        List<AbstractSamCommandBuilder<? extends AbstractSamResponseParser>> samCommands = this.getPendingSamCommands(true);
        CardRequest samCardRequest = new CardRequest(this.getApduRequests(samCommands));
        try {
            samCardResponse = this.samReader.transmitCardRequest(samCardRequest, ChannelControl.KEEP_OPEN);
        }
        catch (KeypleReaderIOException e) {
            throw new CalypsoSamIOException("SAM IO Exception while transmitting digest data.", e);
        }
        List samApduResponses = samCardResponse.getApduResponses();
        if (samApduResponses.size() != samCommands.size()) {
            throw new CalypsoDesynchronizedExchangesException("The number of commands/responses does not match: cmd=" + samCommands.size() + ", resp=" + samApduResponses.size());
        }
        for (int i = 0; i < samApduResponses.size(); ++i) {
            samCommands.get(i).createResponseParser((ApduResponse)samApduResponses.get(i)).checkStatus();
        }
        DigestCloseRespPars digestCloseRespPars = (DigestCloseRespPars)samCommands.get(samCommands.size() - 1).createResponseParser((ApduResponse)samApduResponses.get(samCommands.size() - 1));
        byte[] sessionTerminalSignature = digestCloseRespPars.getSignature();
        if (logger.isDebugEnabled()) {
            logger.debug("SIGNATURE = {}", (Object)ByteArrayUtil.toHex((byte[])sessionTerminalSignature));
        }
        return sessionTerminalSignature;
    }

    void authenticatePoSignature(byte[] poSignatureLo) {
        CardResponse samCardResponse;
        DigestAuthenticateCmdBuild digestAuthenticateCmdBuild = new DigestAuthenticateCmdBuild(((CalypsoSam)this.samResource.getSmartCard()).getSamRevision(), poSignatureLo);
        ArrayList<ApduRequest> samApduRequests = new ArrayList<ApduRequest>();
        samApduRequests.add(digestAuthenticateCmdBuild.getApduRequest());
        CardRequest samCardRequest = new CardRequest(samApduRequests);
        try {
            samCardResponse = this.samReader.transmitCardRequest(samCardRequest, ChannelControl.KEEP_OPEN);
        }
        catch (KeypleReaderIOException e) {
            throw new CalypsoSamIOException("SAM IO Exception while transmitting digest authentication data.", e);
        }
        List samApduResponses = samCardResponse.getApduResponses();
        if (samApduResponses == null || samApduResponses.isEmpty()) {
            throw new CalypsoDesynchronizedExchangesException("No response to Digest Authenticate command.");
        }
        DigestAuthenticateRespPars digestAuthenticateRespPars = digestAuthenticateCmdBuild.createResponseParser((ApduResponse)samApduResponses.get(0));
        digestAuthenticateRespPars.checkStatus();
    }

    private List<ApduRequest> getApduRequests(List<AbstractSamCommandBuilder<? extends AbstractSamResponseParser>> samCommands) {
        ArrayList<ApduRequest> apduRequests = new ArrayList<ApduRequest>();
        if (samCommands != null) {
            for (AbstractSamCommandBuilder<? extends AbstractSamResponseParser> commandBuilder : samCommands) {
                apduRequests.add(commandBuilder.getApduRequest());
            }
        }
        return apduRequests;
    }

    byte[] getCipheredPinData(byte[] poChallenge, byte[] currentPin, byte[] newPin) {
        ArrayList<AbstractSamCommandBuilder<? extends AbstractSamResponseParser>> samCommands = new ArrayList<AbstractSamCommandBuilder<? extends AbstractSamResponseParser>>();
        KeyReference pinCipheringKey = this.workKeyKif != 0 ? new KeyReference(this.workKeyKif, this.workKeyKVC) : this.poSecuritySettings.getDefaultPinCipheringKey();
        if (!this.isDiversificationDone) {
            samCommands.add(new SelectDiversifierCmdBuild(((CalypsoSam)this.samResource.getSmartCard()).getSamRevision(), ((CalypsoPo)this.poResource.getSmartCard()).getApplicationSerialNumberBytes()));
            this.isDiversificationDone = true;
        }
        if (this.isDigesterInitialized) {
            samCommands.addAll(this.getPendingSamCommands(false));
        }
        samCommands.add(new GiveRandomCmdBuild(((CalypsoSam)this.samResource.getSmartCard()).getSamRevision(), poChallenge));
        int cardCipherPinCmdIndex = samCommands.size();
        CardCipherPinCmdBuild cardCipherPinCmdBuild = new CardCipherPinCmdBuild(((CalypsoSam)this.samResource.getSmartCard()).getSamRevision(), pinCipheringKey, currentPin, newPin);
        samCommands.add(cardCipherPinCmdBuild);
        CardRequest samCardRequest = new CardRequest(this.getApduRequests(samCommands));
        CardResponse samCardResponse = this.samReader.transmitCardRequest(samCardRequest, ChannelControl.KEEP_OPEN);
        ApduResponse cardCipherPinResponse = (ApduResponse)samCardResponse.getApduResponses().get(cardCipherPinCmdIndex);
        CardCipherPinRespPars cardCipherPinRespPars = cardCipherPinCmdBuild.createResponseParser(cardCipherPinResponse);
        cardCipherPinRespPars.checkStatus();
        return cardCipherPinRespPars.getCipheredData();
    }

    private byte[] getSvComplementaryData(AbstractSamCommandBuilder<? extends AbstractSamResponseParser> svPrepareCmdBuild) {
        ArrayList<AbstractSamCommandBuilder<? extends AbstractSamResponseParser>> samCommands = new ArrayList<AbstractSamCommandBuilder<? extends AbstractSamResponseParser>>();
        if (!this.isDiversificationDone) {
            samCommands.add(new SelectDiversifierCmdBuild(((CalypsoSam)this.samResource.getSmartCard()).getSamRevision(), ((CalypsoPo)this.poResource.getSmartCard()).getApplicationSerialNumberBytes()));
            this.isDiversificationDone = true;
        }
        if (this.isDigesterInitialized) {
            samCommands.addAll(this.getPendingSamCommands(false));
        }
        int svPrepareOperationCmdIndex = samCommands.size();
        samCommands.add(svPrepareCmdBuild);
        CardRequest samCardRequest = new CardRequest(this.getApduRequests(samCommands));
        CardResponse samCardResponse = this.samReader.transmitCardRequest(samCardRequest, ChannelControl.KEEP_OPEN);
        ApduResponse svPrepareResponse = (ApduResponse)samCardResponse.getApduResponses().get(svPrepareOperationCmdIndex);
        SvPrepareOperationRespPars svPrepareOperationRespPars = (SvPrepareOperationRespPars)svPrepareCmdBuild.createResponseParser(svPrepareResponse);
        svPrepareOperationRespPars.checkStatus();
        byte[] samId = ((CalypsoSam)this.samResource.getSmartCard()).getSerialNumber();
        byte[] prepareOperationData = svPrepareOperationRespPars.getApduResponse().getDataOut();
        byte[] operationComplementaryData = new byte[samId.length + prepareOperationData.length];
        System.arraycopy(samId, 0, operationComplementaryData, 0, samId.length);
        System.arraycopy(prepareOperationData, 0, operationComplementaryData, samId.length, prepareOperationData.length);
        return operationComplementaryData;
    }

    byte[] getSvReloadComplementaryData(SvReloadCmdBuild svReloadCmdBuild, byte[] svGetHeader, byte[] svGetData) {
        SvPrepareLoadCmdBuild svPrepareLoadCmdBuild = new SvPrepareLoadCmdBuild(((CalypsoSam)this.samResource.getSmartCard()).getSamRevision(), svGetHeader, svGetData, svReloadCmdBuild.getSvReloadData());
        return this.getSvComplementaryData(svPrepareLoadCmdBuild);
    }

    byte[] getSvDebitComplementaryData(SvDebitCmdBuild svDebitCmdBuild, byte[] svGetHeader, byte[] svGetData) {
        SvPrepareDebitCmdBuild svPrepareDebitCmdBuild = new SvPrepareDebitCmdBuild(((CalypsoSam)this.samResource.getSmartCard()).getSamRevision(), svGetHeader, svGetData, svDebitCmdBuild.getSvDebitData());
        return this.getSvComplementaryData(svPrepareDebitCmdBuild);
    }

    public byte[] getSvUndebitComplementaryData(SvUndebitCmdBuild svUndebitCmdBuild, byte[] svGetHeader, byte[] svGetData) {
        SvPrepareUndebitCmdBuild svPrepareUndebitCmdBuild = new SvPrepareUndebitCmdBuild(((CalypsoSam)this.samResource.getSmartCard()).getSamRevision(), svGetHeader, svGetData, svUndebitCmdBuild.getSvUndebitData());
        return this.getSvComplementaryData(svPrepareUndebitCmdBuild);
    }

    void checkSvStatus(byte[] svOperationResponseData) {
        ArrayList<AbstractSamCommandBuilder<? extends AbstractSamResponseParser>> samCommands = new ArrayList<AbstractSamCommandBuilder<? extends AbstractSamResponseParser>>();
        SvCheckCmdBuild svCheckCmdBuilder = new SvCheckCmdBuild(((CalypsoSam)this.samResource.getSmartCard()).getSamRevision(), svOperationResponseData);
        samCommands.add(svCheckCmdBuilder);
        CardRequest samCardRequest = new CardRequest(this.getApduRequests(samCommands));
        CardResponse samCardResponse = this.samReader.transmitCardRequest(samCardRequest, ChannelControl.KEEP_OPEN);
        ApduResponse svCheckResponse = (ApduResponse)samCardResponse.getApduResponses().get(0);
        SvCheckRespPars svCheckRespPars = svCheckCmdBuilder.createResponseParser(svCheckResponse);
        svCheckRespPars.checkStatus();
    }
}

