/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.keyple.calypso.SelectFileControl;
import org.eclipse.keyple.calypso.command.po.AbstractPoCommandBuilder;
import org.eclipse.keyple.calypso.command.po.AbstractPoResponseParser;
import org.eclipse.keyple.calypso.command.po.CalypsoPoCommand;
import org.eclipse.keyple.calypso.command.po.PoRevision;
import org.eclipse.keyple.calypso.command.po.builder.AppendRecordCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.DecreaseCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.IncreaseCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.ReadRecordsCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.UpdateRecordCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.WriteRecordCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.security.AbstractOpenSessionCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.security.CloseSessionCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.security.InvalidateCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.security.PoGetChallengeCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.security.RatificationCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.security.RehabilitateCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.security.VerifyPinCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.storedvalue.SvDebitCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.storedvalue.SvGetCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.storedvalue.SvReloadCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.storedvalue.SvUndebitCmdBuild;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoSecurityDataException;
import org.eclipse.keyple.calypso.command.po.parser.security.AbstractOpenSessionRespPars;
import org.eclipse.keyple.calypso.command.po.parser.security.CloseSessionRespPars;
import org.eclipse.keyple.calypso.command.sam.exception.CalypsoSamCommandException;
import org.eclipse.keyple.calypso.transaction.CalypsoPo;
import org.eclipse.keyple.calypso.transaction.CalypsoPoUtils;
import org.eclipse.keyple.calypso.transaction.ElementaryFile;
import org.eclipse.keyple.calypso.transaction.PoCommandManager;
import org.eclipse.keyple.calypso.transaction.PoSecuritySettings;
import org.eclipse.keyple.calypso.transaction.SamCommandProcessor;
import org.eclipse.keyple.calypso.transaction.exception.CalypsoAtomicTransactionException;
import org.eclipse.keyple.calypso.transaction.exception.CalypsoAuthenticationNotVerifiedException;
import org.eclipse.keyple.calypso.transaction.exception.CalypsoDesynchronizedExchangesException;
import org.eclipse.keyple.calypso.transaction.exception.CalypsoPoCloseSecureSessionException;
import org.eclipse.keyple.calypso.transaction.exception.CalypsoPoIOException;
import org.eclipse.keyple.calypso.transaction.exception.CalypsoPoTransactionIllegalStateException;
import org.eclipse.keyple.calypso.transaction.exception.CalypsoSamIOException;
import org.eclipse.keyple.calypso.transaction.exception.CalypsoSessionAuthenticationException;
import org.eclipse.keyple.calypso.transaction.exception.CalypsoUnauthorizedKvcException;
import org.eclipse.keyple.core.card.message.ApduRequest;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.eclipse.keyple.core.card.message.CardRequest;
import org.eclipse.keyple.core.card.message.CardResponse;
import org.eclipse.keyple.core.card.message.ChannelControl;
import org.eclipse.keyple.core.card.message.ProxyReader;
import org.eclipse.keyple.core.card.selection.CardResource;
import org.eclipse.keyple.core.service.exception.KeypleReaderIOException;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.core.util.ByteArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoTransaction {
    private static final int SESSION_BUFFER_CMD_ADDITIONAL_COST = 6;
    private static final int APDU_HEADER_LENGTH = 5;
    private static final Logger logger = LoggerFactory.getLogger(PoTransaction.class);
    private final ProxyReader poReader;
    private PoSecuritySettings poSecuritySettings;
    private SamCommandProcessor samCommandProcessor;
    private final CalypsoPo calypsoPo;
    private SessionState sessionState;
    private SessionSetting.AccessLevel currentAccessLevel;
    private int modificationsCounter;
    private final PoCommandManager poCommandManager;
    private SvSettings.Action svAction;
    private ChannelControl channelControl;
    static final ApduResponse RESPONSE_OK = new ApduResponse(new byte[]{-112, 0}, null);
    static final ApduResponse RESPONSE_OK_POSTPONED = new ApduResponse(new byte[]{98, 0}, null);

    public PoTransaction(CardResource<CalypsoPo> poResource, PoSecuritySettings poSecuritySettings) {
        this(poResource);
        this.poSecuritySettings = poSecuritySettings;
        this.samCommandProcessor = new SamCommandProcessor(poResource, poSecuritySettings);
    }

    public PoTransaction(CardResource<CalypsoPo> poResource) {
        this.poReader = (ProxyReader)poResource.getReader();
        this.calypsoPo = (CalypsoPo)poResource.getSmartCard();
        this.modificationsCounter = this.calypsoPo.getModificationsCounter();
        this.sessionState = SessionState.SESSION_UNINITIALIZED;
        this.poCommandManager = new PoCommandManager();
        this.channelControl = ChannelControl.KEEP_OPEN;
    }

    private void processAtomicOpening(SessionSetting.AccessLevel accessLevel, List<AbstractPoCommandBuilder<? extends AbstractPoResponseParser>> poCommands) {
        AbstractPoCommandBuilder<? extends AbstractPoResponseParser> poCommand;
        this.checkSessionIsNotOpen();
        if (this.poSecuritySettings == null) {
            throw new CalypsoPoTransactionIllegalStateException("No SAM resource is available");
        }
        byte[] sessionTerminalChallenge = this.samCommandProcessor.getSessionTerminalChallenge();
        ArrayList<ApduRequest> poApduRequests = new ArrayList<ApduRequest>();
        int sfi = 0;
        int recordNumber = 0;
        if (poCommands != null && !poCommands.isEmpty() && (poCommand = poCommands.get(0)).getCommandRef() == CalypsoPoCommand.READ_RECORDS && ((ReadRecordsCmdBuild)poCommand).getReadMode() == ReadRecordsCmdBuild.ReadMode.ONE_RECORD) {
            sfi = ((ReadRecordsCmdBuild)poCommand).getSfi();
            recordNumber = ((ReadRecordsCmdBuild)poCommand).getFirstRecordNumber();
            poCommands.remove(0);
        }
        AbstractOpenSessionCmdBuild<AbstractOpenSessionRespPars> openSessionCmdBuild = AbstractOpenSessionCmdBuild.create(this.calypsoPo.getRevision(), accessLevel.getSessionKey(), sessionTerminalChallenge, sfi, recordNumber);
        poApduRequests.add(openSessionCmdBuild.getApduRequest());
        if (poCommands != null) {
            poApduRequests.addAll(this.getApduRequests(poCommands));
        }
        CardRequest poCardRequest = new CardRequest(poApduRequests);
        CardResponse poCardResponse = this.safePoTransmit(poCardRequest, ChannelControl.KEEP_OPEN);
        List poApduResponses = poCardResponse.getApduResponses();
        this.checkCommandsResponsesSynchronization(poApduRequests.size(), poApduResponses.size());
        AbstractOpenSessionRespPars poOpenSessionPars = (AbstractOpenSessionRespPars)CalypsoPoUtils.updateCalypsoPo(this.calypsoPo, openSessionCmdBuild, (ApduResponse)poApduResponses.get(0));
        byte[] sessionCardChallenge = poOpenSessionPars.getPoChallenge();
        byte poKif = poOpenSessionPars.getSelectedKif();
        Byte poKvc = poOpenSessionPars.getSelectedKvc();
        if (logger.isDebugEnabled()) {
            logger.debug("processAtomicOpening => opening: CARDCHALLENGE = {}, POKIF = {}, POKVC = {}", new Object[]{ByteArrayUtil.toHex((byte[])sessionCardChallenge), String.format("%02X", poKif), String.format("%02X", poKvc)});
        }
        if (!this.poSecuritySettings.isSessionKvcAuthorized(poKvc)) {
            throw new CalypsoUnauthorizedKvcException(String.format("PO KVC = %02X", poKvc));
        }
        this.samCommandProcessor.initializeDigester(accessLevel, false, false, poKif, poKvc, ((ApduResponse)poApduResponses.get(0)).getDataOut());
        if (poCommands != null && !poCommands.isEmpty()) {
            this.samCommandProcessor.pushPoExchangeDataList(poApduRequests, poApduResponses, 1);
        }
        poApduResponses.remove(0);
        CalypsoPoUtils.updateCalypsoPo(this.calypsoPo, poCommands, poApduResponses);
        this.sessionState = SessionState.SESSION_OPEN;
    }

    private List<ApduRequest> getApduRequests(List<AbstractPoCommandBuilder<? extends AbstractPoResponseParser>> poCommands) {
        ArrayList<ApduRequest> apduRequests = new ArrayList<ApduRequest>();
        if (poCommands != null) {
            for (AbstractPoCommandBuilder<? extends AbstractPoResponseParser> commandBuilder : poCommands) {
                apduRequests.add(commandBuilder.getApduRequest());
            }
        }
        return apduRequests;
    }

    private void processAtomicPoCommands(List<AbstractPoCommandBuilder<? extends AbstractPoResponseParser>> poCommands, ChannelControl channelControl) {
        List<ApduRequest> poApduRequests = this.getApduRequests(poCommands);
        CardRequest poCardRequest = new CardRequest(poApduRequests);
        CardResponse poCardResponse = this.safePoTransmit(poCardRequest, channelControl);
        List poApduResponses = poCardResponse.getApduResponses();
        this.checkCommandsResponsesSynchronization(poApduRequests.size(), poApduResponses.size());
        if (this.sessionState == SessionState.SESSION_OPEN) {
            this.samCommandProcessor.pushPoExchangeDataList(poApduRequests, poApduResponses, 0);
        }
        CalypsoPoUtils.updateCalypsoPo(this.calypsoPo, poCommands, poCardResponse.getApduResponses());
    }

    private void processAtomicClosing(List<AbstractPoCommandBuilder<? extends AbstractPoResponseParser>> poModificationCommands, List<ApduResponse> poAnticipatedResponses, SessionSetting.RatificationMode ratificationMode, ChannelControl channelControl) {
        CloseSessionRespPars poCloseSessionPars;
        boolean ratificationCommandResponseReceived;
        CardResponse poCardResponse;
        boolean ratificationCommandAdded;
        this.checkSessionIsOpen();
        List<ApduRequest> poApduRequests = this.getApduRequests(poModificationCommands);
        if (poModificationCommands != null && !poApduRequests.isEmpty()) {
            this.checkCommandsResponsesSynchronization(poApduRequests.size(), poAnticipatedResponses.size());
            this.samCommandProcessor.pushPoExchangeDataList(poApduRequests, poAnticipatedResponses, 0);
        }
        byte[] sessionTerminalSignature = this.samCommandProcessor.getTerminalSignature();
        CloseSessionCmdBuild closeSessionCmdBuild = new CloseSessionCmdBuild(this.calypsoPo.getPoClass(), SessionSetting.RatificationMode.CLOSE_RATIFIED.equals((Object)ratificationMode), sessionTerminalSignature);
        poApduRequests.add(closeSessionCmdBuild.getApduRequest());
        int closeCommandIndex = poApduRequests.size() - 1;
        if (SessionSetting.RatificationMode.CLOSE_RATIFIED.equals((Object)ratificationMode) && this.poReader.isContactless()) {
            poApduRequests.add(RatificationCmdBuild.getApduRequest(this.calypsoPo.getPoClass()));
            ratificationCommandAdded = true;
        } else {
            ratificationCommandAdded = false;
        }
        CardRequest poCardRequest = new CardRequest(poApduRequests);
        try {
            poCardResponse = this.poReader.transmitCardRequest(poCardRequest, channelControl);
            ratificationCommandResponseReceived = ratificationCommandAdded;
        }
        catch (KeypleReaderIOException ex) {
            poCardResponse = ex.getCardResponse();
            if (!ratificationCommandAdded || poCardResponse == null || poCardResponse.getApduResponses().size() != poApduRequests.size() - 1) {
                throw new CalypsoPoIOException("PO IO Exception while transmitting commands.", ex);
            }
            ratificationCommandResponseReceived = false;
        }
        List poApduResponses = poCardResponse.getApduResponses();
        CalypsoPoUtils.updateCalypsoPo(this.calypsoPo, poModificationCommands, poApduResponses);
        try {
            poCloseSessionPars = (CloseSessionRespPars)CalypsoPoUtils.updateCalypsoPo(this.calypsoPo, closeSessionCmdBuild, (ApduResponse)poApduResponses.get(closeCommandIndex));
        }
        catch (CalypsoPoSecurityDataException ex) {
            throw new CalypsoPoCloseSecureSessionException("Invalid PO session", ex);
        }
        try {
            this.samCommandProcessor.authenticatePoSignature(poCloseSessionPars.getSignatureLo());
        }
        catch (CalypsoSamIOException ex) {
            throw new CalypsoAuthenticationNotVerifiedException(ex.getMessage());
        }
        catch (CalypsoSamCommandException ex) {
            throw new CalypsoSessionAuthenticationException("PO authentication failed on SAM side.", (Throwable)((Object)ex));
        }
        if (this.poCommandManager.isSvOperationCompleteOneTime()) {
            this.samCommandProcessor.checkSvStatus(poCloseSessionPars.getPostponedData());
        }
        this.sessionState = SessionState.SESSION_CLOSED;
        if (ratificationCommandResponseReceived) {
            poApduResponses.remove(poApduResponses.size() - 1);
        }
        poApduResponses.remove(poApduResponses.size() - 1);
    }

    private void processAtomicClosing(List<AbstractPoCommandBuilder<? extends AbstractPoResponseParser>> poCommands, SessionSetting.RatificationMode ratificationMode, ChannelControl channelControl) {
        List<ApduResponse> poAnticipatedResponses = this.getAnticipatedResponses(poCommands);
        this.processAtomicClosing(poCommands, poAnticipatedResponses, ratificationMode, channelControl);
    }

    private int getCounterValue(int sfi, int counter) {
        try {
            ElementaryFile ef = this.calypsoPo.getFileBySfi((byte)sfi);
            return ef.getData().getContentAsCounterValue(counter);
        }
        catch (NoSuchElementException e) {
            throw new CalypsoPoTransactionIllegalStateException("Anticipated response. Unable to determine anticipated value of counter " + counter + " in EF sfi " + sfi);
        }
    }

    private ApduResponse createIncreaseDecreaseResponse(int newCounterValue) {
        byte[] response = new byte[]{(byte)((newCounterValue & 0xFF0000) >> 16), (byte)((newCounterValue & 0xFF00) >> 8), (byte)(newCounterValue & 0xFF), -112, 0};
        return new ApduResponse(response, null);
    }

    private List<ApduResponse> getAnticipatedResponses(List<AbstractPoCommandBuilder<? extends AbstractPoResponseParser>> poCommands) {
        ArrayList<ApduResponse> apduResponses = new ArrayList<ApduResponse>();
        if (poCommands != null) {
            for (AbstractPoCommandBuilder<? extends AbstractPoResponseParser> commandBuilder : poCommands) {
                int newCounterValue;
                int counter;
                int sfi;
                if (commandBuilder.getCommandRef() == CalypsoPoCommand.DECREASE) {
                    sfi = ((DecreaseCmdBuild)commandBuilder).getSfi();
                    counter = ((DecreaseCmdBuild)commandBuilder).getCounterNumber();
                    newCounterValue = this.getCounterValue(sfi, counter) - ((DecreaseCmdBuild)commandBuilder).getDecValue();
                    apduResponses.add(this.createIncreaseDecreaseResponse(newCounterValue));
                    continue;
                }
                if (commandBuilder.getCommandRef() == CalypsoPoCommand.INCREASE) {
                    sfi = ((IncreaseCmdBuild)commandBuilder).getSfi();
                    counter = ((IncreaseCmdBuild)commandBuilder).getCounterNumber();
                    newCounterValue = this.getCounterValue(sfi, counter) + ((IncreaseCmdBuild)commandBuilder).getIncValue();
                    apduResponses.add(this.createIncreaseDecreaseResponse(newCounterValue));
                    continue;
                }
                if (commandBuilder.getCommandRef() == CalypsoPoCommand.SV_RELOAD || commandBuilder.getCommandRef() == CalypsoPoCommand.SV_DEBIT || commandBuilder.getCommandRef() == CalypsoPoCommand.SV_UNDEBIT) {
                    apduResponses.add(RESPONSE_OK_POSTPONED);
                    continue;
                }
                apduResponses.add(RESPONSE_OK);
            }
        }
        return apduResponses;
    }

    public final void processOpening(SessionSetting.AccessLevel accessLevel) {
        this.currentAccessLevel = accessLevel;
        ArrayList<AbstractPoCommandBuilder<? extends AbstractPoResponseParser>> poAtomicCommands = new ArrayList<AbstractPoCommandBuilder<? extends AbstractPoResponseParser>>();
        AtomicInteger neededSessionBufferSpace = new AtomicInteger();
        AtomicBoolean overflow = new AtomicBoolean();
        for (AbstractPoCommandBuilder<? extends AbstractPoResponseParser> commandBuilder : this.poCommandManager.getPoCommandBuilders()) {
            if (this.checkModifyingCommand(commandBuilder, overflow, neededSessionBufferSpace)) {
                if (overflow.get()) {
                    this.processAtomicOpening(this.currentAccessLevel, poAtomicCommands);
                    this.processAtomicClosing(null, SessionSetting.RatificationMode.CLOSE_RATIFIED, ChannelControl.KEEP_OPEN);
                    this.resetModificationsBufferCounter();
                    poAtomicCommands.clear();
                    poAtomicCommands.add(commandBuilder);
                    this.isSessionBufferOverflowed(neededSessionBufferSpace.get());
                    continue;
                }
                poAtomicCommands.add(commandBuilder);
                continue;
            }
            poAtomicCommands.add(commandBuilder);
        }
        this.processAtomicOpening(this.currentAccessLevel, poAtomicCommands);
        this.poCommandManager.notifyCommandsProcessed();
    }

    private void processPoCommandsOutOfSession(ChannelControl channelControl) {
        this.processAtomicPoCommands(this.poCommandManager.getPoCommandBuilders(), channelControl);
        this.poCommandManager.notifyCommandsProcessed();
        if (this.poCommandManager.isSvOperationCompleteOneTime()) {
            this.samCommandProcessor.checkSvStatus(CalypsoPoUtils.getSvOperationSignature());
        }
    }

    private void processPoCommandsInSession() {
        ArrayList<AbstractPoCommandBuilder<? extends AbstractPoResponseParser>> poAtomicBuilders = new ArrayList<AbstractPoCommandBuilder<? extends AbstractPoResponseParser>>();
        AtomicInteger neededSessionBufferSpace = new AtomicInteger();
        AtomicBoolean overflow = new AtomicBoolean();
        for (AbstractPoCommandBuilder<? extends AbstractPoResponseParser> commandBuilder : this.poCommandManager.getPoCommandBuilders()) {
            if (this.checkModifyingCommand(commandBuilder, overflow, neededSessionBufferSpace)) {
                if (overflow.get()) {
                    this.processAtomicPoCommands(poAtomicBuilders, ChannelControl.KEEP_OPEN);
                    this.processAtomicClosing(null, SessionSetting.RatificationMode.CLOSE_RATIFIED, ChannelControl.KEEP_OPEN);
                    this.resetModificationsBufferCounter();
                    this.processAtomicOpening(this.currentAccessLevel, null);
                    poAtomicBuilders.clear();
                    poAtomicBuilders.add(commandBuilder);
                    this.isSessionBufferOverflowed(neededSessionBufferSpace.get());
                    continue;
                }
                poAtomicBuilders.add(commandBuilder);
                continue;
            }
            poAtomicBuilders.add(commandBuilder);
        }
        if (!poAtomicBuilders.isEmpty()) {
            this.processAtomicPoCommands(poAtomicBuilders, ChannelControl.KEEP_OPEN);
        }
        this.poCommandManager.notifyCommandsProcessed();
    }

    public final void processPoCommands() {
        if (this.sessionState == SessionState.SESSION_OPEN) {
            this.processPoCommandsInSession();
        } else {
            this.processPoCommandsOutOfSession(this.channelControl);
        }
    }

    public final void processClosing() {
        this.checkSessionIsOpen();
        boolean atLeastOneReadCommand = false;
        boolean sessionPreviouslyClosed = false;
        AtomicInteger neededSessionBufferSpace = new AtomicInteger();
        AtomicBoolean overflow = new AtomicBoolean();
        ArrayList<AbstractPoCommandBuilder<? extends AbstractPoResponseParser>> poAtomicCommands = new ArrayList<AbstractPoCommandBuilder<? extends AbstractPoResponseParser>>();
        for (AbstractPoCommandBuilder<? extends AbstractPoResponseParser> commandBuilder : this.poCommandManager.getPoCommandBuilders()) {
            if (this.checkModifyingCommand(commandBuilder, overflow, neededSessionBufferSpace)) {
                if (overflow.get()) {
                    if (sessionPreviouslyClosed) {
                        this.processAtomicOpening(this.currentAccessLevel, null);
                    }
                    if (atLeastOneReadCommand) {
                        this.processAtomicPoCommands(poAtomicCommands, ChannelControl.KEEP_OPEN);
                        poAtomicCommands.clear();
                        this.processAtomicClosing(poAtomicCommands, SessionSetting.RatificationMode.CLOSE_RATIFIED, ChannelControl.KEEP_OPEN);
                        this.resetModificationsBufferCounter();
                        sessionPreviouslyClosed = true;
                        atLeastOneReadCommand = false;
                    } else {
                        this.processAtomicClosing(poAtomicCommands, SessionSetting.RatificationMode.CLOSE_RATIFIED, ChannelControl.KEEP_OPEN);
                        poAtomicCommands.clear();
                        this.resetModificationsBufferCounter();
                        sessionPreviouslyClosed = true;
                    }
                    poAtomicCommands.add(commandBuilder);
                    this.isSessionBufferOverflowed(neededSessionBufferSpace.get());
                    continue;
                }
                poAtomicCommands.add(commandBuilder);
                continue;
            }
            poAtomicCommands.add(commandBuilder);
            atLeastOneReadCommand = true;
        }
        if (sessionPreviouslyClosed) {
            this.processAtomicOpening(this.currentAccessLevel, null);
        }
        this.processAtomicClosing(poAtomicCommands, this.poSecuritySettings.getRatificationMode(), this.channelControl);
        this.poCommandManager.notifyCommandsProcessed();
    }

    public final void processCancel() {
        ArrayList<ApduRequest> poApduRequests = new ArrayList<ApduRequest>();
        CloseSessionCmdBuild closeSessionCmdBuild = new CloseSessionCmdBuild(this.calypsoPo.getPoClass());
        poApduRequests.add(closeSessionCmdBuild.getApduRequest());
        CardRequest poCardRequest = new CardRequest(poApduRequests);
        CardResponse poCardResponse = this.safePoTransmit(poCardRequest, this.channelControl);
        closeSessionCmdBuild.createResponseParser((ApduResponse)poCardResponse.getApduResponses().get(0)).checkStatus();
        this.poCommandManager.notifyCommandsProcessed();
        this.sessionState = SessionState.SESSION_CLOSED;
    }

    public final void processVerifyPin(byte[] pin) {
        Assert.getInstance().notNull((Object)pin, "pin").isEqual(Integer.valueOf(pin.length), 4, "PIN length");
        if (!this.calypsoPo.isPinFeatureAvailable()) {
            throw new CalypsoPoTransactionIllegalStateException("PIN is not available for this PO.");
        }
        if (this.poCommandManager.hasCommands()) {
            throw new CalypsoPoTransactionIllegalStateException("No commands should have been prepared prior to a PIN submission.");
        }
        if (this.poSecuritySettings != null && PinTransmissionMode.ENCRYPTED.equals((Object)this.poSecuritySettings.getPinTransmissionMode())) {
            this.poCommandManager.addRegularCommand(new PoGetChallengeCmdBuild(this.calypsoPo.getPoClass()));
            this.processAtomicPoCommands(this.poCommandManager.getPoCommandBuilders(), ChannelControl.KEEP_OPEN);
            this.poCommandManager.notifyCommandsProcessed();
            byte[] cipheredPin = this.samCommandProcessor.getCipheredPinData(CalypsoPoUtils.getPoChallenge(), pin, null);
            this.poCommandManager.addRegularCommand(new VerifyPinCmdBuild(this.calypsoPo.getPoClass(), PinTransmissionMode.ENCRYPTED, cipheredPin));
        } else {
            this.poCommandManager.addRegularCommand(new VerifyPinCmdBuild(this.calypsoPo.getPoClass(), PinTransmissionMode.PLAIN, pin));
        }
        this.processAtomicPoCommands(this.poCommandManager.getPoCommandBuilders(), this.channelControl);
        this.poCommandManager.notifyCommandsProcessed();
    }

    public final void processVerifyPin(String pin) {
        this.processVerifyPin(pin.getBytes());
    }

    private CardResponse safePoTransmit(CardRequest poCardRequest, ChannelControl channelControl) {
        try {
            return this.poReader.transmitCardRequest(poCardRequest, channelControl);
        }
        catch (KeypleReaderIOException e) {
            throw new CalypsoPoIOException("PO IO Exception while transmitting commands.", e);
        }
    }

    private void checkSessionIsOpen() {
        if (this.sessionState != SessionState.SESSION_OPEN) {
            throw new CalypsoPoTransactionIllegalStateException("Bad session state. Current: " + (Object)((Object)this.sessionState) + ", expected: " + (Object)((Object)SessionState.SESSION_OPEN));
        }
    }

    private void checkSessionIsNotOpen() {
        if (this.sessionState == SessionState.SESSION_OPEN) {
            throw new CalypsoPoTransactionIllegalStateException("Bad session state. Current: " + (Object)((Object)this.sessionState) + ", expected: not open");
        }
    }

    private void checkCommandsResponsesSynchronization(int commandsNumber, int responsesNumber) {
        if (commandsNumber != responsesNumber) {
            throw new CalypsoDesynchronizedExchangesException("The number of commands/responses does not match: cmd=" + commandsNumber + ", resp=" + responsesNumber);
        }
    }

    private boolean checkModifyingCommand(AbstractPoCommandBuilder<? extends AbstractPoResponseParser> builder, AtomicBoolean overflow, AtomicInteger neededSessionBufferSpace) {
        if (builder.isSessionBufferUsed()) {
            neededSessionBufferSpace.set(builder.getApduRequest().getBytes().length + 6 - 5);
            if (this.isSessionBufferOverflowed(neededSessionBufferSpace.get())) {
                if (this.poSecuritySettings.getSessionModificationMode() == SessionSetting.ModificationMode.ATOMIC) {
                    throw new CalypsoAtomicTransactionException("ATOMIC mode error! This command would overflow the PO modifications buffer: " + builder.getName());
                }
                overflow.set(true);
            } else {
                overflow.set(false);
            }
            return true;
        }
        return false;
    }

    private boolean isSessionBufferOverflowed(int sessionBufferSizeConsumed) {
        boolean isSessionBufferFull = false;
        if (this.calypsoPo.isModificationsCounterInBytes()) {
            if (this.modificationsCounter - sessionBufferSizeConsumed >= 0) {
                this.modificationsCounter -= sessionBufferSizeConsumed;
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Modifications buffer overflow! BYTESMODE, CURRENTCOUNTER = {}, REQUIREMENT = {}", (Object)this.modificationsCounter, (Object)sessionBufferSizeConsumed);
                }
                isSessionBufferFull = true;
            }
        } else if (this.modificationsCounter > 0) {
            --this.modificationsCounter;
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Modifications buffer overflow! COMMANDSMODE, CURRENTCOUNTER = {}, REQUIREMENT = {}", (Object)this.modificationsCounter, (Object)1);
            }
            isSessionBufferFull = true;
        }
        return isSessionBufferFull;
    }

    private void resetModificationsBufferCounter() {
        if (logger.isTraceEnabled()) {
            logger.trace("Modifications buffer counter reset: PREVIOUSVALUE = {}, NEWVALUE = {}", (Object)this.modificationsCounter, (Object)this.calypsoPo.getModificationsCounter());
        }
        this.modificationsCounter = this.calypsoPo.getModificationsCounter();
    }

    public final void prepareReleasePoChannel() {
        this.channelControl = ChannelControl.CLOSE_AFTER;
    }

    public final void prepareSelectFile(byte[] lid) {
        this.poCommandManager.addRegularCommand(CalypsoPoUtils.prepareSelectFile(this.calypsoPo.getPoClass(), lid));
    }

    public final void prepareSelectFile(SelectFileControl control) {
        this.poCommandManager.addRegularCommand(CalypsoPoUtils.prepareSelectFile(this.calypsoPo.getPoClass(), control));
    }

    public final void prepareReadRecordFile(byte sfi, int recordNumber) {
        this.poCommandManager.addRegularCommand(CalypsoPoUtils.prepareReadRecordFile(this.calypsoPo.getPoClass(), sfi, recordNumber));
    }

    public final void prepareReadRecordFile(byte sfi, int firstRecordNumber, int numberOfRecords, int recordSize) {
        Assert.getInstance().isInRange(Integer.valueOf(sfi), 0, 31, "sfi").isInRange(Integer.valueOf(firstRecordNumber), 1, 255, "firstRecordNumber").isInRange(Integer.valueOf(numberOfRecords), 1, 255 - firstRecordNumber, "numberOfRecords");
        if (numberOfRecords == 1) {
            this.poCommandManager.addRegularCommand(new ReadRecordsCmdBuild(this.calypsoPo.getPoClass(), sfi, firstRecordNumber, ReadRecordsCmdBuild.ReadMode.ONE_RECORD, recordSize));
        } else {
            int recordsPerApdu = this.calypsoPo.getPayloadCapacity() / (recordSize + 2);
            int maxSizeDataPerApdu = recordsPerApdu * (recordSize + 2);
            int remainingRecords = numberOfRecords;
            int startRecordNumber = firstRecordNumber;
            while (remainingRecords > 0) {
                int expectedLength;
                if (remainingRecords > recordsPerApdu) {
                    expectedLength = maxSizeDataPerApdu;
                    remainingRecords -= recordsPerApdu;
                    startRecordNumber += recordsPerApdu;
                } else {
                    expectedLength = remainingRecords * (recordSize + 2);
                    remainingRecords = 0;
                }
                this.poCommandManager.addRegularCommand(new ReadRecordsCmdBuild(this.calypsoPo.getPoClass(), sfi, startRecordNumber, ReadRecordsCmdBuild.ReadMode.MULTIPLE_RECORD, expectedLength));
            }
        }
    }

    public final void prepareReadCounterFile(byte sfi, int countersNumber) {
        this.prepareReadRecordFile(sfi, 1, 1, countersNumber * 3);
    }

    public final void prepareAppendRecord(byte sfi, byte[] recordData) {
        Assert.getInstance().isInRange(Integer.valueOf(sfi), 0, 31, "sfi");
        this.poCommandManager.addRegularCommand(new AppendRecordCmdBuild(this.calypsoPo.getPoClass(), sfi, recordData));
    }

    public final void prepareUpdateRecord(byte sfi, int recordNumber, byte[] recordData) {
        Assert.getInstance().isInRange(Integer.valueOf(sfi), 0, 31, "sfi").isInRange(Integer.valueOf(recordNumber), 1, 255, "recordNumber");
        this.poCommandManager.addRegularCommand(new UpdateRecordCmdBuild(this.calypsoPo.getPoClass(), sfi, recordNumber, recordData));
    }

    public final void prepareWriteRecord(byte sfi, int recordNumber, byte[] recordData) {
        Assert.getInstance().isInRange(Integer.valueOf(sfi), 0, 31, "sfi").isInRange(Integer.valueOf(recordNumber), 1, 255, "recordNumber");
        this.poCommandManager.addRegularCommand(new WriteRecordCmdBuild(this.calypsoPo.getPoClass(), sfi, recordNumber, recordData));
    }

    public final void prepareIncreaseCounter(byte sfi, int counterNumber, int incValue) {
        Assert.getInstance().isInRange(Integer.valueOf(sfi), 0, 31, "sfi").isInRange(Integer.valueOf(counterNumber), 1, 255, "counterNumber").isInRange(Integer.valueOf(incValue), 0, 0xFFFFFF, "incValue");
        this.poCommandManager.addRegularCommand(new IncreaseCmdBuild(this.calypsoPo.getPoClass(), sfi, counterNumber, incValue));
    }

    public final void prepareDecreaseCounter(byte sfi, int counterNumber, int decValue) {
        Assert.getInstance().isInRange(Integer.valueOf(sfi), 0, 31, "sfi").isInRange(Integer.valueOf(counterNumber), 1, 255, "counterNumber").isInRange(Integer.valueOf(decValue), 0, 0xFFFFFF, "decValue");
        this.poCommandManager.addRegularCommand(new DecreaseCmdBuild(this.calypsoPo.getPoClass(), sfi, counterNumber, decValue));
    }

    public final void prepareSetCounter(byte sfi, int counterNumber, int newValue) {
        int delta = 0;
        try {
            delta = newValue - this.calypsoPo.getFileBySfi(sfi).getData().getContentAsCounterValue(counterNumber);
        }
        catch (NoSuchElementException ex) {
            throw new CalypsoPoTransactionIllegalStateException("The value for counter " + counterNumber + " in file " + sfi + " is not available");
        }
        if (delta > 0) {
            if (logger.isTraceEnabled()) {
                logger.trace("Increment counter {} (file {}) from {} to {}", new Object[]{counterNumber, sfi, newValue - delta, newValue});
            }
            this.prepareIncreaseCounter(sfi, counterNumber, delta);
        } else if (delta < 0) {
            if (logger.isTraceEnabled()) {
                logger.trace("Decrement counter {} (file {}) from {} to {}", new Object[]{counterNumber, sfi, newValue - delta, newValue});
            }
            this.prepareDecreaseCounter(sfi, counterNumber, -delta);
        } else {
            logger.info("The counter {} (SFI {}) is already set to the desired value {}.", new Object[]{counterNumber, sfi, newValue});
        }
    }

    public final void prepareCheckPinStatus() {
        if (!this.calypsoPo.isPinFeatureAvailable()) {
            throw new CalypsoPoTransactionIllegalStateException("PIN is not available for this PO.");
        }
        this.poCommandManager.addRegularCommand(new VerifyPinCmdBuild(this.calypsoPo.getPoClass()));
    }

    public final void prepareSvGet(SvSettings.Operation svOperation, SvSettings.Action svAction) {
        if (!this.calypsoPo.isSvFeatureAvailable()) {
            throw new CalypsoPoTransactionIllegalStateException("Stored Value is not available for this PO.");
        }
        if (SvSettings.LogRead.ALL.equals((Object)this.poSecuritySettings.getSvGetLogReadMode()) && this.calypsoPo.getRevision() != PoRevision.REV3_2) {
            SvSettings.Operation operation1 = SvSettings.Operation.RELOAD.equals((Object)svOperation) ? SvSettings.Operation.DEBIT : SvSettings.Operation.RELOAD;
            this.poCommandManager.addStoredValueCommand(new SvGetCmdBuild(this.calypsoPo.getPoClass(), this.calypsoPo.getRevision(), operation1), operation1);
        }
        this.poCommandManager.addStoredValueCommand(new SvGetCmdBuild(this.calypsoPo.getPoClass(), this.calypsoPo.getRevision(), svOperation), svOperation);
        this.svAction = svAction;
    }

    public final void prepareSvReload(int amount, byte[] date, byte[] time, byte[] free) {
        SvReloadCmdBuild svReloadCmdBuild = new SvReloadCmdBuild(this.calypsoPo.getPoClass(), this.calypsoPo.getRevision(), amount, CalypsoPoUtils.getSvKvc(), date, time, free);
        byte[] svReloadComplementaryData = this.samCommandProcessor.getSvReloadComplementaryData(svReloadCmdBuild, CalypsoPoUtils.getSvGetHeader(), CalypsoPoUtils.getSvGetData());
        svReloadCmdBuild.finalizeBuilder(svReloadComplementaryData);
        this.poCommandManager.addStoredValueCommand(svReloadCmdBuild, SvSettings.Operation.RELOAD);
    }

    public final void prepareSvReload(int amount) {
        byte[] zero = new byte[]{0, 0};
        this.prepareSvReload(amount, zero, zero, zero);
    }

    private void prepareSvDebitPriv(int amount, byte[] date, byte[] time) {
        if (SvSettings.NegativeBalance.FORBIDDEN.equals((Object)this.poSecuritySettings.getSvNegativeBalance()) && this.calypsoPo.getSvBalance() - amount < 0) {
            throw new CalypsoPoTransactionIllegalStateException("Negative balances not allowed.");
        }
        SvDebitCmdBuild svDebitCmdBuild = new SvDebitCmdBuild(this.calypsoPo.getPoClass(), this.calypsoPo.getRevision(), amount, CalypsoPoUtils.getSvKvc(), date, time);
        byte[] svDebitComplementaryData = this.samCommandProcessor.getSvDebitComplementaryData(svDebitCmdBuild, CalypsoPoUtils.getSvGetHeader(), CalypsoPoUtils.getSvGetData());
        svDebitCmdBuild.finalizeBuilder(svDebitComplementaryData);
        this.poCommandManager.addStoredValueCommand(svDebitCmdBuild, SvSettings.Operation.DEBIT);
    }

    private void prepareSvUndebitPriv(int amount, byte[] date, byte[] time) {
        SvUndebitCmdBuild svUndebitCmdBuild = new SvUndebitCmdBuild(this.calypsoPo.getPoClass(), this.calypsoPo.getRevision(), amount, CalypsoPoUtils.getSvKvc(), date, time);
        byte[] svDebitComplementaryData = this.samCommandProcessor.getSvUndebitComplementaryData(svUndebitCmdBuild, CalypsoPoUtils.getSvGetHeader(), CalypsoPoUtils.getSvGetData());
        svUndebitCmdBuild.finalizeBuilder(svDebitComplementaryData);
        this.poCommandManager.addStoredValueCommand(svUndebitCmdBuild, SvSettings.Operation.DEBIT);
    }

    public final void prepareSvDebit(int amount, byte[] date, byte[] time) {
        if (SvSettings.Action.DO.equals((Object)this.svAction)) {
            this.prepareSvDebitPriv(amount, date, time);
        } else {
            this.prepareSvUndebitPriv(amount, date, time);
        }
    }

    public final void prepareSvDebit(int amount) {
        byte[] zero = new byte[]{0, 0};
        this.prepareSvDebit(amount, zero, zero);
    }

    public final void prepareSvReadAllLogs() {
        if (this.calypsoPo.getApplicationSubtype() != 32) {
            throw new CalypsoPoTransactionIllegalStateException("The currently selected application is not an SV application.");
        }
        this.calypsoPo.setSvData(0, 0, null, null);
        this.prepareReadRecordFile((byte)20, 1);
        this.prepareReadRecordFile((byte)21, 1, 3, 29);
    }

    public final void prepareInvalidate() {
        if (this.calypsoPo.isDfInvalidated()) {
            throw new CalypsoPoTransactionIllegalStateException("This PO is already invalidated.");
        }
        this.poCommandManager.addRegularCommand(new InvalidateCmdBuild(this.calypsoPo.getPoClass()));
    }

    public final void prepareRehabilitate() {
        if (!this.calypsoPo.isDfInvalidated()) {
            throw new CalypsoPoTransactionIllegalStateException("This PO is not invalidated.");
        }
        this.poCommandManager.addRegularCommand(new RehabilitateCmdBuild(this.calypsoPo.getPoClass()));
    }

    public static class SvSettings {

        public static enum NegativeBalance {
            FORBIDDEN,
            AUTHORIZED;

        }

        public static enum LogRead {
            SINGLE,
            ALL;

        }

        public static enum Action {
            DO,
            UNDO;

        }

        public static enum Operation {
            RELOAD,
            DEBIT;

        }
    }

    public static enum PinTransmissionMode {
        PLAIN,
        ENCRYPTED;

    }

    private static enum SessionState {
        SESSION_UNINITIALIZED,
        SESSION_OPEN,
        SESSION_CLOSED;

    }

    public static class SessionSetting {

        public static enum RatificationMode {
            CLOSE_RATIFIED,
            CLOSE_NOT_RATIFIED;

        }

        public static enum AccessLevel {
            SESSION_LVL_PERSO("perso", 1),
            SESSION_LVL_LOAD("load", 2),
            SESSION_LVL_DEBIT("debit", 3);

            private final String name;
            private final byte sessionKey;

            private AccessLevel(String name, byte sessionKey) {
                this.name = name;
                this.sessionKey = sessionKey;
            }

            public String getName() {
                return this.name;
            }

            public byte getSessionKey() {
                return this.sessionKey;
            }
        }

        public static enum ModificationMode {
            ATOMIC,
            MULTIPLE;

        }
    }
}

