/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction;

import java.util.List;
import org.eclipse.keyple.calypso.SelectFileControl;
import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.AbstractPoCommandBuilder;
import org.eclipse.keyple.calypso.command.po.AbstractPoResponseParser;
import org.eclipse.keyple.calypso.transaction.CalypsoPo;
import org.eclipse.keyple.calypso.transaction.CalypsoPoUtils;
import org.eclipse.keyple.calypso.transaction.PoSelector;
import org.eclipse.keyple.calypso.transaction.exception.CalypsoDesynchronizedExchangesException;
import org.eclipse.keyple.core.card.command.AbstractApduCommandBuilder;
import org.eclipse.keyple.core.card.message.CardSelectionResponse;
import org.eclipse.keyple.core.card.selection.AbstractCardSelection;
import org.eclipse.keyple.core.card.selection.CardSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoSelection
extends AbstractCardSelection<AbstractPoCommandBuilder<? extends AbstractPoResponseParser>> {
    private static final Logger logger = LoggerFactory.getLogger(PoSelection.class);
    private final PoClass poClass;

    public PoSelection(PoSelector poSelector) {
        super((CardSelector)poSelector);
        this.poClass = this.cardSelector.getAidSelector() == null ? PoClass.LEGACY : PoClass.ISO;
        if (logger.isTraceEnabled()) {
            logger.trace("Calypso {} selector", (Object)this.poClass);
        }
    }

    public final void prepareReadRecordFile(byte sfi, int recordNumber) {
        this.addCommandBuilder((AbstractApduCommandBuilder)CalypsoPoUtils.prepareReadRecordFile(this.poClass, sfi, recordNumber));
    }

    public void prepareSelectFile(byte[] lid) {
        this.addCommandBuilder((AbstractApduCommandBuilder)CalypsoPoUtils.prepareSelectFile(this.poClass, lid));
    }

    public void prepareSelectFile(short lid) {
        byte[] bLid = new byte[]{(byte)(lid >> 8 & 0xFF), (byte)(lid & 0xFF)};
        this.prepareSelectFile(bLid);
    }

    public void prepareSelectFile(SelectFileControl selectControl) {
        this.addCommandBuilder((AbstractApduCommandBuilder)CalypsoPoUtils.prepareSelectFile(this.poClass, selectControl));
    }

    protected CalypsoPo parse(CardSelectionResponse cardSelectionResponse) {
        List commandBuilders = this.getCommandBuilders();
        List apduResponses = cardSelectionResponse.getCardResponse().getApduResponses();
        if (commandBuilders.size() != apduResponses.size()) {
            throw new CalypsoDesynchronizedExchangesException("Mismatch in the number of requests/responses");
        }
        CalypsoPo calypsoPo = new CalypsoPo(cardSelectionResponse);
        if (!commandBuilders.isEmpty()) {
            CalypsoPoUtils.updateCalypsoPo(calypsoPo, commandBuilders, apduResponses);
        }
        return calypsoPo;
    }
}

