/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction;

import java.util.EnumMap;
import java.util.List;
import org.eclipse.keyple.calypso.KeyReference;
import org.eclipse.keyple.calypso.transaction.CalypsoSam;
import org.eclipse.keyple.calypso.transaction.PoTransaction;
import org.eclipse.keyple.core.card.selection.CardResource;

public class PoSecuritySettings {
    private final CardResource<CalypsoSam> samResource;
    private final List<Byte> authorizedKvcList;
    private final EnumMap<PoTransaction.SessionSetting.AccessLevel, Byte> defaultKif;
    private final EnumMap<PoTransaction.SessionSetting.AccessLevel, Byte> defaultKvc;
    private final EnumMap<PoTransaction.SessionSetting.AccessLevel, Byte> defaultKeyRecordNumber;
    private final PoTransaction.SessionSetting.ModificationMode sessionModificationMode;
    private final PoTransaction.SessionSetting.RatificationMode ratificationMode;
    private final PoTransaction.PinTransmissionMode pinTransmissionMode;
    private final KeyReference defaultPinCipheringKey;
    private final PoTransaction.SvSettings.LogRead svGetLogReadMode;
    private final PoTransaction.SvSettings.NegativeBalance svNegativeBalance;
    public static final PoTransaction.SessionSetting.ModificationMode defaultSessionModificationMode = PoTransaction.SessionSetting.ModificationMode.ATOMIC;
    public static final PoTransaction.SessionSetting.RatificationMode defaultRatificationMode = PoTransaction.SessionSetting.RatificationMode.CLOSE_RATIFIED;
    public static final PoTransaction.PinTransmissionMode defaultPinTransmissionMode = PoTransaction.PinTransmissionMode.ENCRYPTED;
    private static final KeyReference nullPinCipheringKey = new KeyReference(0, 0);
    private static final PoTransaction.SvSettings.LogRead defaultSvGetLogReadMode = PoTransaction.SvSettings.LogRead.SINGLE;
    private static final PoTransaction.SvSettings.NegativeBalance defaultSvNegativeBalance = PoTransaction.SvSettings.NegativeBalance.FORBIDDEN;

    private PoSecuritySettings(PoSecuritySettingsBuilder builder) {
        this.samResource = builder.samResource;
        this.authorizedKvcList = builder.authorizedKvcList;
        this.defaultKif = builder.defaultKif;
        this.defaultKvc = builder.defaultKvc;
        this.defaultKeyRecordNumber = builder.defaultKeyRecordNumber;
        this.sessionModificationMode = builder.sessionModificationMode;
        this.ratificationMode = builder.ratificationMode;
        this.pinTransmissionMode = builder.pinTransmissionMode;
        this.defaultPinCipheringKey = builder.defaultPinCipheringKey;
        this.svGetLogReadMode = builder.svGetLogReadMode;
        this.svNegativeBalance = builder.svNegativeBalance;
    }

    CardResource<CalypsoSam> getSamResource() {
        return this.samResource;
    }

    PoTransaction.SessionSetting.ModificationMode getSessionModificationMode() {
        return this.sessionModificationMode;
    }

    PoTransaction.SessionSetting.RatificationMode getRatificationMode() {
        return this.ratificationMode;
    }

    public PoTransaction.PinTransmissionMode getPinTransmissionMode() {
        return this.pinTransmissionMode;
    }

    Byte getSessionDefaultKif(PoTransaction.SessionSetting.AccessLevel sessionAccessLevel) {
        return this.defaultKif.get((Object)sessionAccessLevel);
    }

    Byte getSessionDefaultKvc(PoTransaction.SessionSetting.AccessLevel sessionAccessLevel) {
        return this.defaultKvc.get((Object)sessionAccessLevel);
    }

    Byte getSessionDefaultKeyRecordNumber(PoTransaction.SessionSetting.AccessLevel sessionAccessLevel) {
        return this.defaultKeyRecordNumber.get((Object)sessionAccessLevel);
    }

    boolean isSessionKvcAuthorized(byte kvc) {
        return this.authorizedKvcList == null || this.authorizedKvcList.contains(kvc);
    }

    KeyReference getDefaultPinCipheringKey() {
        return this.defaultPinCipheringKey;
    }

    PoTransaction.SvSettings.LogRead getSvGetLogReadMode() {
        return this.svGetLogReadMode;
    }

    PoTransaction.SvSettings.NegativeBalance getSvNegativeBalance() {
        return this.svNegativeBalance;
    }

    static /* synthetic */ KeyReference access$500() {
        return nullPinCipheringKey;
    }

    static /* synthetic */ PoTransaction.SvSettings.LogRead access$600() {
        return defaultSvGetLogReadMode;
    }

    static /* synthetic */ PoTransaction.SvSettings.NegativeBalance access$700() {
        return defaultSvNegativeBalance;
    }

    public static final class PoSecuritySettingsBuilder {
        private final CardResource<CalypsoSam> samResource;
        private List<Byte> authorizedKvcList;
        private final EnumMap<PoTransaction.SessionSetting.AccessLevel, Byte> defaultKif = new EnumMap(PoTransaction.SessionSetting.AccessLevel.class);
        private final EnumMap<PoTransaction.SessionSetting.AccessLevel, Byte> defaultKvc = new EnumMap(PoTransaction.SessionSetting.AccessLevel.class);
        private final EnumMap<PoTransaction.SessionSetting.AccessLevel, Byte> defaultKeyRecordNumber = new EnumMap(PoTransaction.SessionSetting.AccessLevel.class);
        PoTransaction.SessionSetting.ModificationMode sessionModificationMode = defaultSessionModificationMode;
        PoTransaction.SessionSetting.RatificationMode ratificationMode = defaultRatificationMode;
        PoTransaction.PinTransmissionMode pinTransmissionMode = defaultPinTransmissionMode;
        KeyReference defaultPinCipheringKey = PoSecuritySettings.access$500();
        PoTransaction.SvSettings.LogRead svGetLogReadMode = PoSecuritySettings.access$600();
        PoTransaction.SvSettings.NegativeBalance svNegativeBalance = PoSecuritySettings.access$700();

        public PoSecuritySettingsBuilder(CardResource<CalypsoSam> samResource) {
            if (samResource == null) {
                throw new IllegalStateException("SAM resource cannot be null.");
            }
            this.samResource = samResource;
        }

        public PoSecuritySettingsBuilder sessionModificationMode(PoTransaction.SessionSetting.ModificationMode sessionModificationMode) {
            this.sessionModificationMode = sessionModificationMode;
            return this;
        }

        public PoSecuritySettingsBuilder ratificationMode(PoTransaction.SessionSetting.RatificationMode ratificationMode) {
            this.ratificationMode = ratificationMode;
            return this;
        }

        public PoSecuritySettingsBuilder pinTransmissionMode(PoTransaction.PinTransmissionMode pinTransmissionMode) {
            this.pinTransmissionMode = pinTransmissionMode;
            return this;
        }

        public PoSecuritySettingsBuilder sessionDefaultKif(PoTransaction.SessionSetting.AccessLevel sessionAccessLevel, byte kif) {
            this.defaultKif.put(sessionAccessLevel, kif);
            return this;
        }

        public PoSecuritySettingsBuilder sessionDefaultKvc(PoTransaction.SessionSetting.AccessLevel sessionAccessLevel, byte kvc) {
            this.defaultKvc.put(sessionAccessLevel, kvc);
            return this;
        }

        public PoSecuritySettingsBuilder sessionDefaultKeyRecordNumber(PoTransaction.SessionSetting.AccessLevel sessionAccessLevel, byte keyRecordNumber) {
            this.defaultKeyRecordNumber.put(sessionAccessLevel, keyRecordNumber);
            return this;
        }

        public PoSecuritySettingsBuilder sessionAuthorizedKvcList(List<Byte> authorizedKvcList) {
            this.authorizedKvcList = authorizedKvcList;
            return this;
        }

        public PoSecuritySettingsBuilder pinCipheringKey(byte kif, byte kvc) {
            this.defaultPinCipheringKey = new KeyReference(kif, kvc);
            return this;
        }

        public PoSecuritySettingsBuilder svGetLogReadMode(PoTransaction.SvSettings.LogRead svGetLogReadMode) {
            this.svGetLogReadMode = svGetLogReadMode;
            return this;
        }

        public PoSecuritySettingsBuilder svNegativeBalance(PoTransaction.SvSettings.NegativeBalance svNegativeBalance) {
            this.svNegativeBalance = svNegativeBalance;
            return this;
        }

        public PoSecuritySettings build() {
            return new PoSecuritySettings(this);
        }
    }
}

