/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.keyple.calypso.command.po.AbstractPoCommandBuilder;
import org.eclipse.keyple.calypso.command.po.AbstractPoResponseParser;
import org.eclipse.keyple.calypso.command.po.CalypsoPoCommand;
import org.eclipse.keyple.calypso.transaction.PoTransaction;
import org.eclipse.keyple.calypso.transaction.exception.CalypsoPoTransactionIllegalStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PoCommandManager {
    private static final Logger logger = LoggerFactory.getLogger(PoCommandManager.class);
    private final List<AbstractPoCommandBuilder<? extends AbstractPoResponseParser>> poCommands = new ArrayList<AbstractPoCommandBuilder<? extends AbstractPoResponseParser>>();
    private CalypsoPoCommand svLastCommand;
    private PoTransaction.SvSettings.Operation svOperation;
    private boolean svOperationComplete = false;

    PoCommandManager() {
    }

    void addRegularCommand(AbstractPoCommandBuilder<? extends AbstractPoResponseParser> commandBuilder) {
        this.poCommands.add(commandBuilder);
    }

    void addStoredValueCommand(AbstractPoCommandBuilder<? extends AbstractPoResponseParser> commandBuilder, PoTransaction.SvSettings.Operation svOperation) {
        switch (commandBuilder.getCommandRef()) {
            case SV_GET: {
                this.svOperation = svOperation;
                break;
            }
            case SV_RELOAD: 
            case SV_DEBIT: 
            case SV_UNDEBIT: {
                if (!this.poCommands.isEmpty()) {
                    throw new CalypsoPoTransactionIllegalStateException("This SV command can only be placed in the first position in the list of prepared commands");
                }
                if (this.svLastCommand != CalypsoPoCommand.SV_GET) {
                    throw new IllegalStateException("This SV command must follow an SV Get command");
                }
                if (svOperation != this.svOperation) {
                    logger.error("Sv operation = {}, current command = {}", (Object)this.svOperation, (Object)svOperation);
                    throw new CalypsoPoTransactionIllegalStateException("Inconsistent SV operation.");
                }
                this.svOperation = svOperation;
                this.svOperationComplete = true;
                break;
            }
            default: {
                throw new IllegalStateException("An SV command is expected.");
            }
        }
        this.svLastCommand = commandBuilder.getCommandRef();
        this.poCommands.add(commandBuilder);
    }

    void notifyCommandsProcessed() {
        this.poCommands.clear();
    }

    List<AbstractPoCommandBuilder<? extends AbstractPoResponseParser>> getPoCommandBuilders() {
        return this.poCommands;
    }

    boolean hasCommands() {
        return !this.poCommands.isEmpty();
    }

    boolean isSvOperationCompleteOneTime() {
        boolean flag = this.svOperationComplete;
        this.svOperationComplete = false;
        return flag;
    }
}

