/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction;

import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.keyple.core.util.ByteArrayUtil;

public class FileHeader
implements Serializable {
    private final short lid;
    private final int recordsNumber;
    private final int recordSize;
    private final FileType type;
    private final byte[] accessConditions;
    private final byte[] keyIndexes;
    private final byte dfStatus;
    private final Short sharedReference;

    private FileHeader(FileHeaderBuilder builder) {
        this.lid = builder.lid;
        this.recordsNumber = builder.recordsNumber;
        this.recordSize = builder.recordSize;
        this.type = builder.type;
        this.accessConditions = builder.accessConditions;
        this.keyIndexes = builder.keyIndexes;
        this.dfStatus = builder.dfStatus;
        this.sharedReference = builder.sharedReference;
    }

    public short getLid() {
        return this.lid;
    }

    public int getRecordsNumber() {
        return this.recordsNumber;
    }

    public int getRecordSize() {
        return this.recordSize;
    }

    public FileType getType() {
        return this.type;
    }

    public byte[] getAccessConditions() {
        return this.accessConditions;
    }

    public byte[] getKeyIndexes() {
        return this.keyIndexes;
    }

    public byte getDfStatus() {
        return this.dfStatus;
    }

    public boolean isShared() {
        return this.sharedReference != null;
    }

    public Short getSharedReference() {
        return this.sharedReference;
    }

    static FileHeaderBuilder builder() {
        return new FileHeaderBuilder();
    }

    FileHeader(FileHeader source) {
        this.lid = source.getLid();
        this.recordsNumber = source.getRecordsNumber();
        this.recordSize = source.getRecordSize();
        this.type = source.getType();
        this.accessConditions = Arrays.copyOf(source.getAccessConditions(), source.getAccessConditions().length);
        this.keyIndexes = Arrays.copyOf(source.getKeyIndexes(), source.getKeyIndexes().length);
        this.dfStatus = source.getDfStatus();
        this.sharedReference = source.getSharedReference();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileHeader that = (FileHeader)o;
        return this.lid == that.lid;
    }

    public int hashCode() {
        return this.lid;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FileHeader{");
        sb.append("lid=0x").append(Integer.toHexString(this.lid & 0xFFFF));
        sb.append(", recordsNumber=").append(this.recordsNumber);
        sb.append(", recordSize=").append(this.recordSize);
        sb.append(", type=").append((Object)this.type);
        sb.append(", accessConditions=").append("0x").append(ByteArrayUtil.toHex((byte[])this.accessConditions));
        sb.append(", keyIndexes=").append("0x").append(ByteArrayUtil.toHex((byte[])this.keyIndexes));
        sb.append(", dfStatus=0x").append(this.dfStatus);
        sb.append(", sharedReference=0x").append(Integer.toHexString(this.sharedReference.shortValue()));
        sb.append('}');
        return sb.toString();
    }

    static final class FileHeaderBuilder {
        private short lid;
        private int recordsNumber;
        private int recordSize;
        private FileType type;
        private byte[] accessConditions;
        private byte[] keyIndexes;
        private byte dfStatus;
        private Short sharedReference;

        private FileHeaderBuilder() {
        }

        FileHeaderBuilder lid(short lid) {
            this.lid = lid;
            return this;
        }

        FileHeaderBuilder recordsNumber(int recordsNumber) {
            this.recordsNumber = recordsNumber;
            return this;
        }

        FileHeaderBuilder recordSize(int recordSize) {
            this.recordSize = recordSize;
            return this;
        }

        FileHeaderBuilder type(FileType type) {
            this.type = type;
            return this;
        }

        FileHeaderBuilder accessConditions(byte[] accessConditions) {
            this.accessConditions = accessConditions;
            return this;
        }

        FileHeaderBuilder keyIndexes(byte[] keyIndexes) {
            this.keyIndexes = keyIndexes;
            return this;
        }

        FileHeaderBuilder dfStatus(byte dfStatus) {
            this.dfStatus = dfStatus;
            return this;
        }

        FileHeaderBuilder sharedReference(short sharedReference) {
            this.sharedReference = sharedReference;
            return this;
        }

        FileHeader build() {
            return new FileHeader(this);
        }
    }

    public static enum FileType {
        LINEAR,
        BINARY,
        CYCLIC,
        COUNTERS,
        SIMULATED_COUNTERS;

    }
}

