/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.core.util.ByteArrayUtil;

public class FileData
implements Serializable {
    private final TreeMap<Integer, byte[]> records = new TreeMap();

    FileData() {
    }

    FileData(FileData source) {
        SortedMap<Integer, byte[]> sourceContent = source.getAllRecordsContent();
        for (Map.Entry<Integer, byte[]> entry : sourceContent.entrySet()) {
            this.records.put(entry.getKey(), Arrays.copyOf(entry.getValue(), entry.getValue().length));
        }
    }

    public SortedMap<Integer, byte[]> getAllRecordsContent() {
        return this.records;
    }

    public byte[] getContent() {
        return this.getContent(1);
    }

    public byte[] getContent(int numRecord) {
        byte[] content = this.records.get(numRecord);
        if (content == null) {
            throw new NoSuchElementException("Record #" + numRecord + " is not set.");
        }
        return content;
    }

    public byte[] getContent(int numRecord, int dataOffset, int dataLength) {
        Assert.getInstance().greaterOrEqual(Integer.valueOf(dataOffset), 0, "dataOffset").greaterOrEqual(Integer.valueOf(dataLength), 1, "dataLength");
        byte[] content = this.records.get(numRecord);
        if (content == null) {
            throw new NoSuchElementException("Record #" + numRecord + " is not set.");
        }
        if (dataOffset >= content.length) {
            throw new IndexOutOfBoundsException("Offset [" + dataOffset + "] >= content length [" + content.length + "].");
        }
        int toIndex = dataOffset + dataLength;
        if (toIndex > content.length) {
            throw new IndexOutOfBoundsException("Offset [" + dataOffset + "] + Length [" + dataLength + "] = [" + toIndex + "] > content length [" + content.length + "].");
        }
        return Arrays.copyOfRange(content, dataOffset, toIndex);
    }

    public int getContentAsCounterValue(int numCounter) {
        Assert.getInstance().greaterOrEqual(Integer.valueOf(numCounter), 1, "numCounter");
        byte[] rec1 = this.records.get(1);
        if (rec1 == null) {
            throw new NoSuchElementException("Record #1 is not set.");
        }
        int counterIndex = (numCounter - 1) * 3;
        if (counterIndex >= rec1.length) {
            throw new NoSuchElementException("Counter #" + numCounter + " is not set (nb of actual counters = " + rec1.length / 3 + ").");
        }
        if (counterIndex + 3 > rec1.length) {
            throw new IndexOutOfBoundsException("Counter #" + numCounter + " has a truncated value (nb of actual counters = " + rec1.length / 3 + ").");
        }
        return ByteArrayUtil.threeBytesToInt((byte[])rec1, (int)counterIndex);
    }

    public SortedMap<Integer, Integer> getAllCountersValue() {
        TreeMap<Integer, Integer> result = new TreeMap<Integer, Integer>();
        byte[] rec1 = this.records.get(1);
        if (rec1 == null) {
            throw new NoSuchElementException("Record #1 is not set.");
        }
        int length = rec1.length - rec1.length % 3;
        int i = 0;
        int c = 1;
        while (i < length) {
            result.put(c, ByteArrayUtil.threeBytesToInt((byte[])rec1, (int)i));
            i += 3;
            ++c;
        }
        return result;
    }

    void setContent(int numRecord, byte[] content) {
        this.records.put(numRecord, content);
    }

    void setCounter(int numCounter, byte[] content) {
        this.setContent(1, content, (numCounter - 1) * 3);
    }

    void setContent(int numRecord, byte[] content, int offset) {
        byte[] newContent;
        int newLength = offset + content.length;
        byte[] oldContent = this.records.get(numRecord);
        if (oldContent == null) {
            newContent = new byte[newLength];
        } else if (oldContent.length <= offset) {
            newContent = new byte[newLength];
            System.arraycopy(oldContent, 0, newContent, 0, oldContent.length);
        } else if (oldContent.length < newLength) {
            newContent = new byte[newLength];
            System.arraycopy(oldContent, 0, newContent, 0, offset);
        } else {
            newContent = oldContent;
        }
        System.arraycopy(content, 0, newContent, offset, content.length);
        this.records.put(numRecord, newContent);
    }

    void fillContent(int numRecord, byte[] content) {
        byte[] actualContent = this.records.get(numRecord);
        if (actualContent == null) {
            this.records.put(numRecord, content);
        } else if (actualContent.length < content.length) {
            for (int i = 0; i < actualContent.length; ++i) {
                int n = i;
                content[n] = (byte)(content[n] | actualContent[i]);
            }
            this.records.put(numRecord, content);
        } else {
            for (int i = 0; i < content.length; ++i) {
                int n = i;
                actualContent[n] = (byte)(actualContent[n] | content[i]);
            }
        }
    }

    void addCyclicContent(byte[] content) {
        ArrayList<Integer> descendingKeys = new ArrayList<Integer>(this.records.descendingKeySet());
        for (Integer i : descendingKeys) {
            this.records.put(i + 1, this.records.get(i));
        }
        this.records.put(1, content);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FileData{");
        sb.append("records={");
        for (Map.Entry<Integer, byte[]> rec : this.records.entrySet()) {
            sb.append("(");
            sb.append(rec.getKey());
            sb.append("=0x");
            sb.append(ByteArrayUtil.toHex((byte[])rec.getValue()));
            sb.append(")");
        }
        sb.append("}}");
        return sb.toString();
    }
}

