/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.NoSuchElementException;
import org.eclipse.keyple.calypso.transaction.PoTransaction;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.core.util.ByteArrayUtil;

public class DirectoryHeader
implements Serializable {
    private final short lid;
    private final byte[] accessConditions;
    private final byte[] keyIndexes;
    private final byte dfStatus;
    private final EnumMap<PoTransaction.SessionSetting.AccessLevel, Byte> kif;
    private final EnumMap<PoTransaction.SessionSetting.AccessLevel, Byte> kvc;
    private static final String LEVEL_STR = "level";

    private DirectoryHeader(DirectoryHeaderBuilder builder) {
        this.lid = builder.lid;
        this.accessConditions = builder.accessConditions;
        this.keyIndexes = builder.keyIndexes;
        this.dfStatus = builder.dfStatus;
        this.kif = builder.kif;
        this.kvc = builder.kvc;
    }

    public short getLid() {
        return this.lid;
    }

    public byte[] getAccessConditions() {
        return this.accessConditions;
    }

    public byte[] getKeyIndexes() {
        return this.keyIndexes;
    }

    public byte getDfStatus() {
        return this.dfStatus;
    }

    public boolean isKifAvailable(PoTransaction.SessionSetting.AccessLevel level) {
        Assert.getInstance().notNull((Object)level, LEVEL_STR);
        return this.kif.get((Object)level) != null;
    }

    public boolean isKvcAvailable(PoTransaction.SessionSetting.AccessLevel level) {
        Assert.getInstance().notNull((Object)level, LEVEL_STR);
        return this.kvc.get((Object)level) != null;
    }

    public byte getKif(PoTransaction.SessionSetting.AccessLevel level) {
        Assert.getInstance().notNull((Object)level, LEVEL_STR);
        Byte result = this.kif.get((Object)level);
        if (result == null) {
            throw new NoSuchElementException("KIF not found for session access level [" + (Object)((Object)level) + "].");
        }
        return result;
    }

    public byte getKvc(PoTransaction.SessionSetting.AccessLevel level) {
        Assert.getInstance().notNull((Object)level, LEVEL_STR);
        Byte result = this.kvc.get((Object)level);
        if (result == null) {
            throw new NoSuchElementException("KVC not found for session access level [" + (Object)((Object)level) + "].");
        }
        return result;
    }

    static DirectoryHeaderBuilder builder() {
        return new DirectoryHeaderBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectoryHeader that = (DirectoryHeader)o;
        return this.lid == that.lid;
    }

    public int hashCode() {
        return this.lid;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DirectoryHeader{");
        sb.append("lid=0x").append(Integer.toHexString(this.lid & 0xFFFF));
        sb.append(", accessConditions=").append("0x").append(ByteArrayUtil.toHex((byte[])this.accessConditions));
        sb.append(", keyIndexes=").append("0x").append(ByteArrayUtil.toHex((byte[])this.keyIndexes));
        sb.append(", dfStatus=0x").append(this.dfStatus);
        sb.append(", kif=").append(this.kif);
        sb.append(", kvc=").append(this.kvc);
        sb.append('}');
        return sb.toString();
    }

    static final class DirectoryHeaderBuilder {
        private short lid;
        private byte[] accessConditions;
        private byte[] keyIndexes;
        private byte dfStatus;
        private final EnumMap<PoTransaction.SessionSetting.AccessLevel, Byte> kif = new EnumMap(PoTransaction.SessionSetting.AccessLevel.class);
        private final EnumMap<PoTransaction.SessionSetting.AccessLevel, Byte> kvc = new EnumMap(PoTransaction.SessionSetting.AccessLevel.class);

        private DirectoryHeaderBuilder() {
        }

        DirectoryHeaderBuilder lid(short lid) {
            this.lid = lid;
            return this;
        }

        DirectoryHeaderBuilder accessConditions(byte[] accessConditions) {
            this.accessConditions = accessConditions;
            return this;
        }

        DirectoryHeaderBuilder keyIndexes(byte[] keyIndexes) {
            this.keyIndexes = keyIndexes;
            return this;
        }

        DirectoryHeaderBuilder dfStatus(byte dfStatus) {
            this.dfStatus = dfStatus;
            return this;
        }

        DirectoryHeaderBuilder kif(PoTransaction.SessionSetting.AccessLevel level, byte kif) {
            this.kif.put(level, kif);
            return this;
        }

        DirectoryHeaderBuilder kvc(PoTransaction.SessionSetting.AccessLevel level, byte kvc) {
            this.kvc.put(level, kvc);
            return this;
        }

        DirectoryHeader build() {
            return new DirectoryHeader(this);
        }
    }
}

