/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.keyple.calypso.command.sam.SamRevision;
import org.eclipse.keyple.core.card.message.CardSelectionResponse;
import org.eclipse.keyple.core.card.selection.AbstractSmartCard;
import org.eclipse.keyple.core.util.ByteArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalypsoSam
extends AbstractSmartCard {
    private static final Logger logger = LoggerFactory.getLogger(CalypsoSam.class);
    private final SamRevision samRevision;
    private final byte[] serialNumber = new byte[4];
    private final byte platform;
    private final byte applicationType;
    private final byte applicationSubType;
    private final byte softwareIssuer;
    private final byte softwareVersion;
    private final byte softwareRevision;

    CalypsoSam(CardSelectionResponse cardSelectionResponse) {
        super(cardSelectionResponse);
        String atrString = ByteArrayUtil.toHex((byte[])cardSelectionResponse.getSelectionStatus().getAtr().getBytes());
        if (atrString.isEmpty()) {
            throw new IllegalStateException("ATR should not be empty.");
        }
        String extractRegex = "3B(.{6}|.{10})805A(.{20})829000";
        Pattern pattern = Pattern.compile(extractRegex);
        Matcher matcher = pattern.matcher(atrString);
        if (matcher.find(0)) {
            byte[] atrSubElements = ByteArrayUtil.fromHex((String)matcher.group(2));
            this.platform = atrSubElements[0];
            this.applicationType = atrSubElements[1];
            this.applicationSubType = atrSubElements[2];
            switch (this.applicationSubType) {
                case -63: {
                    this.samRevision = SamRevision.C1;
                    break;
                }
                case -48: 
                case -47: 
                case -46: {
                    this.samRevision = SamRevision.S1D;
                    break;
                }
                case -31: {
                    this.samRevision = SamRevision.S1E;
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unknown SAM revision (unrecognized application subtype 0x%02X)", this.applicationSubType));
                }
            }
            this.softwareIssuer = atrSubElements[3];
            this.softwareVersion = atrSubElements[4];
            this.softwareRevision = atrSubElements[5];
            System.arraycopy(atrSubElements, 6, this.serialNumber, 0, 4);
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("SAM %s PLATFORM = %02X, APPTYPE = %02X, APPSUBTYPE = %02X, SWISSUER = %02X, SWVERSION = %02X, SWREVISION = %02X", this.samRevision.getName(), this.platform, this.applicationType, this.applicationSubType, this.softwareIssuer, this.softwareVersion, this.softwareRevision));
                logger.trace("SAM SERIALNUMBER = {}", (Object)ByteArrayUtil.toHex((byte[])this.serialNumber));
            }
        } else {
            throw new IllegalStateException("Unrecognized ATR structure: " + atrString);
        }
    }

    public final SamRevision getSamRevision() {
        return this.samRevision;
    }

    public final byte[] getSerialNumber() {
        return this.serialNumber;
    }

    public final byte getPlatform() {
        return this.platform;
    }

    public final byte getApplicationType() {
        return this.applicationType;
    }

    public final byte getApplicationSubType() {
        return this.applicationSubType;
    }

    public final byte getSoftwareIssuer() {
        return this.softwareIssuer;
    }

    public final byte getSoftwareVersion() {
        return this.softwareVersion;
    }

    public final byte getSoftwareRevision() {
        return this.softwareRevision;
    }
}

