/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.keyple.calypso.SelectFileControl;
import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.AbstractPoCommandBuilder;
import org.eclipse.keyple.calypso.command.po.AbstractPoResponseParser;
import org.eclipse.keyple.calypso.command.po.builder.AppendRecordCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.DecreaseCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.IncreaseCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.ReadRecordsCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.SelectFileCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.UpdateRecordCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.WriteRecordCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.security.AbstractOpenSessionCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.security.CloseSessionCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.security.PoGetChallengeCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.security.VerifyPinCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.storedvalue.SvGetCmdBuild;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoPinException;
import org.eclipse.keyple.calypso.command.po.parser.AppendRecordRespPars;
import org.eclipse.keyple.calypso.command.po.parser.DecreaseRespPars;
import org.eclipse.keyple.calypso.command.po.parser.IncreaseRespPars;
import org.eclipse.keyple.calypso.command.po.parser.ReadRecordsRespPars;
import org.eclipse.keyple.calypso.command.po.parser.SelectFileRespPars;
import org.eclipse.keyple.calypso.command.po.parser.UpdateRecordRespPars;
import org.eclipse.keyple.calypso.command.po.parser.WriteRecordRespPars;
import org.eclipse.keyple.calypso.command.po.parser.security.AbstractOpenSessionRespPars;
import org.eclipse.keyple.calypso.command.po.parser.security.CloseSessionRespPars;
import org.eclipse.keyple.calypso.command.po.parser.security.PoGetChallengeRespPars;
import org.eclipse.keyple.calypso.command.po.parser.security.VerifyPinRespPars;
import org.eclipse.keyple.calypso.command.po.parser.storedvalue.SvGetRespPars;
import org.eclipse.keyple.calypso.transaction.CalypsoPo;
import org.eclipse.keyple.calypso.transaction.DirectoryHeader;
import org.eclipse.keyple.calypso.transaction.FileHeader;
import org.eclipse.keyple.calypso.transaction.PoTransaction;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.eclipse.keyple.core.util.Assert;

final class CalypsoPoUtils {
    public static final int MASK_3_BITS = 7;
    public static final int MASK_4_BITS = 15;
    public static final int MASK_5_BITS = 31;
    public static final int MASK_7_BITS = 127;
    public static final int MASK_1_BYTE = 255;
    public static final int MASK_2_BYTES = 65535;
    public static final int MASK_3_BYTES = 0xFFFFFF;
    public static final int SFI_MIN = 0;
    public static final int SFI_MAX = 31;
    public static final int NB_REC_MIN = 1;
    public static final int NB_REC_MAX = 255;
    public static final int NB_CNT_MIN = 1;
    public static final int NB_CNT_MAX = 255;
    public static final int CNT_VALUE_MIN = 0;
    public static final int CNT_VALUE_MAX = 0xFFFFFF;
    public static final int LE_MAX = 255;
    public static final int FILE_TYPE_MF = 1;
    public static final int FILE_TYPE_DF = 2;
    public static final int FILE_TYPE_EF = 4;
    public static final int EF_TYPE_DF = 0;
    public static final int EF_TYPE_BINARY = 1;
    public static final int EF_TYPE_LINEAR = 2;
    public static final int EF_TYPE_CYCLIC = 4;
    public static final int EF_TYPE_SIMULATED_COUNTERS = 8;
    public static final int EF_TYPE_COUNTERS = 9;
    public static final int SEL_SFI_OFFSET = 0;
    public static final int SEL_TYPE_OFFSET = 1;
    public static final int SEL_EF_TYPE_OFFSET = 2;
    public static final int SEL_REC_SIZE_OFFSET = 3;
    public static final int SEL_NUM_REC_OFFSET = 4;
    public static final int SEL_AC_OFFSET = 5;
    public static final int SEL_AC_LENGTH = 4;
    public static final int SEL_NKEY_OFFSET = 9;
    public static final int SEL_NKEY_LENGTH = 4;
    public static final int SEL_DF_STATUS_OFFSET = 13;
    public static final int SEL_KVCS_OFFSET = 14;
    public static final int SEL_KIFS_OFFSET = 17;
    public static final int SEL_DATA_REF_OFFSET = 14;
    public static final int SEL_LID_OFFSET = 21;
    public static final int PIN_LENGTH = 4;
    public static final byte STORED_VALUE_FILE_STRUCTURE_ID = 32;
    public static final byte SV_RELOAD_LOG_FILE_SFI = 20;
    public static final int SV_RELOAD_LOG_FILE_NB_REC = 1;
    public static final byte SV_DEBIT_LOG_FILE_SFI = 21;
    public static final int SV_DEBIT_LOG_FILE_NB_REC = 3;
    public static final int SV_LOG_FILE_REC_LENGTH = 29;
    private static byte[] poChallenge;
    private static byte svKvc;
    private static byte[] svGetHeader;
    private static byte[] svGetData;
    private static byte[] svOperationSignature;

    private CalypsoPoUtils() {
    }

    private static AbstractOpenSessionRespPars updateCalypsoPoOpenSession(CalypsoPo calypsoPo, AbstractOpenSessionCmdBuild<AbstractOpenSessionRespPars> openSessionCmdBuild, ApduResponse apduResponse) {
        AbstractOpenSessionRespPars openSessionRespPars = (AbstractOpenSessionRespPars)((Object)openSessionCmdBuild.createResponseParser(apduResponse));
        calypsoPo.setDfRatified(openSessionRespPars.wasRatified());
        byte[] recordDataRead = openSessionRespPars.getRecordDataRead();
        if (recordDataRead.length > 0) {
            calypsoPo.setContent((byte)openSessionCmdBuild.getSfi(), openSessionCmdBuild.getRecordNumber(), recordDataRead);
        }
        return openSessionRespPars;
    }

    private static CloseSessionRespPars updateCalypsoPoCloseSession(CloseSessionCmdBuild closeSessionCmdBuild, ApduResponse apduResponse) {
        CloseSessionRespPars closeSessionRespPars = closeSessionCmdBuild.createResponseParser(apduResponse);
        closeSessionRespPars.checkStatus();
        return closeSessionRespPars;
    }

    private static ReadRecordsRespPars updateCalypsoPoReadRecords(CalypsoPo calypsoPo, ReadRecordsCmdBuild readRecordsCmdBuild, ApduResponse apduResponse) {
        ReadRecordsRespPars readRecordsRespPars = readRecordsCmdBuild.createResponseParser(apduResponse);
        readRecordsRespPars.checkStatus();
        for (Map.Entry<Integer, byte[]> entry : readRecordsRespPars.getRecords().entrySet()) {
            calypsoPo.setContent((byte)readRecordsCmdBuild.getSfi(), entry.getKey(), entry.getValue());
        }
        return readRecordsRespPars;
    }

    private static SelectFileRespPars updateCalypsoPoSelectFile(CalypsoPo calypsoPo, SelectFileCmdBuild selectFileCmdBuild, ApduResponse apduResponse) {
        SelectFileRespPars selectFileRespPars = selectFileCmdBuild.createResponseParser(apduResponse);
        selectFileRespPars.checkStatus();
        byte[] proprietaryInformation = selectFileRespPars.getProprietaryInformation();
        byte sfi = proprietaryInformation[0];
        byte fileType = proprietaryInformation[1];
        switch (fileType) {
            case 1: 
            case 2: {
                DirectoryHeader directoryHeader = CalypsoPoUtils.createDirectoryHeader(proprietaryInformation);
                calypsoPo.setDirectoryHeader(directoryHeader);
                break;
            }
            case 4: {
                FileHeader fileHeader = CalypsoPoUtils.createFileHeader(proprietaryInformation);
                calypsoPo.setFileHeader(sfi, fileHeader);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unknown file type: 0x%02X", fileType));
            }
        }
        return selectFileRespPars;
    }

    private static UpdateRecordRespPars updateCalypsoPoUpdateRecord(CalypsoPo calypsoPo, UpdateRecordCmdBuild updateRecordCmdBuild, ApduResponse apduResponse) {
        UpdateRecordRespPars updateRecordRespPars = updateRecordCmdBuild.createResponseParser(apduResponse);
        updateRecordRespPars.checkStatus();
        calypsoPo.setContent((byte)updateRecordCmdBuild.getSfi(), updateRecordCmdBuild.getRecordNumber(), updateRecordCmdBuild.getData());
        return updateRecordRespPars;
    }

    private static WriteRecordRespPars updateCalypsoPoWriteRecord(CalypsoPo calypsoPo, WriteRecordCmdBuild writeRecordCmdBuild, ApduResponse apduResponse) {
        WriteRecordRespPars writeRecordRespPars = writeRecordCmdBuild.createResponseParser(apduResponse);
        writeRecordRespPars.checkStatus();
        calypsoPo.fillContent((byte)writeRecordCmdBuild.getSfi(), writeRecordCmdBuild.getRecordNumber(), writeRecordCmdBuild.getData());
        return writeRecordRespPars;
    }

    private static AppendRecordRespPars updateCalypsoPoAppendRecord(CalypsoPo calypsoPo, AppendRecordCmdBuild appendRecordCmdBuild, ApduResponse apduResponse) {
        AppendRecordRespPars appendRecordRespPars = appendRecordCmdBuild.createResponseParser(apduResponse);
        appendRecordRespPars.checkStatus();
        calypsoPo.addCyclicContent((byte)appendRecordCmdBuild.getSfi(), appendRecordCmdBuild.getData());
        return appendRecordRespPars;
    }

    private static DecreaseRespPars updateCalypsoPoDecrease(CalypsoPo calypsoPo, DecreaseCmdBuild decreaseCmdBuild, ApduResponse apduResponse) {
        DecreaseRespPars decreaseRespPars = decreaseCmdBuild.createResponseParser(apduResponse);
        decreaseRespPars.checkStatus();
        calypsoPo.setContent((byte)decreaseCmdBuild.getSfi(), 1, apduResponse.getDataOut(), 3 * (decreaseCmdBuild.getCounterNumber() - 1));
        return decreaseRespPars;
    }

    private static IncreaseRespPars updateCalypsoPoIncrease(CalypsoPo calypsoPo, IncreaseCmdBuild increaseCmdBuild, ApduResponse apduResponse) {
        IncreaseRespPars increaseRespPars = increaseCmdBuild.createResponseParser(apduResponse);
        increaseRespPars.checkStatus();
        calypsoPo.setContent((byte)increaseCmdBuild.getSfi(), 1, apduResponse.getDataOut(), 3 * (increaseCmdBuild.getCounterNumber() - 1));
        return increaseRespPars;
    }

    private static PoGetChallengeRespPars updateCalypsoPoGetChallenge(PoGetChallengeCmdBuild poGetChallengeCmdBuild, ApduResponse apduResponse) {
        PoGetChallengeRespPars poGetChallengeRespPars = poGetChallengeCmdBuild.createResponseParser(apduResponse);
        poGetChallengeRespPars.checkStatus();
        poChallenge = apduResponse.getDataOut();
        return poGetChallengeRespPars;
    }

    private static VerifyPinRespPars updateCalypsoVerifyPin(CalypsoPo calypsoPo, VerifyPinCmdBuild verifyPinCmdBuild, ApduResponse apduResponse) {
        VerifyPinRespPars verifyPinRespPars;
        block2: {
            verifyPinRespPars = verifyPinCmdBuild.createResponseParser(apduResponse);
            calypsoPo.setPinAttemptRemaining(verifyPinRespPars.getRemainingAttemptCounter());
            try {
                verifyPinRespPars.checkStatus();
            }
            catch (CalypsoPoPinException ex) {
                if (verifyPinCmdBuild.isReadCounterOnly()) break block2;
                throw ex;
            }
        }
        return verifyPinRespPars;
    }

    private static SvGetRespPars updateCalypsoPoSvGet(CalypsoPo calypsoPo, SvGetCmdBuild svGetCmdBuild, ApduResponse apduResponse) {
        SvGetRespPars svGetRespPars = svGetCmdBuild.createResponseParser(apduResponse);
        svGetRespPars.checkStatus();
        calypsoPo.setSvData(svGetRespPars.getBalance(), svGetRespPars.getTransactionNumber(), svGetRespPars.getLoadLog(), svGetRespPars.getDebitLog());
        svKvc = svGetRespPars.getCurrentKVC();
        svGetHeader = svGetRespPars.getSvGetCommandHeader();
        svGetData = svGetRespPars.getApduResponse().getBytes();
        return svGetRespPars;
    }

    private static AbstractPoResponseParser updateCalypsoPoSvOperation(AbstractPoCommandBuilder<? extends AbstractPoResponseParser> svOperationCmdBuild, ApduResponse apduResponse) {
        AbstractPoResponseParser svOperationRespPars = svOperationCmdBuild.createResponseParser(apduResponse);
        svOperationRespPars.checkStatus();
        svOperationSignature = svOperationRespPars.getApduResponse().getDataOut();
        return svOperationRespPars;
    }

    private static AbstractPoResponseParser updateCalypsoInvalidateRehabilitate(AbstractPoCommandBuilder<? extends AbstractPoResponseParser> invalidateRehabilitateCmdBuild, ApduResponse apduResponse) {
        AbstractPoResponseParser invalidateRehabilitateRespPars = invalidateRehabilitateCmdBuild.createResponseParser(apduResponse);
        invalidateRehabilitateRespPars.checkStatus();
        return invalidateRehabilitateRespPars;
    }

    private static DirectoryHeader createDirectoryHeader(byte[] proprietaryInformation) {
        byte[] accessConditions = new byte[4];
        System.arraycopy(proprietaryInformation, 5, accessConditions, 0, 4);
        byte[] keyIndexes = new byte[4];
        System.arraycopy(proprietaryInformation, 9, keyIndexes, 0, 4);
        byte dfStatus = proprietaryInformation[13];
        short lid = (short)(proprietaryInformation[21] << 8 & 0xFF00 | proprietaryInformation[22] & 0xFF);
        return DirectoryHeader.builder().lid(lid).accessConditions(accessConditions).keyIndexes(keyIndexes).dfStatus(dfStatus).kvc(PoTransaction.SessionSetting.AccessLevel.SESSION_LVL_PERSO, proprietaryInformation[14]).kvc(PoTransaction.SessionSetting.AccessLevel.SESSION_LVL_LOAD, proprietaryInformation[15]).kvc(PoTransaction.SessionSetting.AccessLevel.SESSION_LVL_DEBIT, proprietaryInformation[16]).kif(PoTransaction.SessionSetting.AccessLevel.SESSION_LVL_PERSO, proprietaryInformation[17]).kif(PoTransaction.SessionSetting.AccessLevel.SESSION_LVL_LOAD, proprietaryInformation[18]).kif(PoTransaction.SessionSetting.AccessLevel.SESSION_LVL_DEBIT, proprietaryInformation[19]).build();
    }

    private static FileHeader.FileType getEfTypeFromPoValue(byte efType) {
        FileHeader.FileType fileType;
        switch (efType) {
            case 1: {
                fileType = FileHeader.FileType.BINARY;
                break;
            }
            case 2: {
                fileType = FileHeader.FileType.LINEAR;
                break;
            }
            case 4: {
                fileType = FileHeader.FileType.CYCLIC;
                break;
            }
            case 8: {
                fileType = FileHeader.FileType.SIMULATED_COUNTERS;
                break;
            }
            case 9: {
                fileType = FileHeader.FileType.COUNTERS;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown EF Type: " + efType);
            }
        }
        return fileType;
    }

    private static FileHeader createFileHeader(byte[] proprietaryInformation) {
        byte recordsNumber;
        int recordSize;
        FileHeader.FileType fileType = CalypsoPoUtils.getEfTypeFromPoValue(proprietaryInformation[2]);
        if (fileType == FileHeader.FileType.BINARY) {
            recordSize = proprietaryInformation[3] << 8 & 0xFF00 | proprietaryInformation[4] & 0xFF;
            recordsNumber = 1;
        } else {
            recordSize = proprietaryInformation[3];
            recordsNumber = proprietaryInformation[4];
        }
        byte[] accessConditions = new byte[4];
        System.arraycopy(proprietaryInformation, 5, accessConditions, 0, 4);
        byte[] keyIndexes = new byte[4];
        System.arraycopy(proprietaryInformation, 9, keyIndexes, 0, 4);
        byte dfStatus = proprietaryInformation[13];
        short sharedReference = (short)(proprietaryInformation[14] << 8 & 0xFF00 | proprietaryInformation[15] & 0xFF);
        short lid = (short)(proprietaryInformation[21] << 8 & 0xFF00 | proprietaryInformation[22] & 0xFF);
        return FileHeader.builder().lid(lid).recordsNumber(recordsNumber).recordSize(recordSize).type(fileType).accessConditions(Arrays.copyOf(accessConditions, accessConditions.length)).keyIndexes(Arrays.copyOf(keyIndexes, keyIndexes.length)).dfStatus(dfStatus).sharedReference(sharedReference).build();
    }

    static AbstractPoResponseParser updateCalypsoPo(CalypsoPo calypsoPo, AbstractPoCommandBuilder<? extends AbstractPoResponseParser> commandBuilder, ApduResponse apduResponse) {
        switch (commandBuilder.getCommandRef()) {
            case READ_RECORDS: {
                return CalypsoPoUtils.updateCalypsoPoReadRecords(calypsoPo, (ReadRecordsCmdBuild)commandBuilder, apduResponse);
            }
            case SELECT_FILE: {
                return CalypsoPoUtils.updateCalypsoPoSelectFile(calypsoPo, (SelectFileCmdBuild)commandBuilder, apduResponse);
            }
            case UPDATE_RECORD: {
                return CalypsoPoUtils.updateCalypsoPoUpdateRecord(calypsoPo, (UpdateRecordCmdBuild)commandBuilder, apduResponse);
            }
            case WRITE_RECORD: {
                return CalypsoPoUtils.updateCalypsoPoWriteRecord(calypsoPo, (WriteRecordCmdBuild)commandBuilder, apduResponse);
            }
            case APPEND_RECORD: {
                return CalypsoPoUtils.updateCalypsoPoAppendRecord(calypsoPo, (AppendRecordCmdBuild)commandBuilder, apduResponse);
            }
            case DECREASE: {
                return CalypsoPoUtils.updateCalypsoPoDecrease(calypsoPo, (DecreaseCmdBuild)commandBuilder, apduResponse);
            }
            case INCREASE: {
                return CalypsoPoUtils.updateCalypsoPoIncrease(calypsoPo, (IncreaseCmdBuild)commandBuilder, apduResponse);
            }
            case OPEN_SESSION_10: 
            case OPEN_SESSION_24: 
            case OPEN_SESSION_31: 
            case OPEN_SESSION_32: {
                return CalypsoPoUtils.updateCalypsoPoOpenSession(calypsoPo, (AbstractOpenSessionCmdBuild)commandBuilder, apduResponse);
            }
            case CLOSE_SESSION: {
                return CalypsoPoUtils.updateCalypsoPoCloseSession((CloseSessionCmdBuild)commandBuilder, apduResponse);
            }
            case GET_CHALLENGE: {
                return CalypsoPoUtils.updateCalypsoPoGetChallenge((PoGetChallengeCmdBuild)commandBuilder, apduResponse);
            }
            case VERIFY_PIN: {
                return CalypsoPoUtils.updateCalypsoVerifyPin(calypsoPo, (VerifyPinCmdBuild)commandBuilder, apduResponse);
            }
            case SV_GET: {
                return CalypsoPoUtils.updateCalypsoPoSvGet(calypsoPo, (SvGetCmdBuild)commandBuilder, apduResponse);
            }
            case SV_RELOAD: 
            case SV_DEBIT: 
            case SV_UNDEBIT: {
                return CalypsoPoUtils.updateCalypsoPoSvOperation(commandBuilder, apduResponse);
            }
            case INVALIDATE: 
            case REHABILITATE: {
                return CalypsoPoUtils.updateCalypsoInvalidateRehabilitate(commandBuilder, apduResponse);
            }
            case CHANGE_KEY: 
            case GET_DATA_FCI: 
            case GET_DATA_TRACE: {
                throw new IllegalStateException("Shouldn't happen for now!");
            }
        }
        throw new IllegalStateException("Unknown command reference.");
    }

    static void updateCalypsoPo(CalypsoPo calypsoPo, List<AbstractPoCommandBuilder<? extends AbstractPoResponseParser>> commandBuilders, List<ApduResponse> apduResponses) {
        Iterator<ApduResponse> responseIterator = apduResponses.iterator();
        if (commandBuilders != null && !commandBuilders.isEmpty()) {
            for (AbstractPoCommandBuilder<? extends AbstractPoResponseParser> commandBuilder : commandBuilders) {
                ApduResponse apduResponse = responseIterator.next();
                CalypsoPoUtils.updateCalypsoPo(calypsoPo, commandBuilder, apduResponse);
            }
        }
    }

    static ReadRecordsCmdBuild prepareReadRecordFile(PoClass poClass, byte sfi, int recordNumber) {
        Assert.getInstance().isInRange(Integer.valueOf(sfi), 0, 31, "sfi").isInRange(Integer.valueOf(recordNumber), 1, 255, "recordNumber");
        return new ReadRecordsCmdBuild(poClass, sfi, recordNumber, ReadRecordsCmdBuild.ReadMode.ONE_RECORD, 0);
    }

    static SelectFileCmdBuild prepareSelectFile(PoClass poClass, byte[] lid) {
        Assert.getInstance().notNull((Object)lid, "lid").isEqual(Integer.valueOf(lid.length), 2, "lid");
        return new SelectFileCmdBuild(poClass, lid);
    }

    static SelectFileCmdBuild prepareSelectFile(PoClass poClass, SelectFileControl selectControl) {
        return new SelectFileCmdBuild(poClass, selectControl);
    }

    static byte[] getPoChallenge() {
        return poChallenge;
    }

    static byte getSvKvc() {
        return svKvc;
    }

    static byte[] getSvGetHeader() {
        return svGetHeader;
    }

    static byte[] getSvGetData() {
        return svGetData;
    }

    static byte[] getSvOperationSignature() {
        return svOperationSignature;
    }
}

