/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.PoRevision;
import org.eclipse.keyple.calypso.command.po.parser.GetDataFciRespPars;
import org.eclipse.keyple.calypso.transaction.DirectoryHeader;
import org.eclipse.keyple.calypso.transaction.ElementaryFile;
import org.eclipse.keyple.calypso.transaction.FileHeader;
import org.eclipse.keyple.calypso.transaction.SvDebitLogRecord;
import org.eclipse.keyple.calypso.transaction.SvLoadLogRecord;
import org.eclipse.keyple.core.card.message.CardSelectionResponse;
import org.eclipse.keyple.core.card.selection.AbstractSmartCard;
import org.eclipse.keyple.core.util.ByteArrayUtil;

public class CalypsoPo
extends AbstractSmartCard {
    private final boolean isConfidentialSessionModeSupported;
    private final boolean isDeselectRatificationSupported;
    private final boolean isSvFeatureAvailable;
    private final boolean isPinFeatureAvailable;
    private final boolean isPublicAuthenticationSupported;
    private final boolean isDfInvalidated;
    private final PoClass poClass;
    private final byte[] calypsoSerialNumber;
    private final byte[] startupInfo;
    private final PoRevision revision;
    private final byte[] dfName;
    private static final int PO_REV1_ATR_LENGTH = 20;
    private static final int REV1_PO_DEFAULT_WRITE_OPERATIONS_NUMBER_SUPPORTED_PER_SESSION = 3;
    private static final int REV2_PO_DEFAULT_WRITE_OPERATIONS_NUMBER_SUPPORTED_PER_SESSION = 6;
    private static final int SI_BUFFER_SIZE_INDICATOR = 0;
    private static final int SI_PLATFORM = 1;
    private static final int SI_APPLICATION_TYPE = 2;
    private static final int SI_APPLICATION_SUBTYPE = 3;
    private static final int SI_SOFTWARE_ISSUER = 4;
    private static final int SI_SOFTWARE_VERSION = 5;
    private static final int SI_SOFTWARE_REVISION = 6;
    private static final byte APP_TYPE_WITH_CALYPSO_PIN = 1;
    private static final byte APP_TYPE_WITH_CALYPSO_SV = 2;
    private static final byte APP_TYPE_RATIFICATION_COMMAND_REQUIRED = 4;
    private static final byte APP_TYPE_CALYPSO_REV_32_MODE = 8;
    private static final byte APP_TYPE_WITH_PUBLIC_AUTHENTICATION = 16;
    private static final int[] BUFFER_SIZE_INDICATOR_TO_BUFFER_SIZE = new int[]{0, 0, 0, 0, 0, 0, 215, 256, 304, 362, 430, 512, 608, 724, 861, 1024, 1217, 1448, 1722, 2048, 2435, 2896, 3444, 4096, 4870, 5792, 6888, 8192, 9741, 11585, 13777, 16384, 19483, 23170, 27554, 32768, 38967, 46340, 55108, 65536, 77935, 92681, 110217, 131072, 155871, 185363, 220435, 262144, 311743, 370727, 440871, 524288, 623487, 741455, 881743, 0x100000};
    private final int modificationsCounterMax;
    private boolean modificationCounterIsInBytes = true;
    private DirectoryHeader directoryHeader;
    private final Map<Byte, ElementaryFile> efBySfi = new ConcurrentHashMap<Byte, ElementaryFile>();
    private final Map<Byte, ElementaryFile> efBySfiBackup = new ConcurrentHashMap<Byte, ElementaryFile>();
    private final Map<Short, Byte> sfiByLid = new ConcurrentHashMap<Short, Byte>();
    private final Map<Short, Byte> sfiByLidBackup = new ConcurrentHashMap<Short, Byte>();
    private Boolean isDfRatified = null;
    private Integer pinAttemptCounter;
    private Integer svBalance;
    private int svLastTNum;
    private SvLoadLogRecord svLoadLogRecord;
    private SvDebitLogRecord svDebitLogRecord;

    CalypsoPo(CardSelectionResponse cardSelectionResponse) {
        super(cardSelectionResponse);
        if (this.hasFci() && this.getFciBytes().length > 2) {
            GetDataFciRespPars poFciRespPars = new GetDataFciRespPars(cardSelectionResponse.getSelectionStatus().getFci(), null);
            this.dfName = poFciRespPars.getDfName();
            this.calypsoSerialNumber = poFciRespPars.getApplicationSerialNumber();
            this.startupInfo = poFciRespPars.getDiscretionaryData();
            this.isDfInvalidated = poFciRespPars.isDfInvalidated();
            byte applicationType = this.getApplicationType();
            this.revision = this.determineRevision(applicationType);
            byte bufferSizeIndicator = this.startupInfo[0];
            int bufferSizeValue = BUFFER_SIZE_INDICATOR_TO_BUFFER_SIZE[bufferSizeIndicator];
            if (this.revision == PoRevision.REV2_4) {
                this.modificationCounterIsInBytes = false;
                this.modificationsCounterMax = 6;
            } else {
                this.modificationsCounterMax = bufferSizeValue;
            }
            this.isConfidentialSessionModeSupported = (applicationType & 8) != 0;
            this.isDeselectRatificationSupported = (applicationType & 4) == 0;
            this.isSvFeatureAvailable = (applicationType & 2) != 0;
            this.isPinFeatureAvailable = (applicationType & 1) != 0;
            this.isPublicAuthenticationSupported = (applicationType & 0x10) != 0;
        } else {
            if (!this.hasAtr()) {
                throw new IllegalStateException("Unable to identify this PO: Neither the CFI nor the ATR are available.");
            }
            byte[] atr = this.getAtrBytes();
            if (atr.length != 20) {
                throw new IllegalStateException("Unexpected ATR length: " + ByteArrayUtil.toHex((byte[])this.getAtrBytes()));
            }
            this.revision = PoRevision.REV1_0;
            this.dfName = null;
            this.calypsoSerialNumber = new byte[8];
            this.modificationCounterIsInBytes = false;
            System.arraycopy(atr, 12, this.calypsoSerialNumber, 4, 4);
            this.modificationsCounterMax = 3;
            this.startupInfo = new byte[7];
            this.startupInfo[0] = (byte)this.modificationsCounterMax;
            System.arraycopy(atr, 6, this.startupInfo, 1, 6);
            this.isConfidentialSessionModeSupported = false;
            this.isDeselectRatificationSupported = true;
            this.isSvFeatureAvailable = false;
            this.isPinFeatureAvailable = false;
            this.isPublicAuthenticationSupported = false;
            this.isDfInvalidated = false;
        }
        this.poClass = this.revision == PoRevision.REV1_0 || this.revision == PoRevision.REV2_4 ? PoClass.LEGACY : PoClass.ISO;
    }

    private PoRevision determineRevision(byte applicationType) {
        if ((applicationType & 0xFF & 0x80) != 0) {
            return PoRevision.REV3_1_CLAP;
        }
        if (applicationType >> 3 == 5) {
            return PoRevision.REV3_2;
        }
        if (applicationType >> 3 == 4) {
            return PoRevision.REV3_1;
        }
        return PoRevision.REV2_4;
    }

    public final PoRevision getRevision() {
        return this.revision;
    }

    public final byte[] getDfNameBytes() {
        return this.dfName;
    }

    public final String getDfName() {
        return ByteArrayUtil.toHex((byte[])this.getDfNameBytes());
    }

    protected final byte[] getCalypsoSerialNumber() {
        return this.calypsoSerialNumber;
    }

    public final byte[] getApplicationSerialNumberBytes() {
        byte[] applicationSerialNumber = (byte[])this.calypsoSerialNumber.clone();
        applicationSerialNumber[0] = 0;
        applicationSerialNumber[1] = 0;
        return applicationSerialNumber;
    }

    public final String getApplicationSerialNumber() {
        return ByteArrayUtil.toHex((byte[])this.getApplicationSerialNumberBytes());
    }

    public final String getStartupInfo() {
        return ByteArrayUtil.toHex((byte[])this.startupInfo);
    }

    protected final boolean isSerialNumberExpiring() {
        throw new IllegalStateException("Not yet implemented");
    }

    protected final byte[] getSerialNumberExpirationBytes() {
        throw new IllegalStateException("Not yet implemented");
    }

    public final String getAtr() {
        return ByteArrayUtil.toHex((byte[])this.getAtrBytes());
    }

    protected final int getPayloadCapacity() {
        return 250;
    }

    protected final boolean isModificationsCounterInBytes() {
        return this.modificationCounterIsInBytes;
    }

    protected final int getModificationsCounter() {
        return this.modificationsCounterMax;
    }

    public final byte getPlatform() {
        return this.startupInfo[1];
    }

    public final byte getApplicationType() {
        return this.startupInfo[2];
    }

    public final boolean isConfidentialSessionModeSupported() {
        return this.isConfidentialSessionModeSupported;
    }

    public final boolean isDeselectRatificationSupported() {
        return this.isDeselectRatificationSupported;
    }

    public final boolean isSvFeatureAvailable() {
        return this.isSvFeatureAvailable;
    }

    public final boolean isPinFeatureAvailable() {
        return this.isPinFeatureAvailable;
    }

    public final boolean isPublicAuthenticationSupported() {
        return this.isPublicAuthenticationSupported;
    }

    public final byte getApplicationSubtype() {
        return this.startupInfo[3];
    }

    public final byte getSoftwareIssuer() {
        return this.startupInfo[4];
    }

    public final byte getSoftwareVersion() {
        return this.startupInfo[5];
    }

    public final byte getSoftwareRevision() {
        return this.startupInfo[6];
    }

    public final byte getSessionModification() {
        return this.startupInfo[0];
    }

    public final boolean isDfInvalidated() {
        return this.isDfInvalidated;
    }

    public final boolean isDfRatified() {
        if (this.isDfRatified != null) {
            return this.isDfRatified;
        }
        throw new IllegalStateException("Unable to determine the ratification status. No session was opened.");
    }

    final void setSvData(int svBalance, int svLastTNum, SvLoadLogRecord svLoadLogRecord, SvDebitLogRecord svDebitLogRecord) {
        this.svBalance = svBalance;
        this.svLastTNum = svLastTNum;
        if (this.svLoadLogRecord == null) {
            this.svLoadLogRecord = svLoadLogRecord;
        }
        if (this.svDebitLogRecord == null) {
            this.svDebitLogRecord = svDebitLogRecord;
        }
    }

    public final int getSvBalance() {
        if (this.svBalance == null) {
            throw new IllegalStateException("No SV Get command has been executed.");
        }
        return this.svBalance;
    }

    public final int getSvLastTNum() {
        if (this.svBalance == null) {
            throw new IllegalStateException("No SV Get command has been executed.");
        }
        return this.svLastTNum;
    }

    public final SvLoadLogRecord getSvLoadLogRecord() {
        if (this.svLoadLogRecord == null) {
            byte[] logRecord = this.getFileBySfi((byte)20).getData().getContent();
            this.svLoadLogRecord = new SvLoadLogRecord(logRecord, 0);
        }
        return this.svLoadLogRecord;
    }

    public final SvDebitLogRecord getSvDebitLogLastRecord() {
        if (this.svDebitLogRecord == null) {
            List<SvDebitLogRecord> svDebitLogRecords = this.getSvDebitLogAllRecords();
            this.svDebitLogRecord = svDebitLogRecords.get(0);
        }
        return this.svDebitLogRecord;
    }

    public final List<SvDebitLogRecord> getSvDebitLogAllRecords() {
        SortedMap<Integer, byte[]> logRecords = this.getFileBySfi((byte)21).getData().getAllRecordsContent();
        ArrayList<SvDebitLogRecord> svDebitLogRecords = new ArrayList<SvDebitLogRecord>();
        for (Map.Entry<Integer, byte[]> entry : logRecords.entrySet()) {
            svDebitLogRecords.add(new SvDebitLogRecord(entry.getValue(), 0));
        }
        return svDebitLogRecords;
    }

    final void setDfRatified(boolean dfRatified) {
        this.isDfRatified = dfRatified;
    }

    protected final PoClass getPoClass() {
        return this.poClass;
    }

    public final DirectoryHeader getDirectoryHeader() {
        return this.directoryHeader;
    }

    final CalypsoPo setDirectoryHeader(DirectoryHeader directoryHeader) {
        this.directoryHeader = directoryHeader;
        return this;
    }

    public final ElementaryFile getFileBySfi(byte sfi) {
        ElementaryFile ef = this.efBySfi.get(sfi);
        if (ef == null) {
            throw new NoSuchElementException("EF with SFI [0x" + Integer.toHexString(sfi & 0xFF) + "] is not found.");
        }
        return ef;
    }

    public final ElementaryFile getFileByLid(short lid) {
        Byte sfi = this.sfiByLid.get(lid);
        if (sfi == null) {
            throw new NoSuchElementException("EF with LID [" + Integer.toHexString(lid & 0xFFFF) + "] is not found.");
        }
        return this.efBySfi.get(sfi);
    }

    public final Map<Byte, ElementaryFile> getAllFiles() {
        return this.efBySfi;
    }

    private ElementaryFile getOrCreateFile(byte sfi) {
        ElementaryFile ef = this.efBySfi.get(sfi);
        if (ef == null) {
            ef = new ElementaryFile(sfi);
            this.efBySfi.put(sfi, ef);
        }
        return ef;
    }

    public final boolean isPinBlocked() {
        return this.getPinAttemptRemaining() == 0;
    }

    public final int getPinAttemptRemaining() {
        if (this.pinAttemptCounter == null) {
            throw new IllegalStateException("PIN status has not been checked.");
        }
        return this.pinAttemptCounter;
    }

    final void setPinAttemptRemaining(int pinAttemptCounter) {
        this.pinAttemptCounter = pinAttemptCounter;
    }

    final void setFileHeader(byte sfi, FileHeader header) {
        ElementaryFile ef = this.getOrCreateFile(sfi);
        ef.setHeader(header);
        this.sfiByLid.put(header.getLid(), sfi);
    }

    final void setContent(byte sfi, int numRecord, byte[] content) {
        ElementaryFile ef = this.getOrCreateFile(sfi);
        ef.getData().setContent(numRecord, content);
    }

    final void setCounter(byte sfi, int numCounter, byte[] content) {
        ElementaryFile ef = this.getOrCreateFile(sfi);
        ef.getData().setCounter(numCounter, content);
    }

    final void setContent(byte sfi, int numRecord, byte[] content, int offset) {
        ElementaryFile ef = this.getOrCreateFile(sfi);
        ef.getData().setContent(numRecord, content, offset);
    }

    final void fillContent(byte sfi, int numRecord, byte[] content) {
        ElementaryFile ef = this.getOrCreateFile(sfi);
        ef.getData().fillContent(numRecord, content);
    }

    final void addCyclicContent(byte sfi, byte[] content) {
        ElementaryFile ef = this.getOrCreateFile(sfi);
        ef.getData().addCyclicContent(content);
    }

    final void backupFiles() {
        CalypsoPo.copyMapFiles(this.efBySfi, this.efBySfiBackup);
        CalypsoPo.copyMapSfi(this.sfiByLid, this.sfiByLidBackup);
    }

    final void restoreFiles() {
        CalypsoPo.copyMapFiles(this.efBySfiBackup, this.efBySfi);
        CalypsoPo.copyMapSfi(this.sfiByLidBackup, this.sfiByLid);
    }

    private static void copyMapFiles(Map<Byte, ElementaryFile> src, Map<Byte, ElementaryFile> dest) {
        dest.clear();
        for (Map.Entry<Byte, ElementaryFile> entry : src.entrySet()) {
            dest.put(entry.getKey(), new ElementaryFile(entry.getValue()));
        }
    }

    private static void copyMapSfi(Map<Short, Byte> src, Map<Short, Byte> dest) {
        dest.clear();
        dest.putAll(src);
    }
}

