/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.sam.builder.security;

import org.eclipse.keyple.calypso.command.sam.AbstractSamCommandBuilder;
import org.eclipse.keyple.calypso.command.sam.CalypsoSamCommand;
import org.eclipse.keyple.calypso.command.sam.SamRevision;
import org.eclipse.keyple.calypso.command.sam.parser.security.SamWriteKeyRespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;

public class SamWriteKeyCmdBuild
extends AbstractSamCommandBuilder<SamWriteKeyRespPars> {
    private static final CalypsoSamCommand command = CalypsoSamCommand.WRITE_KEY;

    public SamWriteKeyCmdBuild(SamRevision revision, byte writingMode, byte keyReference, byte[] keyData) {
        super(command, null);
        if (revision != null) {
            this.defaultRevision = revision;
        }
        byte cla = this.defaultRevision.getClassByte();
        if (keyData == null) {
            throw new IllegalArgumentException("Key data null!");
        }
        if (keyData.length < 48 || keyData.length > 80) {
            throw new IllegalArgumentException("Key data should be between 40 and 80 bytes long!");
        }
        this.request = this.setApduRequest(cla, command, writingMode, keyReference, keyData, null);
    }

    @Override
    public SamWriteKeyRespPars createResponseParser(ApduResponse apduResponse) {
        return new SamWriteKeyRespPars(apduResponse, this);
    }
}

