/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.sam.builder.security;

import org.eclipse.keyple.calypso.command.sam.AbstractSamCommandBuilder;
import org.eclipse.keyple.calypso.command.sam.CalypsoSamCommand;
import org.eclipse.keyple.calypso.command.sam.SamRevision;
import org.eclipse.keyple.calypso.command.sam.parser.security.SamReadKeyParametersRespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;

public class SamReadKeyParametersCmdBuild
extends AbstractSamCommandBuilder<SamReadKeyParametersRespPars> {
    private static final CalypsoSamCommand command = CalypsoSamCommand.READ_KEY_PARAMETERS;
    public static final int MAX_WORK_KEY_REC_NUMB = 126;

    public SamReadKeyParametersCmdBuild(SamRevision revision) {
        super(command, null);
        if (revision != null) {
            this.defaultRevision = revision;
        }
        byte cla = this.defaultRevision.getClassByte();
        byte p2 = -32;
        byte[] sourceKeyId = new byte[]{0, 0};
        this.request = this.setApduRequest(cla, command, (byte)0, p2, sourceKeyId, (byte)0);
    }

    public SamReadKeyParametersCmdBuild(SamRevision revision, byte kif) {
        super(command, null);
        if (revision != null) {
            this.defaultRevision = revision;
        }
        byte cla = this.defaultRevision.getClassByte();
        byte p2 = -64;
        byte[] sourceKeyId = new byte[]{0, 0};
        sourceKeyId[0] = kif;
        this.request = this.setApduRequest(cla, command, (byte)0, p2, sourceKeyId, (byte)0);
    }

    public SamReadKeyParametersCmdBuild(SamRevision revision, byte kif, byte kvc) {
        super(command, null);
        if (revision != null) {
            this.defaultRevision = revision;
        }
        byte cla = this.defaultRevision.getClassByte();
        byte p2 = -16;
        byte[] sourceKeyId = new byte[]{0, 0};
        sourceKeyId[0] = kif;
        sourceKeyId[1] = kvc;
        this.request = this.setApduRequest(cla, command, (byte)0, p2, sourceKeyId, (byte)0);
    }

    public SamReadKeyParametersCmdBuild(SamRevision revision, SourceRef sourceKeyRef, int recordNumber) {
        super(command, null);
        if (revision != null) {
            this.defaultRevision = revision;
        }
        if (recordNumber < 1 || recordNumber > 126) {
            throw new IllegalArgumentException("Record Number must be between 1 and 126.");
        }
        byte cla = this.defaultRevision.getClassByte();
        byte p2 = 0;
        byte[] sourceKeyId = new byte[]{0, 0};
        switch (sourceKeyRef) {
            case WORK_KEY: {
                p2 = (byte)recordNumber;
                break;
            }
            case SYSTEM_KEY: {
                p2 = (byte)(192 + (byte)recordNumber);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported SourceRef parameter " + sourceKeyRef.toString());
            }
        }
        this.request = this.setApduRequest(cla, command, (byte)0, p2, sourceKeyId, (byte)0);
    }

    public SamReadKeyParametersCmdBuild(SamRevision revision, byte kif, NavControl navControl) {
        super(command, null);
        if (revision != null) {
            this.defaultRevision = revision;
        }
        byte cla = this.defaultRevision.getClassByte();
        byte p2 = 0;
        byte[] sourceKeyId = new byte[]{0, 0};
        switch (navControl) {
            case FIRST: {
                p2 = -8;
                break;
            }
            case NEXT: {
                p2 = -6;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported NavControl parameter " + navControl.toString());
            }
        }
        sourceKeyId[0] = kif;
        this.request = this.setApduRequest(cla, command, (byte)0, p2, sourceKeyId, (byte)0);
    }

    @Override
    public SamReadKeyParametersRespPars createResponseParser(ApduResponse apduResponse) {
        return new SamReadKeyParametersRespPars(apduResponse, this);
    }

    public static enum NavControl {
        FIRST,
        NEXT;

    }

    public static enum SourceRef {
        WORK_KEY,
        SYSTEM_KEY;

    }
}

