/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.sam.builder.security;

import org.eclipse.keyple.calypso.command.sam.AbstractSamCommandBuilder;
import org.eclipse.keyple.calypso.command.sam.CalypsoSamCommand;
import org.eclipse.keyple.calypso.command.sam.SamRevision;
import org.eclipse.keyple.calypso.command.sam.parser.security.SamReadEventCounterRespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;

public class SamReadEventCounterCmdBuild
extends AbstractSamCommandBuilder<SamReadEventCounterRespPars> {
    private static final CalypsoSamCommand command = CalypsoSamCommand.READ_EVENT_COUNTER;
    public static final int MAX_COUNTER_NUMB = 26;
    public static final int MAX_COUNTER_REC_NUMB = 3;

    public SamReadEventCounterCmdBuild(SamRevision revision, SamEventCounterOperationType operationType, int index) {
        super(command, null);
        byte p2;
        if (revision != null) {
            this.defaultRevision = revision;
        }
        byte cla = this.defaultRevision.getClassByte();
        if (operationType == SamEventCounterOperationType.COUNTER_RECORD) {
            if (index < 1 || index > 3) {
                throw new IllegalArgumentException("Record Number must be between 1 and 3.");
            }
            p2 = (byte)(224 + index);
        } else {
            if (index < 0 || index > 26) {
                throw new IllegalArgumentException("Counter Number must be between 0 and 26.");
            }
            p2 = (byte)(128 + index);
        }
        this.request = this.setApduRequest(cla, command, (byte)0, p2, null, (byte)0);
    }

    @Override
    public SamReadEventCounterRespPars createResponseParser(ApduResponse apduResponse) {
        return new SamReadEventCounterRespPars(apduResponse, this);
    }

    public static enum SamEventCounterOperationType {
        COUNTER_RECORD,
        SINGLE_COUNTER;

    }
}

