/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.sam.builder.security;

import org.eclipse.keyple.calypso.command.sam.AbstractSamCommandBuilder;
import org.eclipse.keyple.calypso.command.sam.CalypsoSamCommand;
import org.eclipse.keyple.calypso.command.sam.SamRevision;
import org.eclipse.keyple.calypso.command.sam.parser.security.SamReadCeilingsRespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;

public class SamReadCeilingsCmdBuild
extends AbstractSamCommandBuilder<SamReadCeilingsRespPars> {
    private static final CalypsoSamCommand command = CalypsoSamCommand.READ_CEILINGS;
    public static final int MAX_CEILING_NUMB = 26;
    public static final int MAX_CEILING_REC_NUMB = 3;

    public SamReadCeilingsCmdBuild(SamRevision revision, CeilingsOperationType operationType, int index) {
        super(command, null);
        byte p2;
        byte p1;
        if (revision != null) {
            this.defaultRevision = revision;
        }
        byte cla = this.defaultRevision.getClassByte();
        if (operationType == CeilingsOperationType.CEILING_RECORD) {
            if (index < 0 || index > 3) {
                throw new IllegalArgumentException("Record Number must be between 1 and 3.");
            }
            p1 = 0;
            p2 = (byte)(176 + index);
        } else {
            if (index < 0 || index > 26) {
                throw new IllegalArgumentException("Counter Number must be between 0 and 26.");
            }
            p1 = (byte)index;
            p2 = -72;
        }
        this.request = this.setApduRequest(cla, command, p1, p2, null, (byte)0);
    }

    @Override
    public SamReadCeilingsRespPars createResponseParser(ApduResponse apduResponse) {
        return new SamReadCeilingsRespPars(apduResponse, this);
    }

    public static enum CeilingsOperationType {
        CEILING_RECORD,
        SINGLE_CEILING;

    }
}

