/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.sam.builder.security;

import org.eclipse.keyple.calypso.command.sam.AbstractSamCommandBuilder;
import org.eclipse.keyple.calypso.command.sam.CalypsoSamCommand;
import org.eclipse.keyple.calypso.command.sam.SamRevision;
import org.eclipse.keyple.calypso.command.sam.parser.security.DigestUpdateMultipleRespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;

public class DigestUpdateMultipleCmdBuild
extends AbstractSamCommandBuilder<DigestUpdateMultipleRespPars> {
    private static final CalypsoSamCommand command = CalypsoSamCommand.DIGEST_UPDATE_MULTIPLE;

    public DigestUpdateMultipleCmdBuild(SamRevision revision, boolean encryptedSession, byte[] digestData) {
        super(command, null);
        byte p2;
        if (revision != null) {
            this.defaultRevision = revision;
        }
        byte cla = this.defaultRevision.getClassByte();
        byte p1 = 0;
        byte by = p2 = encryptedSession ? (byte)-128 : 0;
        if (digestData == null || digestData.length > 255) {
            throw new IllegalArgumentException("Digest data null or too long!");
        }
        this.request = this.setApduRequest(cla, command, p1, p2, digestData, null);
    }

    @Override
    public DigestUpdateMultipleRespPars createResponseParser(ApduResponse apduResponse) {
        return new DigestUpdateMultipleRespPars(apduResponse, this);
    }
}

