/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.sam.builder.security;

import org.eclipse.keyple.calypso.command.sam.AbstractSamCommandBuilder;
import org.eclipse.keyple.calypso.command.sam.CalypsoSamCommand;
import org.eclipse.keyple.calypso.command.sam.SamRevision;
import org.eclipse.keyple.calypso.command.sam.parser.security.DigestInitRespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;

public class DigestInitCmdBuild
extends AbstractSamCommandBuilder<DigestInitRespPars> {
    private static final CalypsoSamCommand command = CalypsoSamCommand.DIGEST_INIT;

    public DigestInitCmdBuild(SamRevision revision, boolean verificationMode, boolean confidentialSessionMode, byte workKeyRecordNumber, byte workKeyKif, byte workKeyKVC, byte[] digestData) {
        super(command, null);
        byte[] dataIn;
        if (revision != null) {
            this.defaultRevision = revision;
        }
        if (workKeyRecordNumber == 0 && (workKeyKif == 0 || workKeyKVC == 0)) {
            throw new IllegalArgumentException("Bad key record number, kif or kvc!");
        }
        if (digestData == null) {
            throw new IllegalArgumentException("Digest data is null!");
        }
        byte cla = SamRevision.S1D.equals((Object)this.defaultRevision) ? (byte)-108 : -128;
        byte p1 = 0;
        if (verificationMode) {
            p1 = (byte)(p1 + 1);
        }
        if (confidentialSessionMode) {
            p1 = (byte)(p1 + 2);
        }
        byte p2 = -1;
        if (workKeyKif == -1) {
            p2 = workKeyRecordNumber;
        }
        if (p2 == -1) {
            dataIn = new byte[2 + digestData.length];
            dataIn[0] = workKeyKif;
            dataIn[1] = workKeyKVC;
            System.arraycopy(digestData, 0, dataIn, 2, digestData.length);
        } else {
            dataIn = digestData;
        }
        this.request = this.setApduRequest(cla, CalypsoSamCommand.DIGEST_INIT, p1, p2, dataIn, null);
    }

    @Override
    public DigestInitRespPars createResponseParser(ApduResponse apduResponse) {
        return new DigestInitRespPars(apduResponse, this);
    }
}

