/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.sam.builder.security;

import org.eclipse.keyple.calypso.KeyReference;
import org.eclipse.keyple.calypso.command.sam.AbstractSamCommandBuilder;
import org.eclipse.keyple.calypso.command.sam.CalypsoSamCommand;
import org.eclipse.keyple.calypso.command.sam.SamRevision;
import org.eclipse.keyple.calypso.command.sam.parser.security.CardGenerateKeyRespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;

public class CardGenerateKeyCmdBuild
extends AbstractSamCommandBuilder<CardGenerateKeyRespPars> {
    private static final CalypsoSamCommand command = CalypsoSamCommand.CARD_GENERATE_KEY;

    public CardGenerateKeyCmdBuild(SamRevision revision, KeyReference cipheringKey, KeyReference sourceKey) {
        super(command, null);
        byte[] data;
        byte p2;
        byte p1;
        if (revision != null) {
            this.defaultRevision = revision;
        }
        if (sourceKey == null) {
            throw new IllegalArgumentException("The source key reference can't be null.");
        }
        byte cla = this.defaultRevision.getClassByte();
        if (cipheringKey == null) {
            p1 = -1;
            p2 = 0;
            data = new byte[]{sourceKey.getKif(), sourceKey.getKvc(), -112};
        } else {
            p1 = -1;
            p2 = -1;
            data = new byte[]{cipheringKey.getKif(), cipheringKey.getKvc(), sourceKey.getKif(), sourceKey.getKvc(), -112};
        }
        this.request = this.setApduRequest(cla, command, p1, p2, data, null);
    }

    @Override
    public CardGenerateKeyRespPars createResponseParser(ApduResponse apduResponse) {
        return new CardGenerateKeyRespPars(apduResponse, this);
    }
}

