/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.sam.builder.security;

import org.eclipse.keyple.calypso.KeyReference;
import org.eclipse.keyple.calypso.command.sam.AbstractSamCommandBuilder;
import org.eclipse.keyple.calypso.command.sam.CalypsoSamCommand;
import org.eclipse.keyple.calypso.command.sam.SamRevision;
import org.eclipse.keyple.calypso.command.sam.parser.security.CardCipherPinRespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;

public class CardCipherPinCmdBuild
extends AbstractSamCommandBuilder<CardCipherPinRespPars> {
    private static final CalypsoSamCommand command = CalypsoSamCommand.CARD_CIPHER_PIN;

    public CardCipherPinCmdBuild(SamRevision revision, KeyReference cipheringKey, byte[] currentPin, byte[] newPin) {
        super(command, null);
        byte[] data;
        byte p1;
        if (revision != null) {
            this.defaultRevision = revision;
        }
        if (currentPin == null || currentPin.length != 4) {
            throw new IllegalArgumentException("Bad current PIN value.");
        }
        if (newPin != null && newPin.length != 4) {
            throw new IllegalArgumentException("Bad new PIN value.");
        }
        byte cla = this.defaultRevision.getClassByte();
        if (newPin == null) {
            p1 = -128;
            data = new byte[6];
        } else {
            p1 = 64;
            data = new byte[10];
            System.arraycopy(newPin, 0, data, 6, 4);
        }
        byte p2 = -1;
        data[0] = cipheringKey.getKif();
        data[1] = cipheringKey.getKvc();
        System.arraycopy(currentPin, 0, data, 2, 4);
        this.request = this.setApduRequest(cla, command, p1, p2, data, null);
    }

    @Override
    public CardCipherPinRespPars createResponseParser(ApduResponse apduResponse) {
        return new CardCipherPinRespPars(apduResponse, this);
    }
}

