/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.parser.storedvalue;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.keyple.calypso.command.po.AbstractPoResponseParser;
import org.eclipse.keyple.calypso.command.po.builder.storedvalue.SvGetCmdBuild;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoIllegalParameterException;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoSecurityContextException;
import org.eclipse.keyple.calypso.command.sam.exception.CalypsoSamAccessForbiddenException;
import org.eclipse.keyple.calypso.transaction.SvDebitLogRecord;
import org.eclipse.keyple.calypso.transaction.SvLoadLogRecord;
import org.eclipse.keyple.core.card.command.AbstractApduResponseParser;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.eclipse.keyple.core.util.ByteArrayUtil;

public final class SvGetRespPars
extends AbstractPoResponseParser {
    private static final Map<Integer, AbstractApduResponseParser.StatusProperties> STATUS_TABLE;
    private final byte currentKVC;
    private final int transactionNumber;
    private final byte[] previousSignatureLo;
    private final byte[] challengeOut;
    private final int balance;
    private final byte[] svCommandHeader;
    private final SvLoadLogRecord loadLog;
    private final SvDebitLogRecord debitLog;

    protected Map<Integer, AbstractApduResponseParser.StatusProperties> getStatusTable() {
        return STATUS_TABLE;
    }

    public SvGetRespPars(byte[] svCommandHeader, ApduResponse response, SvGetCmdBuild builder) {
        super(response, builder);
        byte[] poResponse = response.getDataOut();
        this.svCommandHeader = svCommandHeader;
        switch (poResponse.length) {
            case 30: 
            case 33: {
                this.challengeOut = new byte[2];
                this.previousSignatureLo = new byte[3];
                this.currentKVC = poResponse[0];
                this.transactionNumber = ByteArrayUtil.twoBytesToInt((byte[])poResponse, (int)1);
                System.arraycopy(poResponse, 3, this.previousSignatureLo, 0, 3);
                this.challengeOut[0] = poResponse[6];
                this.challengeOut[1] = poResponse[7];
                this.balance = ByteArrayUtil.threeBytesSignedToInt((byte[])poResponse, (int)8);
                if (poResponse.length == 33) {
                    this.loadLog = new SvLoadLogRecord(poResponse, 11);
                    this.debitLog = null;
                    break;
                }
                this.loadLog = null;
                this.debitLog = new SvDebitLogRecord(poResponse, 11);
                break;
            }
            case 61: {
                this.challengeOut = new byte[8];
                this.previousSignatureLo = new byte[6];
                System.arraycopy(poResponse, 0, this.challengeOut, 0, 8);
                this.currentKVC = poResponse[8];
                this.transactionNumber = ByteArrayUtil.twoBytesToInt((byte[])poResponse, (int)9);
                System.arraycopy(poResponse, 11, this.previousSignatureLo, 0, 6);
                this.balance = ByteArrayUtil.threeBytesSignedToInt((byte[])poResponse, (int)17);
                this.loadLog = new SvLoadLogRecord(poResponse, 20);
                this.debitLog = new SvDebitLogRecord(poResponse, 42);
                break;
            }
            default: {
                throw new IllegalStateException("Incorrect data length in response to SVGet");
            }
        }
    }

    public byte[] getSvGetCommandHeader() {
        return this.svCommandHeader;
    }

    public byte getCurrentKVC() {
        return this.currentKVC;
    }

    public int getTransactionNumber() {
        return this.transactionNumber;
    }

    public byte[] getPreviousSignatureLo() {
        return this.previousSignatureLo;
    }

    public byte[] getChallengeOut() {
        return this.challengeOut;
    }

    public int getBalance() {
        return this.balance;
    }

    public SvLoadLogRecord getLoadLog() {
        return this.loadLog;
    }

    public SvDebitLogRecord getDebitLog() {
        return this.debitLog;
    }

    static {
        HashMap<Integer, AbstractApduResponseParser.StatusProperties> m = new HashMap<Integer, AbstractApduResponseParser.StatusProperties>(AbstractApduResponseParser.STATUS_TABLE);
        m.put(27010, new AbstractApduResponseParser.StatusProperties("Security conditions not fulfilled.", CalypsoPoSecurityContextException.class));
        m.put(27013, new AbstractApduResponseParser.StatusProperties("Preconditions not satisfied (a store value operation was already done in the current session).", CalypsoSamAccessForbiddenException.class));
        m.put(27265, new AbstractApduResponseParser.StatusProperties("Incorrect P1 or P2.", CalypsoPoIllegalParameterException.class));
        m.put(27270, new AbstractApduResponseParser.StatusProperties("Le inconsistent with P2.", CalypsoPoIllegalParameterException.class));
        m.put(27904, new AbstractApduResponseParser.StatusProperties("SV function not present.", CalypsoPoIllegalParameterException.class));
        STATUS_TABLE = m;
    }
}

