/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.parser.security;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.keyple.calypso.command.po.AbstractPoResponseParser;
import org.eclipse.keyple.calypso.command.po.builder.security.VerifyPinCmdBuild;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoAccessForbiddenException;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoIllegalParameterException;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoPinException;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoSecurityContextException;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoTerminatedException;
import org.eclipse.keyple.core.card.command.AbstractApduResponseParser;
import org.eclipse.keyple.core.card.message.ApduResponse;

public class VerifyPinRespPars
extends AbstractPoResponseParser {
    private static final Map<Integer, AbstractApduResponseParser.StatusProperties> STATUS_TABLE;

    public VerifyPinRespPars(ApduResponse response, VerifyPinCmdBuild builder) {
        super(response, builder);
    }

    public int getRemainingAttemptCounter() {
        int attemptCounter;
        switch (this.response.getStatusCode()) {
            case 27011: {
                attemptCounter = 0;
                break;
            }
            case 25537: {
                attemptCounter = 1;
                break;
            }
            case 25538: {
                attemptCounter = 2;
                break;
            }
            case 36864: {
                attemptCounter = 3;
                break;
            }
            default: {
                throw new IllegalStateException("Incorrect status word: " + String.format("0x%04X", this.response.getStatusCode()));
            }
        }
        return attemptCounter;
    }

    protected Map<Integer, AbstractApduResponseParser.StatusProperties> getStatusTable() {
        return STATUS_TABLE;
    }

    static {
        HashMap<Integer, AbstractApduResponseParser.StatusProperties> m = new HashMap<Integer, AbstractApduResponseParser.StatusProperties>(AbstractApduResponseParser.STATUS_TABLE);
        m.put(26368, new AbstractApduResponseParser.StatusProperties("Lc value not supported (only 00h, 04h or 08h are supported).", CalypsoPoIllegalParameterException.class));
        m.put(26880, new AbstractApduResponseParser.StatusProperties("Transaction Counter is 0.", CalypsoPoTerminatedException.class));
        m.put(27010, new AbstractApduResponseParser.StatusProperties("Security conditions not fulfilled (Get Challenge not done: challenge unavailable).", CalypsoPoSecurityContextException.class));
        m.put(27013, new AbstractApduResponseParser.StatusProperties("Access forbidden (a session is open or DF is invalidated).", CalypsoPoAccessForbiddenException.class));
        m.put(25537, new AbstractApduResponseParser.StatusProperties("Incorrect PIN (1 attempt remaining).", CalypsoPoPinException.class));
        m.put(25538, new AbstractApduResponseParser.StatusProperties("Incorrect PIN (2 attempt remaining).", CalypsoPoPinException.class));
        m.put(27011, new AbstractApduResponseParser.StatusProperties("Presentation rejected (PIN is blocked).", CalypsoPoPinException.class));
        m.put(27904, new AbstractApduResponseParser.StatusProperties("PIN function not present.", CalypsoPoIllegalParameterException.class));
        STATUS_TABLE = m;
    }
}

