/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.parser.security;

import java.util.Arrays;
import org.eclipse.keyple.calypso.command.po.PoRevision;
import org.eclipse.keyple.calypso.command.po.builder.security.OpenSession24CmdBuild;
import org.eclipse.keyple.calypso.command.po.parser.security.AbstractOpenSessionRespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;

public final class OpenSession24RespPars
extends AbstractOpenSessionRespPars {
    public OpenSession24RespPars(ApduResponse response, OpenSession24CmdBuild builder) {
        super(response, builder, PoRevision.REV2_4);
    }

    @Override
    AbstractOpenSessionRespPars.SecureSession toSecureSession(byte[] apduResponseData) {
        return OpenSession24RespPars.createSecureSession(apduResponseData);
    }

    public static AbstractOpenSessionRespPars.SecureSession createSecureSession(byte[] apduResponseData) {
        byte[] data;
        boolean previousSessionRatified;
        switch (apduResponseData.length) {
            case 5: {
                previousSessionRatified = true;
                data = new byte[]{};
                break;
            }
            case 34: {
                previousSessionRatified = true;
                data = Arrays.copyOfRange(apduResponseData, 5, 34);
                break;
            }
            case 7: {
                previousSessionRatified = false;
                data = new byte[]{};
                break;
            }
            case 36: {
                previousSessionRatified = false;
                data = Arrays.copyOfRange(apduResponseData, 7, 36);
                break;
            }
            default: {
                throw new IllegalStateException("Bad response length to Open Secure Session: " + apduResponseData.length);
            }
        }
        byte kvc = apduResponseData[0];
        return new AbstractOpenSessionRespPars.SecureSession(Arrays.copyOfRange(apduResponseData, 1, 4), Arrays.copyOfRange(apduResponseData, 4, 5), previousSessionRatified, false, kvc, data, apduResponseData);
    }
}

