/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.parser.security;

import java.util.Arrays;
import org.eclipse.keyple.calypso.command.po.PoRevision;
import org.eclipse.keyple.calypso.command.po.builder.security.OpenSession10CmdBuild;
import org.eclipse.keyple.calypso.command.po.parser.security.AbstractOpenSessionRespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;

public final class OpenSession10RespPars
extends AbstractOpenSessionRespPars {
    public OpenSession10RespPars(ApduResponse response, OpenSession10CmdBuild builder) {
        super(response, builder, PoRevision.REV1_0);
    }

    @Override
    AbstractOpenSessionRespPars.SecureSession toSecureSession(byte[] apduResponseData) {
        return OpenSession10RespPars.createSecureSession(apduResponseData);
    }

    public static AbstractOpenSessionRespPars.SecureSession createSecureSession(byte[] apduResponseData) {
        byte[] data;
        boolean previousSessionRatified;
        switch (apduResponseData.length) {
            case 4: {
                previousSessionRatified = true;
                data = new byte[]{};
                break;
            }
            case 33: {
                previousSessionRatified = true;
                data = Arrays.copyOfRange(apduResponseData, 4, 33);
                break;
            }
            case 6: {
                previousSessionRatified = false;
                data = new byte[]{};
                break;
            }
            case 35: {
                previousSessionRatified = false;
                data = Arrays.copyOfRange(apduResponseData, 6, 35);
                break;
            }
            default: {
                throw new IllegalStateException("Bad response length to Open Secure Session: " + apduResponseData.length);
            }
        }
        return new AbstractOpenSessionRespPars.SecureSession(Arrays.copyOfRange(apduResponseData, 0, 3), Arrays.copyOfRange(apduResponseData, 3, 4), previousSessionRatified, false, null, data, apduResponseData);
    }
}

